package com.st.stellar.component.model.editor;

import org.eclipse.emf.common.notify.Notifier
import org.eclipse.emfforms.common.Optional
import org.eclipse.emfforms.spi.swt.treemasterdetail.LabelDecoratorProvider
import org.eclipse.jface.viewers.ILabelDecorator
import org.eclipse.jface.viewers.TreeViewer

class ComponentLabelDecoratorProvider implements LabelDecoratorProvider {
	final Notifier input
	ComponentLabelServiceDecorator decorator
	final MyDiagnosticCache cache

	/** 
	 * Default constructor.
	 * @param input the notifier which we will display the diagnostics
	 */
	new(Notifier input) {
		this(input, new MyDiagnosticCache(input))
	}

	/** 
	 * Default constructor.
	 * @param input the notifier which we will display the diagnostics
	 * @param cache the cache to use.
	 */
	new(Notifier input, MyDiagnosticCache cache) {
		this.input = input
		this.cache = cache
	}

	override Optional<ILabelDecorator> getLabelDecorator(TreeViewer viewer) {
		decorator = new ComponentLabelServiceDecorator(viewer, input, cache)
		return Optional.<ILabelDecorator>of(decorator)
	}

	override void dispose() {
		decorator.dispose()
	}
}
