/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.model.editor;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.API.Utils;
import com.st.stellar.component.Application;
import com.st.stellar.component.Component;
import com.st.stellar.component.ComponentPackage;
import com.st.stellar.component.ComponentReference;
import com.st.stellar.component.model.editor.ApplicationLabelDecoratorProvider;
import com.st.stellar.component.model.editor.CustomCommandStackListener;
import com.st.stellar.component.model.editor.MyGenericEditor;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.swt.treemasterdetail.LabelDecoratorProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.MenuProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailComposite;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailSWTBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailSWTFactory;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ApplicationFormsEditor
extends MyGenericEditor {
    MyResourceHandler resourceHandler = null;
    private CustomCommandStackListener ccsl;

    protected String getEditorTitle() {
        return "Application editor";
    }

    protected Object modifyEditorInput(ResourceSet resourceSet) {
        ResourceSet res = resourceSet;
        TreeIterator it = this.getResourceSet().getAllContents();
        while (it.hasNext()) {
            Notifier type = (Notifier)it.next();
            if (!(type instanceof Application)) continue;
            Application comp = (Application)type;
            return comp.eResource();
        }
        return res;
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        TreeIterator it = this.getResourceSet().getAllContents();
        while (it.hasNext()) {
            Notifier type = (Notifier)it.next();
            if (!(type instanceof Application)) continue;
            Application app = (Application)type;
            Generator generator = new Generator();
            generator.setInput((Object)app);
            ComponentAPI.refreshExternalDependencies((Application)app);
            System.out.println("saved");
        }
    }

    protected Map<Object, Object> getResourceSaveOptions() {
        Map saveOptions = super.getResourceSaveOptions();
        if (this.resourceHandler == null) {
            this.resourceHandler = new MyResourceHandler(this);
        }
        saveOptions.put("RESOURCE_HANDLER", this.resourceHandler);
        return saveOptions;
    }

    protected TreeMasterDetailComposite createTreeMasterDetail(Composite composite, Object editorInput, CreateElementCallback createElementCallback) {
        TreeMasterDetailSWTBuilder builder = TreeMasterDetailSWTFactory.fillDefaults((Composite)composite, (int)0, (Object)editorInput).customizeCildCreation(createElementCallback).customizeMenu(new MenuProvider(){

            public Menu getMenu(TreeViewer treeViewer, EditingDomain editingDomain) {
                ApplicationFormsEditor.this.ccsl = new CustomCommandStackListener(editingDomain);
                editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)ApplicationFormsEditor.this.ccsl);
                treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        Object obj;
                        IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                        if (!ss.isEmpty() && ComponentReference.class.isInstance(obj = ss.getFirstElement())) {
                            ComponentReference sr = (ComponentReference)ComponentReference.class.cast(obj);
                            ApplicationFormsEditor.this.setAttributeValue((EObject)sr, ComponentPackage.eINSTANCE.getComponentReference_Enabled(), sr.isEnabled() ? "false" : "true");
                        }
                    }
                });
                treeViewer.getTree().addListener(32, event -> {
                    Tree tree = (Tree)event.widget;
                    Point point = new Point(event.x, event.y);
                    TreeItem item = tree.getItem(point);
                    if (item != null) {
                        Object data = item.getData();
                        if (data != null) {
                            tree.setToolTipText(ApplicationFormsEditor.this.getTooltipTextForElement(data));
                        } else {
                            tree.setToolTipText(null);
                        }
                    } else {
                        tree.setToolTipText(null);
                    }
                });
                return null;
            }
        }).customizeTree(this.createTreeViewerBuilder()).customizeReadOnly(!this.isEditable(this.getEditorInput())).customizeInitialTreeWidth(250).customizeLabelDecorator((LabelDecoratorProvider)new ApplicationLabelDecoratorProvider(this.getNotifierFromEditorInput(editorInput)));
        TreeMasterDetailComposite treeMasterDetail = builder.create();
        treeMasterDetail.setFocus();
        return treeMasterDetail;
    }

    private String getTooltipTextForElement(Object element) {
        IFile appFile;
        IProject project;
        String name;
        URI objectUri;
        Application app;
        EObject obj;
        ComponentReference ref;
        EObject parent;
        if (ComponentReference.class.isInstance(element) && Application.class.isInstance(parent = (ref = (ComponentReference)ComponentReference.class.cast(element)).eContainer()) && (obj = ComponentAPI.getEObject((Application)(app = (Application)Application.class.cast(parent)), (URI)(objectUri = URI.createPlatformResourceURI((String)(name = "/" + (project = (appFile = Utils.getFileFromResource((URI)app.eResource().getURI())).getProject()).getName() + "/" + ref.getUri()), (boolean)true)).appendFragment(""))) instanceof Component) {
            Component comp = (Component)obj;
            Object requiredFeatures = "";
            if (comp.getRequiredFeatures().size() > 0) {
                requiredFeatures = "Required features:\n" + Utils.removeDuplicates((List)comp.getRequiredFeatures()).stream().map(it -> "    " + it).collect(Collectors.joining("\n"));
            }
            Object features = "";
            if (comp.getExportedFeatures().size() > 0) {
                if (((String)requiredFeatures).length() > 0) {
                    features = "\n";
                }
                features = (String)features + "Exported features:\n" + Utils.removeDuplicates((List)comp.getExportedFeatures()).stream().map(it -> "    " + it).collect(Collectors.joining("\n"));
            }
            return (String)requiredFeatures + (String)features;
        }
        return null;
    }

    @Override
    public void dispose() {
        EditingDomain ed = this.getEditingDomain();
        if (ed != null && this.ccsl != null) {
            ed.getCommandStack().removeCommandStackListener((CommandStackListener)this.ccsl);
        }
        super.dispose();
    }

    protected List<Action> getToolbarActions() {
        LinkedList<Action> result = new LinkedList<Action>();
        if (!this.isEditable(this.getEditorInput())) {
            return result;
        }
        result.addAll(this.readToolbarActions());
        return result;
    }

    private void setAttributeValue(EObject object, EAttribute attribute, String value) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        EClassifier eClassifier = attribute.getEType();
        if (eClassifier instanceof EDataType) {
            EDataType eDataType = (EDataType)eClassifier;
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            Object newValue = eFactory.createFromString(eDataType, value);
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)attribute, (Object)newValue);
            editingDomain.getCommandStack().execute(command);
        }
    }

    private class MyResourceHandler
    extends BasicResourceHandler {
        private MyResourceHandler(ApplicationFormsEditor applicationFormsEditor) {
        }

        public void postSave(XMLResource resource, OutputStream outputStream, Map<?, ?> options) {
            super.postSave(resource, outputStream, options);
        }
    }
}

