/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.model.editor;

import com.st.stellar.component.Application;
import com.st.stellar.component.model.editor.MyDiagnosticCache;
import java.util.Arrays;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfforms.spi.swt.core.ui.SWTValidationHelper;
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class ComponentLabelServiceDecorator
implements ILabelDecorator {
    private final MyDiagnosticCache cache;
    private final TreeViewer viewer;
    private final ResourceManager images;

    public ComponentLabelServiceDecorator(TreeViewer viewer, Notifier input, MyDiagnosticCache cache) {
        this.viewer = viewer;
        this.cache = cache;
        Display _display = viewer.getControl().getDisplay();
        DeviceResourceManager _deviceResourceManager = new DeviceResourceManager((Device)_display);
        this.images = _deviceResourceManager;
        DiagnosticCache.ValidationListener _function = (object, potentialStructuralChange) -> {
            if (potentialStructuralChange) {
                for (EObject o : object) {
                    this.refreshViewer(o);
                }
            } else {
                boolean _not;
                for (EObject o_1 : object) {
                    this.updateViewer(o_1);
                }
                boolean _isEmpty = object.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    EObject _rootContainer;
                    EObject comp = _rootContainer = EcoreUtil.getRootContainer((EObject)((EObject[])Conversions.unwrapArray((Object)object, EObject.class))[0]);
                    cache.updateCache(comp);
                }
            }
        };
        cache.registerValidationListener(_function);
        viewer.refresh();
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return image;
        }
        if (!EObject.class.isInstance(element) && !Resource.class.isInstance(element)) {
            return image;
        }
        Diagnostic diagnostic = (Diagnostic)this.cache.getCachedValue(element);
        int severity = diagnostic.getSeverity();
        ImageDescriptor validationOverlayDescriptor = SWTValidationHelper.INSTANCE.getValidationOverlayDescriptor(severity);
        if (validationOverlayDescriptor == null) {
            return image;
        }
        Rectangle bounds = image.getBounds();
        Point size = new Point(bounds.width, bounds.height);
        DecorationOverlayIcon icon = new DecorationOverlayIcon(image, new ImageDescriptor[]{validationOverlayDescriptor}, size);
        Image _get = (Image)this.images.get((DeviceResourceDescriptor)icon);
        return _get;
    }

    protected void refreshViewer(EObject element) {
        this.viewer.refresh((Object)element, true);
    }

    protected void updateViewer(EObject element) {
        this.viewer.update((Object)element, null);
    }

    public String decorateText(String text, Object element) {
        return this.format(element, text);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.cache.dispose();
        this.images.dispose();
    }

    protected String _format(Application object, String text) {
        return object.getName();
    }

    protected String _format(EObject object, String text) {
        return text;
    }

    protected String _format(Object object, String text) {
        return text;
    }

    @XbaseGenerated
    public String format(Object object, String text) {
        if (object instanceof Application) {
            return this._format((Application)object, text);
        }
        if (object instanceof EObject) {
            return this._format((EObject)object, text);
        }
        if (object != null) {
            return this._format(object, text);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(object, text).toString());
    }
}

