/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.model.editor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.Application;
import com.st.stellar.component.DerivedAttributesNotifier;
import com.st.stellar.component.DisposalAdapter;
import com.st.stellar.component.model.ui.ComponentEditorToolBar;
import java.io.File;
import java.net.URI;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfforms.spi.editor.GenericEditor;
import org.eclipse.emfforms.spi.editor.IEditingDomainAware;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailComposite;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class MyGenericEditor
extends GenericEditor {
    Resource resource = null;
    private DisposalAdapter disposalAdapter;
    @Inject
    Provider<ResourceSet> rsp;
    private ComponentEditorToolBar toolbar = null;

    protected ResourceSet loadResource(IEditorInput editorInput) throws PartInitException {
        ResourceSet rs = super.loadResource(editorInput);
        this.disposalAdapter = new DisposalAdapter();
        rs.eAdapters().add((Object)this.disposalAdapter);
        rs.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(ResourceSet.class) == 0 && notification.getEventType() == 4) {
                    Resource removedResource = (Resource)notification.getOldValue();
                    MyGenericEditor.this.handleResourceRemoval(removedResource);
                }
            }
        });
        return rs;
    }

    private void handleResourceRemoval(Resource removedResource) {
        System.out.println("Resource removed: " + String.valueOf(removedResource.getURI()));
    }

    public static void resolveAllProxies(ResourceSet resourceSet) {
        int rsSize = resourceSet.getResources().size();
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        while (rsSize != resourceSet.getResources().size()) {
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            rsSize = resourceSet.getResources().size();
        }
    }

    public void dispose() {
        super.dispose();
        System.out.println(String.valueOf(this.getEditorInput()) + " disposed");
        if (this.resource != null) {
            ResourceSet rs = this.resource.getResourceSet();
            TreeIterator it = rs.getAllContents();
            while (it.hasNext()) {
                Notifier type = (Notifier)it.next();
                if (!EObject.class.isInstance(type)) continue;
                DerivedAttributesNotifier.remove((EObject)((EObject)EObject.class.cast(type)));
            }
            this.resource.unload();
            if (rs != null) {
                rs.getResources().remove((Object)this.resource);
                rs.eAdapters().remove((Object)this.disposalAdapter);
            }
        }
        if (this.toolbar != null) {
            this.toolbar.dispose();
        }
        ComponentAPI.removeEditingDomain((String)this.getNsPrefix());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    protected String getNsPrefix() {
        FileEditorInput fileEditorInput = (FileEditorInput)FileEditorInput.class.cast(this.getEditorInput());
        URI fileUri = fileEditorInput.getURI();
        File file = new File(fileUri);
        String fileName = file.getName();
        TreeIterator it = this.getResourceSet().getAllContents();
        Object prefix = "";
        while (it.hasNext()) {
            Notifier type = (Notifier)it.next();
            if (!(type instanceof Application)) continue;
            Application comp = (Application)type;
            EClass eClass = comp.eClass();
            EPackage ePackage = eClass.getEPackage();
            prefix = ePackage.getNsPrefix() + "_" + fileName;
            return prefix;
        }
        return "";
    }

    protected TreeMasterDetailComposite createRootView(Composite parent, String editorTitle, Object editorInput, List<Action> toolbarActions, CreateElementCallback createElementCallback) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        FormData toolbarLayoutData = new FormData();
        toolbarLayoutData.left = new FormAttachment(0);
        toolbarLayoutData.right = new FormAttachment(100);
        toolbarLayoutData.top = new FormAttachment(0);
        this.toolbar = new ComponentEditorToolBar(composite, 0, editorTitle, toolbarActions);
        this.toolbar.setLayoutData((Object)toolbarLayoutData);
        FormData treeMasterDetailLayoutData = new FormData();
        treeMasterDetailLayoutData.top = new FormAttachment((Control)this.toolbar, 5);
        treeMasterDetailLayoutData.left = new FormAttachment(0);
        treeMasterDetailLayoutData.right = new FormAttachment(100);
        treeMasterDetailLayoutData.bottom = new FormAttachment(100);
        TreeMasterDetailComposite treeMasterDetail = this.createTreeMasterDetail(composite, editorInput, createElementCallback);
        treeMasterDetail.setLayoutData((Object)treeMasterDetailLayoutData);
        for (Action action : toolbarActions) {
            if (!(action instanceof IEditingDomainAware)) continue;
            ((IEditingDomainAware)action).setEditingDomain(this.getEditingDomain());
        }
        return treeMasterDetail;
    }
}

