package com.st.stellar.component.model.editor;

import com.st.stellar.component.Application
import com.st.stellar.component.ComponentReference
import com.st.stellar.component.model.ui.ComponentDiagnosticCache
import com.st.stellar.component.model.ui.ComponentValidationLabelDecoratorProvider
import com.st.stellar.component.model.ui.ComponentValidationServiceLabelDecorator
import org.eclipse.emf.common.notify.Notifier
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emfforms.common.Optional
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache
import org.eclipse.jface.viewers.ILabelDecorator
import org.eclipse.jface.viewers.TreeViewer
import com.st.stellar.component.API.Utils

class ApplicationLabelDecoratorProvider extends ComponentValidationLabelDecoratorProvider {

	new(Notifier input) {
		super(input, new ComponentDiagnosticCache(input))
	}

	override Optional<ILabelDecorator> getLabelDecorator(TreeViewer viewer) {
		decorator = new MyLabelServiceDecorator(viewer, input, cache)
		return Optional.<ILabelDecorator>of(decorator)
	}
}

class MyLabelServiceDecorator extends ComponentValidationServiceLabelDecorator {

	new(TreeViewer viewer, Notifier input, DiagnosticCache cache) {
		super(viewer, input, cache)
	}

	override String decorateText(String text, Object element) {
	    return this.format(element, text);
	}

	dispatch def format(Application object, String text) {
		return object.name
	}

	dispatch def format(ComponentReference p, String text) {
		val error = Diagnostician.INSTANCE.validate(p);

		if (error.getSeverity() == Diagnostic.OK) {
			return p.uri
		} else {
			val mess = Utils.populateDiagnostics(error, 99)
			if (mess !== null && !mess.isEmpty) {
				return p.uri + " -> " + mess;
			} else {
				return p.uri
			}
		}
	}

	dispatch def format(EObject object, String text) {
		return text
	}

	dispatch def format(Object object, String text) {
		return text
	}

}
