package com.st.stellar.component.model.editor

import java.util.LinkedHashSet
import org.eclipse.emf.common.notify.Notifier
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.ecore.EObject
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache

class MyDiagnosticCache extends DiagnosticCache {
	
	new(Notifier input) {
		super(input)
//
//		val rootObjects = new LinkedHashSet
//		if (ResourceSet.isInstance(input)) {
//			val resources = ResourceSet.cast(input).resources
//			for( r : resources) {
//			r.allContents.forEachRemaining(i|rootObjects.addAll(i))
//			}
//		} else if (Resource.isInstance(input)) {
//			Resource.cast(input).allContents.forEachRemaining(it|rootObjects.addAll(it))
//			return;
//		}
//
//		updateCache(rootObjects, this);
	}
//	override void updateCache(Set<EObject> elements, DiagnosticCache cache) {
//		val updates = new LinkedHashSet<EObject>(elements);
//		for (element : elements) {
//			val diagnostic = getDiagnostic(element);
//			val update = cache.update(element, diagnostic);
//			updates.addAll(update);
//		}
//		notifyValidationListeners(updates, true);
//
//	}

	def void updateCache(EObject comp) {
		
		val updates = new LinkedHashSet
		comp.eResource.allContents.forEachRemaining(it|updates.addAll(it))
		//updates.stream.forEach(it|println(it))
		for (element : updates) {
			val diagnostic = getDiagnostic(element);
			val update = update(element, diagnostic);
			updates.addAll(update);
		}
		notifyValidationListeners(updates, true);
	}

	/**
	 * Recursively walks down the containment hierarchy of the given root object and puts the children's diagnostics
	 * into the cache of root's cached tree node. Afterwards, the most severe diagnostic of root's subtree (including
	 * root) is returned which allows caching it in root's parent.
	 * 
	 * @param root The root object of the current depth first search
	 * @return The most severe Diagnostic in the subtree of the root object
	 */
	def Diagnostic cacheUpdate(EObject root) {
		val treeNode = getNodes().get(root);
		if (root === null) {
			return getDefaultValue();
		}
		root.eContents().stream()
			.forEach(c | treeNode.putIntoCache(c, cacheUpdate(c)));
		return treeNode.getDisplayValue();
	}
	
	
}
