/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.model.ui;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.model.ui.ComponentEditor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ApplicationResourceChangeListener
implements IResourceChangeListener {
    static long DELAY = 5000L;
    Set<IResource> resourcesToBeRemoved = new HashSet<IResource>();
    Set<IResource> toBeAdded = new HashSet<IResource>();
    Set<IResource> toBeChanged = new HashSet<IResource>();
    private Job job = new Job("Modify Resources"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(IProgressMonitor monitor) throws CoreException {
                        boolean mustRefresh = false;
                        System.out.println(ApplicationResourceChangeListener.this.resourcesToBeRemoved.size() + " resources to be removed");
                        Set<IResource> set = ApplicationResourceChangeListener.this.resourcesToBeRemoved;
                        synchronized (set) {
                            mustRefresh = ApplicationResourceChangeListener.this.resourcesToBeRemoved.size() > 0;
                        }
                        System.out.println(ApplicationResourceChangeListener.this.toBeChanged.size() + " resources to be changed");
                        set = ApplicationResourceChangeListener.this.toBeChanged;
                        synchronized (set) {
                            mustRefresh = ApplicationResourceChangeListener.this.toBeChanged.size() > 0;
                        }
                        System.out.println(ApplicationResourceChangeListener.this.toBeAdded.size() + " resources to be added");
                        set = ApplicationResourceChangeListener.this.toBeAdded;
                        synchronized (set) {
                            mustRefresh = ApplicationResourceChangeListener.this.toBeAdded.size() > 0;
                        }
                        if (mustRefresh) {
                            ComponentAPI.addResources(ApplicationResourceChangeListener.this.toBeAdded);
                            ApplicationResourceChangeListener.this.refreshEditors();
                        }
                        set = ApplicationResourceChangeListener.this.resourcesToBeRemoved;
                        synchronized (set) {
                            ApplicationResourceChangeListener.this.resourcesToBeRemoved.clear();
                        }
                        set = ApplicationResourceChangeListener.this.toBeChanged;
                        synchronized (set) {
                            ApplicationResourceChangeListener.this.toBeChanged.clear();
                        }
                        set = ApplicationResourceChangeListener.this.toBeAdded;
                        synchronized (set) {
                            ApplicationResourceChangeListener.this.toBeAdded.clear();
                        }
                    }
                }, monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    };

    public ApplicationResourceChangeListener() {
        this.job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean visit(IResourceDelta delta) {
                    if (delta.getKind() == 2) {
                        IResource resource = delta.getResource();
                        Set<IResource> set = ApplicationResourceChangeListener.this.resourcesToBeRemoved;
                        synchronized (set) {
                            ApplicationResourceChangeListener.this.resourcesToBeRemoved.add(resource);
                        }
                        ApplicationResourceChangeListener.this.job.schedule(DELAY);
                    } else if (delta.getKind() == 1) {
                        IResource resource = delta.getResource();
                        Set<IResource> set = ApplicationResourceChangeListener.this.toBeAdded;
                        synchronized (set) {
                            ApplicationResourceChangeListener.this.toBeAdded.add(resource);
                        }
                        ApplicationResourceChangeListener.this.job.schedule(DELAY);
                    } else if (delta.getKind() == 4) {
                        IResource resource = delta.getResource();
                        Set<IResource> set = ApplicationResourceChangeListener.this.toBeChanged;
                        synchronized (set) {
                            ApplicationResourceChangeListener.this.toBeChanged.add(resource);
                        }
                        ApplicationResourceChangeListener.this.job.schedule(DELAY);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void refreshEditors() {
        System.out.println("Refreshing editors...");
        Display.getDefault().asyncExec(new Runnable(this){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return;
                }
                IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                if (workbenchWindow == null) {
                    return;
                }
                IWorkbenchPage page = workbenchWindow.getActivePage();
                if (page == null) {
                    return;
                }
                for (IEditorReference ed : page.getEditorReferences()) {
                    IEditorPart editor = ed.getEditor(true);
                    if (editor == null || !(editor instanceof ComponentEditor) || !ComponentEditor.class.isInstance(editor)) continue;
                    ComponentEditor componentEditor = (ComponentEditor)((Object)ComponentEditor.class.cast(editor));
                    componentEditor.refresh();
                }
            }
        });
    }
}

