/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.model.ui;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.Component;
import com.st.stellar.component.Dependency;
import com.st.stellar.component.DerivedAttributesNotifier;
import com.st.stellar.component.model.ui.ComponentEditorToolBar;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.editor.GenericEditor;
import org.eclipse.emfforms.spi.editor.IEditingDomainAware;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailComposite;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ComponentEditor
extends GenericEditor {
    private ComponentEditorToolBar toolbar;
    protected EObject rootComponent = null;
    protected Set<Dependency> dependencies = new HashSet<Dependency>();

    protected Map<Object, Object> getResourceSaveOptions() {
        Map saveOptions = super.getResourceSaveOptions();
        saveOptions.put("RESOURCE_HANDLER", new MyResourceHandler(this));
        return saveOptions;
    }

    protected TreeMasterDetailComposite createRootView(Composite parent, String editorTitle, Object editorInput, List<Action> toolbarActions, CreateElementCallback createElementCallback) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        FormData toolbarLayoutData = new FormData();
        toolbarLayoutData.left = new FormAttachment(0);
        toolbarLayoutData.right = new FormAttachment(100);
        toolbarLayoutData.top = new FormAttachment(0);
        this.toolbar = new ComponentEditorToolBar(composite, 0, editorTitle, toolbarActions);
        this.toolbar.setLayoutData(toolbarLayoutData);
        FormData treeMasterDetailLayoutData = new FormData();
        treeMasterDetailLayoutData.top = new FormAttachment((Control)this.toolbar, 5);
        treeMasterDetailLayoutData.left = new FormAttachment(0);
        treeMasterDetailLayoutData.right = new FormAttachment(100);
        treeMasterDetailLayoutData.bottom = new FormAttachment(100);
        TreeMasterDetailComposite treeMasterDetail = this.createTreeMasterDetail(composite, editorInput, createElementCallback);
        ComponentAPI.addEditingDomain((String)this.getNsPrefix(), (EditingDomain)treeMasterDetail.getEditingDomain());
        treeMasterDetail.setLayoutData((Object)treeMasterDetailLayoutData);
        for (Action action : toolbarActions) {
            if (!(action instanceof IEditingDomainAware)) continue;
            ((IEditingDomainAware)action).setEditingDomain(this.getEditingDomain());
        }
        return treeMasterDetail;
    }

    protected void declareDependencies(EObject root) {
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.rootComponent = ComponentAPI.analyzeDependencies((EditingDomain)this.getEditingDomain());
        this.declareDependencies(this.rootComponent);
        this.refresh();
    }

    public void dispose() {
        IEditorReference[] editorRefs;
        super.dispose();
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        for (IEditorReference iEditorReference : editorRefs = page.getEditorReferences()) {
            IEditorInput clockInput;
            IFile clockFile;
            IEditorPart editor;
            IEditorInput input;
            IFile file;
            if (!iEditorReference.getId().equals("com.st.stellar.wizard.engine.editors.WizardsEngineEditor") || !(file = (IFile)(input = (editor = iEditorReference.getEditor(true)).getEditorInput()).getAdapter(IFile.class)).equals((Object)(clockFile = (IFile)(clockInput = this.getEditorInput()).getAdapter(IFile.class)))) continue;
            page.closeEditor(editor, false);
        }
        if (this.toolbar != null) {
            this.toolbar.dispose();
        }
        System.out.println(String.valueOf(this.getEditorInput()) + " disposed");
        if (this.getEditingDomain() != null) {
            ResourceSet rs = this.getEditingDomain().getResourceSet();
            TreeIterator it2 = rs.getAllContents();
            while (it2.hasNext()) {
                Notifier type = (Notifier)it2.next();
                if (!EObject.class.isInstance(type)) continue;
                DerivedAttributesNotifier.remove((EObject)((EObject)EObject.class.cast(type)));
            }
        }
        ComponentAPI.removeEditingDomain((String)this.getNsPrefix());
        this.dependencies.stream().forEach(it -> it.dispose());
        this.dependencies.clear();
    }

    protected List<Action> getToolbarActions() {
        LinkedList<Action> result = new LinkedList<Action>();
        if (!this.isEditable(this.getEditorInput())) {
            return result;
        }
        result.addAll(this.readToolbarActions());
        return result;
    }

    protected void setAttributeValue(EObject object, EAttribute attribute, String value) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        EClassifier eClassifier = attribute.getEType();
        if (eClassifier instanceof EDataType) {
            EDataType eDataType = (EDataType)eClassifier;
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            Object newValue = eFactory.createFromString(eDataType, value);
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)attribute, (Object)newValue);
            editingDomain.getCommandStack().execute(command);
        }
    }

    protected String getNsPrefix() {
        if (this.getResourceSet() != null) {
            TreeIterator it = this.getResourceSet().getAllContents();
            while (it.hasNext()) {
                Notifier type = (Notifier)it.next();
                if (!(type instanceof Component)) continue;
                Component comp = (Component)type;
                return comp.eResource().getURI().toString();
            }
        }
        return "";
    }

    public void refresh() {
        this.refreshDependencies();
        this.refreshTreeAfterResourceChange();
    }

    private void refreshDependencies() {
        if (this.dependencies.size() > 0) {
            this.dependencies.stream().forEach(Dependency::dispose);
            this.dependencies.clear();
        }
        this.declareDependencies(this.rootComponent);
    }

    public <T> T getAdapter(Class<T> key) {
        if (key.equals(EditingDomain.class)) {
            return (T)this.getEditingDomain();
        }
        return (T)super.getAdapter(key);
    }

    private class MyResourceHandler
    extends BasicResourceHandler {
        private MyResourceHandler(ComponentEditor componentEditor) {
        }

        public void postSave(XMLResource resource, OutputStream outputStream, Map<?, ?> options) {
            super.postSave(resource, outputStream, options);
        }
    }
}

