/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.API;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.st.stellar.component.Application;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class);
    private static boolean debugOption = false;

    public static IFile getFileFromResource(URI uri) {
        try {
            boolean _isPlatformResource = uri.isPlatformResource();
            if (_isPlatformResource) {
                String platformString = uri.toPlatformString(true);
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                Path _path = new Path(platformString);
                IFile file = workspaceRoot.getFile((IPath)_path);
                return file;
            }
            boolean _isFile = uri.isFile();
            if (_isFile) {
                boolean _greaterThan;
                String _string;
                java.net.URI _uRI;
                IWorkspaceRoot workspaceRoot_1 = ResourcesPlugin.getWorkspace().getRoot();
                IFile[] files = workspaceRoot_1.findFilesForLocationURI(_uRI = new java.net.URI(_string = uri.toString()));
                int _length = files.length;
                boolean bl = _greaterThan = _length > 0;
                if (_greaterThan) {
                    return files[0];
                }
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static URI getResolvedImportUri(Resource context, URI uri) {
        URI uriRes = uri;
        URI contextURI = context.getURI();
        if (contextURI.isHierarchical() && !contextURI.isRelative() && uri.isRelative() && !uri.isEmpty()) {
            uriRes = uri.resolve(contextURI);
        }
        return uriRes;
    }

    public static Resource getResource(Resource context, String uriStr) {
        Resource res = null;
        if (uriStr != null && context != null) {
            try {
                boolean _greaterThan;
                URI newURI = Utils.getResolvedImportUri(context, URI.createURI((String)uriStr));
                ResourceSet rs = context.getResourceSet();
                Resource r = rs.getResource(newURI, true);
                if (r != null) {
                    r.load(context.getResourceSet().getLoadOptions());
                    EcoreUtil.resolveAll((Resource)r);
                }
                if (r == null) {
                    return null;
                }
                int _size = r.getContents().size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    res = r;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    LOG.error((Object)e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return res;
    }

    public static List<Application> getApplicationModels(Resource context, IProject project, String suffix) {
        try {
            ArrayList<IPath> files = new ArrayList<IPath>();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            ResourceSet resourceSet = context.getResourceSet();
            ProjectVisitor visitor = new ProjectVisitor(files, suffix);
            ArrayList<Application> handles = new ArrayList<Application>();
            try {
                project.accept((IResourceProxyVisitor)visitor, 0);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    LOG.error((Object)e.getMessage());
                    return handles;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Iterator<IPath> iter = files.iterator();
            while (iter.hasNext()) {
                IPath _next;
                IPath p = _next = iter.next();
                String _name = project.getName();
                String _plus = "/" + _name;
                String _plus_1 = _plus + "/";
                String _string = p.toString();
                String _plus_2 = _plus_1 + _string;
                Path path = new Path(_plus_2);
                IFile f = workspaceRoot.getFile((IPath)path);
                String decodedUri = "";
                try {
                    EObject comp;
                    boolean _isInstance;
                    decodedUri = URLDecoder.decode(f.getProjectRelativePath().toOSString(), "UTF-8");
                    Resource loadResource = Utils.getResource(context, decodedUri);
                    if (loadResource == null) continue;
                    loadResource.load(resourceSet.getLoadOptions());
                    EList contents = loadResource.getContents();
                    boolean _isEmpty = contents.isEmpty();
                    boolean _not = !_isEmpty;
                    if (!_not || !(_isInstance = Application.class.isInstance(comp = (EObject)contents.get(0)))) continue;
                    handles.add((Application)Application.class.cast(comp));
                }
                catch (Throwable _t) {
                    if (_t instanceof IllegalStateException) {
                        IllegalStateException e = (IllegalStateException)_t;
                        LOG.error((Object)e.getMessage());
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            return handles;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static List<IFile> findFilesWithExtension(IProject project, final String ext) {
        ArrayList files;
        ArrayList _xblockexpression;
        block2: {
            _xblockexpression = null;
            files = CollectionLiterals.newArrayList();
            try {
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        boolean _xblockexpression = false;
                        if (resource != null && resource instanceof IFile && resource.getFileExtension() != null && resource.getFileExtension().equals(ext)) {
                            files.add((IFile)resource);
                        }
                        _xblockexpression = true;
                        return _xblockexpression;
                    }
                });
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) break block2;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        _xblockexpression = files;
        return _xblockexpression;
    }

    public static String populateDiagnostics(Diagnostic diag) {
        return Utils.populateDiagnostics(diag, -1);
    }

    public static String populateDiagnostics(Diagnostic diag, int filterCode) {
        String _xblockexpression = null;
        HashSet<Diagnostic> diags = new HashSet<Diagnostic>();
        Utils.populateDiagnostics(diag, diags, filterCode);
        StringBuffer mess = new StringBuffer();
        Functions.Function1 _function = it -> filterCode == -1 || it.getCode() == filterCode;
        Functions.Function1 _function_1 = it -> it.getMessage();
        Consumer<String> _function_2 = it -> mess.append((String)it).append("\n");
        IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
        _xblockexpression = mess.toString();
        return _xblockexpression;
    }

    private static void populateDiagnostics(Diagnostic diag, Set<Diagnostic> errorsList, int filterCode) {
        List errors = diag.getChildren();
        if (errors != null) {
            boolean _greaterThan;
            int _size = errors.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                for (Diagnostic e : errors) {
                    errorsList.add(e);
                    Utils.populateDiagnostics(e, errorsList, filterCode);
                }
            } else {
                errorsList.add(diag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateText(EObject eobject, String targetDir, String fileName, CharSequence text, Monitor monitor) {
        block8: {
            try {
                monitor.beginTask("", 3);
                try {
                    IFile ifile;
                    File file;
                    boolean _exists_1;
                    boolean _not_1;
                    boolean _not;
                    IProject project = Utils.getProjectFromEObject(eobject);
                    IFolder folder = project.getFolder(targetDir);
                    boolean _exists = folder.exists();
                    boolean bl = _not = !_exists;
                    if (_not) {
                        Utils.createRecursive((IContainer)folder);
                    }
                    boolean bl2 = _not_1 = !(_exists_1 = (file = (ifile = project.getFile(targetDir + "/" + fileName)).getRawLocation().makeAbsolute().toFile()).exists());
                    if (_not_1) {
                        file.createNewFile();
                    }
                    String _string = file.toString();
                    String _plus = "save to: " + _string;
                    InputOutput.println((Object)_plus);
                    Files.asCharSink((File)file, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]).write(text);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception exception = (Exception)_t;
                        CodeGenEcorePlugin.INSTANCE.log((Object)exception);
                        break block8;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public static void createRecursive(IContainer resource) {
        boolean _not;
        boolean _exists = resource.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            boolean _not_1;
            boolean _exists_1 = resource.getParent().exists();
            boolean bl2 = _not_1 = !_exists_1;
            if (_not_1) {
                Utils.createRecursive(resource.getParent());
            }
            if (resource instanceof IFolder) {
                try {
                    IFolder _cast = (IFolder)IFolder.class.cast(resource);
                    NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                    _cast.create(false, true, (IProgressMonitor)_nullProgressMonitor);
                }
                catch (Throwable _t) {
                    if (_t instanceof CoreException) {
                        CoreException e = (CoreException)_t;
                        CodeGenEcorePlugin.INSTANCE.log((Object)e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    public static IProject getProjectFromEObject(EObject eObject) {
        Path _path;
        if (eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        if (uri == null || !uri.isPlatformResource()) {
            return null;
        }
        String platformString = uri.toPlatformString(true);
        IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = _root.getFile((IPath)(_path = new Path(platformString)));
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public static List<String> removeDuplicates(List<String> stringList) {
        List uniqueList;
        List _xblockexpression = null;
        Set uniqueSet = IterableExtensions.toSet((Iterable)((List[])Conversions.unwrapArray((Object)CollectionLiterals.newLinkedHashSet((Object[])new List[]{stringList}), List.class))[0]);
        _xblockexpression = uniqueList = IterableExtensions.toList((Iterable)uniqueSet);
        return _xblockexpression;
    }

    public static void setDebugOption(boolean debug) {
        debugOption = debug;
    }

    public static boolean getDebugOption() {
        return debugOption;
    }

    public static class ProjectVisitor
    implements IResourceProxyVisitor {
        private List<IPath> _list;
        private String _extensions;

        public ProjectVisitor(List<IPath> list, String ext) {
            this._list = list;
            this._extensions = ext;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            String _name;
            Path path;
            boolean _checkComponent;
            boolean _equals;
            int _type = proxy.getType();
            boolean bl = _equals = _type == 1;
            if (_equals && (_checkComponent = this.checkComponent(path = new Path(_name = proxy.getName())))) {
                this._list.add((IPath)path);
            }
            return true;
        }

        public boolean checkComponent(Path path) {
            String[] _split;
            for (String e : _split = this._extensions.split(",")) {
                boolean _endsWith = path.toString().endsWith(e);
                if (!_endsWith) continue;
                return true;
            }
            return false;
        }
    }
}

