/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.impl;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.Application;
import com.st.stellar.component.AttributeAPI;
import com.st.stellar.component.AttributeReference;
import com.st.stellar.component.Component;
import com.st.stellar.external.api.ExternalAPIFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;

public class AttributeAPIImpl
implements AttributeAPI {
    EMap<String, EMap<String, List<AttributeReference>>> attributes = new BasicEMap();
    static Logger logger = LogManager.getLogger(AttributeAPIImpl.class);
    static int indent = 0;

    public AttributeAPIImpl() {
        ExternalAPIFactory.INSTANCE.declareAPI("AttributeAPI", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EAttribute getAttribute(EObject obj, String prefix, String attributeName) {
        Application app = ComponentAPI.getApplication(obj.eResource());
        EMap<String, EMap<String, List<AttributeReference>>> eMap = this.attributes;
        synchronized (eMap) {
            if (app == null) {
                return null;
            }
            Component dependentComponent = ComponentAPI.getConfigurator(app, prefix);
            Component root = ComponentAPI.getConfiguratorProperty(dependentComponent);
            if (root == null) {
                return null;
            }
            if (Component.class.isInstance(root)) {
                Component comp = (Component)Component.class.cast(root);
                EMap pluginsAttributes = (EMap)this.attributes.get((Object)attributeName);
                if (pluginsAttributes == null) {
                    System.err.println("No plugin provides attribute named '" + attributeName + "'");
                } else {
                    Set pluginSet = pluginsAttributes.keySet();
                    for (String plugin : pluginSet) {
                        if (!comp.getExportedFeatures().contains((Object)plugin)) continue;
                        String componentActualPlugin = comp.eClass().getEPackage().getNsPrefix();
                        ArrayList callbacks = (ArrayList)pluginsAttributes.get((Object)componentActualPlugin);
                        if (callbacks == null) {
                            callbacks = new ArrayList();
                            pluginsAttributes.put((Object)componentActualPlugin, callbacks);
                        }
                        for (AttributeReference callback : callbacks) {
                            EAttribute res = callback.getAttribute(obj);
                            if (res == null) continue;
                            return res;
                        }
                    }
                }
            } else {
                ComponentAPI.openConfiguratorInEditor(dependentComponent);
            }
        }
        logger.error((Object)String.format("Cannot find the attribute '%s' from plugin '%s'", attributeName, prefix));
        return null;
    }

    @Override
    public void addAttribute(String attributeNameName, AttributeReference callback, String ... pluginIds) {
        EMap pluginsAttributes = (EMap)this.attributes.get((Object)attributeNameName);
        if (pluginsAttributes == null) {
            pluginsAttributes = new BasicEMap();
            this.attributes.put((Object)attributeNameName, (Object)pluginsAttributes);
        }
        for (String pluginId : pluginIds) {
            ArrayList<AttributeReference> callbacks = (ArrayList<AttributeReference>)pluginsAttributes.get((Object)pluginId);
            if (callbacks == null) {
                callbacks = new ArrayList<AttributeReference>();
                pluginsAttributes.put((Object)pluginId, callbacks);
            }
            if (callbacks.contains(callback)) continue;
            callbacks.add(callback);
        }
    }
}

