/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.API;

import com.st.stellar.component.API.ExternalAttributeValueResult;
import com.st.stellar.component.API.Utils;
import com.st.stellar.component.Application;
import com.st.stellar.component.Component;
import com.st.stellar.component.ComponentPackage;
import com.st.stellar.component.ComponentReference;
import com.st.stellar.component.DerivedAttributesNotifier;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ComponentAPI {
    private static Logger logger = LogManager.getLogger(Utils.class);
    private static ComponentAPI eInstance = ComponentAPI.init();
    private static EMap<String, Boolean> enabledConfigurators = new BasicEMap();
    private Map<String, EditingDomain> editingDomains = CollectionLiterals.newHashMap();
    private static EMap<IProject, Application> applications = new BasicEMap();
    private static EMap<String, EMap<String, Component>> applicationConfigurators = new BasicEMap();
    private static EMap<String, EMap<String, EObject>> applicationEObjects = new BasicEMap();
    private static final String PATH_SEPARATOR = "/";
    private static final String SEGMENT_SEPARATOR = "@";
    private static EMap<String, DisplayPopupJob> displayPopupJobs = new BasicEMap();
    private static int indent = 0;

    public static ComponentAPI getInstance() {
        return eInstance;
    }

    public static ComponentAPI init() {
        return new ComponentAPI();
    }

    public static Boolean adaptEnabledConfigurator(String uri, boolean b) {
        return (Boolean)enabledConfigurators.put((Object)uri, (Object)b);
    }

    public static boolean isEnabled(EObject obj, String prefix) {
        boolean _tripleEquals;
        boolean _xblockexpression = false;
        Resource _eResource = obj.eResource();
        boolean bl = _tripleEquals = _eResource == null;
        if (_tripleEquals) {
            return false;
        }
        Application app = ComponentAPI.getApplication(obj.eResource());
        if (app == null || app.eResource() == null) {
            return false;
        }
        IFile appFile = Utils.getFileFromResource(app.eResource().getURI());
        IProject project = appFile.getProject();
        String _name = project.getName();
        String _plus = _name + PATH_SEPARATOR;
        String _plus_1 = _plus + prefix;
        Boolean enabled = (Boolean)enabledConfigurators.get((Object)_plus_1);
        if (enabled != null) {
            return enabled;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public static boolean isEnabled(EObject obj) {
        int pos;
        boolean _tripleEquals;
        boolean _xblockexpression = false;
        boolean _isBeingValidated = ComponentAPI.isBeingValidated();
        if (_isBeingValidated) {
            return false;
        }
        boolean _isCommandBeingEvaluated = ComponentAPI.isCommandBeingEvaluated();
        if (_isCommandBeingEvaluated) {
            return false;
        }
        Resource _eResource = obj.eResource();
        boolean bl = _tripleEquals = _eResource == null;
        if (_tripleEquals) {
            return false;
        }
        String uri = EcoreUtil.getURI((EObject)obj).toString();
        Boolean enabled = (Boolean)enabledConfigurators.get((Object)uri.substring(0, pos = uri.indexOf("#")));
        if (enabled != null) {
            return enabled;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public static boolean isEnabled(String uri) {
        Boolean enabled;
        boolean _xblockexpression = false;
        int pos = uri.indexOf("#");
        String uriRoot = uri;
        if (pos > 0) {
            uriRoot = uri.substring(0, pos);
        }
        if ((enabled = (Boolean)enabledConfigurators.get((Object)uriRoot)) != null) {
            return enabled;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public static void addEditingDomain(String nsPrefix, EditingDomain domain) {
        if (nsPrefix == null || nsPrefix.isEmpty()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("cannot add editing domain for: '");
            _builder.append(nsPrefix);
            _builder.append("' ");
            logger.error((Object)_builder);
        }
        ComponentAPI.eInstance.editingDomains.put(nsPrefix, domain);
    }

    public static void removeEditingDomain(String nsPrefix) {
        if (nsPrefix == null || nsPrefix.isEmpty()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("cannot remove editing domain for: '");
            _builder.append(nsPrefix);
            _builder.append("' ");
            logger.error((Object)_builder);
        }
        ComponentAPI.eInstance.editingDomains.put(nsPrefix, null);
    }

    public static EditingDomain getEditingDomain(String nsPrefix) {
        EditingDomain _xblockexpression = null;
        if (nsPrefix == null || nsPrefix.isEmpty()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("cannot remove editing domain for: '");
            _builder.append(nsPrefix);
            _builder.append("' ");
            logger.error((Object)_builder);
        }
        _xblockexpression = ComponentAPI.eInstance.editingDomains.get(nsPrefix);
        return _xblockexpression;
    }

    public static Application getApplication(Resource r) {
        Level _xifexpression = null;
        boolean _debugOption = Utils.getDebugOption();
        _xifexpression = _debugOption ? Level.DEBUG : Level.INFO;
        logger.setLevel(_xifexpression);
        if (r == null) {
            return null;
        }
        IFile ifile = Utils.getFileFromResource(r.getURI());
        IProject project = ifile.getProject();
        Application application = (Application)applications.get((Object)project);
        if (application == null) {
            application = ComponentAPI.getApplicationFromFile(project);
            if (application == null) {
                application = ComponentAPI.createApplication(r);
            }
            applications.put((Object)project, (Object)application);
            ComponentAPI.refreshApplication(application);
        }
        return application;
    }

    private static Application getApplicationFromFile(IProject project) {
        IFile appliFile;
        IPath path;
        URI loadUri;
        EObject a;
        boolean _isInstance;
        boolean _greaterThan;
        boolean _equals;
        List<IFile> applications = Utils.findFilesWithExtension(project, "appcfg");
        int _size = applications.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            return null;
        }
        int _size_1 = applications.size();
        boolean bl2 = _greaterThan = _size_1 > 1;
        if (_greaterThan) {
            logger.error((Object)"Must have only one appcfg file inside a project");
        }
        if (_isInstance = Application.class.isInstance(a = ComponentAPI.getEObject((loadUri = URI.createPlatformResourceURI((String)(path = (appliFile = applications.get(0)).getFullPath()).toString(), (boolean)true)).appendFragment("application")))) {
            Application app = (Application)Application.class.cast(a);
            return app;
        }
        return null;
    }

    public static Application createApplication(Resource r) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            IFile ifile = Utils.getFileFromResource(r.getURI());
            IProject project = ifile.getProject();
            String filePath = "application.appcfg";
            Path _path = new Path("application.appcfg");
            IFile appFile = project.getFile((IPath)_path);
            URI fileURI = URI.createPlatformResourceURI((String)appFile.getFullPath().toString(), (boolean)true);
            Resource resource = resourceSet.createResource(fileURI);
            Application app = ComponentPackage.eINSTANCE.getComponentFactory().createApplication();
            app.setName("application");
            String fileName = r.getURI().lastSegment();
            int _indexOf = fileName.indexOf(".");
            int _plus = _indexOf + 1;
            String suffix = fileName.substring(_plus);
            Collection<URI> _configurators = ComponentAPI.getConfigurators(r, appFile, suffix);
            for (URI c : _configurators) {
                ComponentReference ref = ComponentPackage.eINSTANCE.getComponentFactory().createComponentReference();
                ref.setUri(c.toFileString());
                String _name = project.getName();
                String _plus_1 = PATH_SEPARATOR + _name;
                String _plus_2 = _plus_1 + PATH_SEPARATOR;
                String name = _plus_2 + String.valueOf(c);
                URI objectUri = URI.createPlatformResourceURI((String)name, (boolean)true);
                EObject compObj = ComponentAPI.getEObject(objectUri.appendFragment(""));
                Component component = (Component)Component.class.cast(compObj);
                ComponentAPI.addConfiguratorToApplication(resource.toString(), component);
                ref.setEnabled(true);
                app.getComponents().add((Object)ref);
                ComponentAPI.adaptEnabledConfigurator(objectUri.toString(), true);
            }
            if (app != null) {
                resource.getContents().add((Object)app);
            }
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            try {
                resource.save(options);
            }
            catch (Throwable _t) {
                if (_t instanceof Resource.IOWrappedException) {
                    Resource.IOWrappedException e = (Resource.IOWrappedException)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            applications.put((Object)project, (Object)app);
            return app;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshApplication(Application application) {
        ComponentAPI componentAPI = eInstance;
        synchronized (componentAPI) {
            IFile appFile = Utils.getFileFromResource(application.eResource().getURI());
            IProject project = appFile.getProject();
            String appUri = application.eResource().getURI().path();
            EMap componentsUri = (EMap)applicationConfigurators.get((Object)appUri);
            if (componentsUri == null) {
                BasicEMap _basicEMap = new BasicEMap();
                componentsUri = _basicEMap;
                applicationConfigurators.put((Object)appUri, (Object)componentsUri);
            }
            List<String> _unmodifiableList = Collections.unmodifiableList(IterableExtensions.toList((Iterable)enabledConfigurators.keySet()));
            for (String en : _unmodifiableList) {
                String _name;
                String _plus;
                String name;
                URI projectUri;
                boolean _startsWith = en.startsWith((projectUri = URI.createPlatformResourceURI((String)(name = (_plus = PATH_SEPARATOR + (_name = project.getName())) + PATH_SEPARATOR), (boolean)true)).toString());
                if (!_startsWith) continue;
                enabledConfigurators.removeKey((Object)en);
                componentsUri.removeKey((Object)en);
            }
            EList<ComponentReference> _components = application.getComponents();
            for (ComponentReference ref : _components) {
                String _name = project.getName();
                String _plus = PATH_SEPARATOR + _name;
                String _plus_1 = _plus + PATH_SEPARATOR;
                String _uri = ref.getUri();
                String name = _plus_1 + _uri;
                URI objectUri = URI.createPlatformResourceURI((String)name, (boolean)true);
                ComponentAPI.setEnabledConfigurator(application, objectUri.toString(), ref.isEnabled());
            }
        }
    }

    public static Object refreshApplication(Resource r) {
        if (r == null) {
            return null;
        }
        IFile ifile = Utils.getFileFromResource(r.getURI());
        IProject project = ifile.getProject();
        applicationConfigurators.clear();
        ComponentAPI.refreshApplication(project);
        return null;
    }

    public static void refreshApplication(IProject project) {
        ComponentAPI.refreshApplication(project, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void refreshApplication(IProject project, boolean createIfNeeded) {
        try {
            boolean _equals;
            List<IFile> applicationList = Utils.findFilesWithExtension(project, "appcfg");
            Application application = null;
            int _size = applicationList.size();
            boolean bl = _equals = _size == 0;
            if (_equals) {
                if (!createIfNeeded) return;
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Map _extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
                XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
                _extensionToFactoryMap.put("*", _xMIResourceFactoryImpl);
                resourceSet.getPackageRegistry().put((Object)"http://www.st.com/stellar/component/2.1.0", (Object)ComponentPackage.eINSTANCE);
                String _name = project.getName();
                String _plus = PATH_SEPARATOR + _name;
                String _plus_1 = _plus + "/application.appcfg";
                Resource r = resourceSet.createResource(URI.createPlatformResourceURI((String)_plus_1, (boolean)true));
                application = ComponentAPI.createApplication(r);
                if (application == null) {
                    return;
                }
            } else {
                boolean _greaterThan;
                int _size_1 = applicationList.size();
                boolean bl2 = _greaterThan = _size_1 > 1;
                if (_greaterThan) {
                    logger.error((Object)"Must have only one appcfg file inside a project");
                    return;
                }
                IFile appliFile = applicationList.get(0);
                IPath path = appliFile.getFullPath();
                URI loadUri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
                EObject a = ComponentAPI.getEObject(loadUri.appendFragment("application"));
                boolean _isInstance = Application.class.isInstance(a);
                if (_isInstance) {
                    application = (Application)Application.class.cast(a);
                }
            }
            if (application == null) {
                return;
            }
            final Resource r_1 = application.eResource();
            String filePath = "application.appcfg";
            Path _path = new Path("application.appcfg");
            IFile appFile = project.getFile((IPath)_path);
            boolean toBeSaved = false;
            Collection<URI> _configurators = ComponentAPI.getConfigurators(r_1, appFile);
            for (URI c : _configurators) {
                Functions.Function1 _function = it -> it.getUri().equals(c.toFileString());
                ComponentReference old = (ComponentReference)IterableExtensions.findFirst(application.getComponents(), (Functions.Function1)_function);
                if (old != null) continue;
                ComponentReference ref = ComponentPackage.eINSTANCE.getComponentFactory().createComponentReference();
                ref.setUri(c.toFileString());
                ref.setEnabled(true);
                application.getComponents().add((Object)ref);
                String _name_1 = project.getName();
                String _plus_2 = PATH_SEPARATOR + _name_1;
                String _plus_3 = _plus_2 + PATH_SEPARATOR;
                String name = _plus_3 + String.valueOf(c);
                URI objectUri = URI.createPlatformResourceURI((String)name, (boolean)true);
                ComponentAPI.setEnabledConfigurator(application, objectUri.toString(), true);
                toBeSaved = true;
            }
            ArrayList toBeRemoved = CollectionLiterals.newArrayList();
            EList<ComponentReference> _components = application.getComponents();
            for (ComponentReference comp : _components) {
                boolean _checkUriExists = ComponentAPI.checkUriExists(project, comp.getUri());
                boolean _not = !_checkUriExists;
                if (!_not) continue;
                toBeRemoved.add(comp);
                toBeSaved = true;
            }
            int count = toBeRemoved.size();
            int originalSize = application.getComponents().size();
            for (ComponentReference comp_1 : toBeRemoved) {
                boolean _remove = application.getComponents().remove((Object)comp_1);
                boolean _not_1 = !_remove;
                if (!_not_1) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Cannot remove ");
                String _uri = comp_1.getUri();
                _builder.append(_uri);
                _builder.append(" from project ");
                String _name_1 = project.getName();
                _builder.append(_name_1);
                InputOutput.println((Object)_builder.toString());
            }
            int _size_2 = application.getComponents().size();
            int _plus_2 = _size_2 + count;
            boolean _equals_1 = _plus_2 == originalSize;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Expecting ");
            _builder_1.append((Object)originalSize);
            _builder_1.append(" == ");
            int _size_3 = application.getComponents().size();
            _builder_1.append((Object)_size_3);
            _builder_1.append(" + ");
            _builder_1.append((Object)count);
            Assert.isTrue((boolean)_equals_1, (String)_builder_1.toString());
            if (toBeSaved) {
                applications.remove((Object)project);
                Display _default = Display.getDefault();
                _default.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", "UTF-8");
                            r_1.save(options);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                });
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                project.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
            }
            applications.put((Object)project, (Object)application);
            ComponentAPI.refreshEnabledConfigurators(application);
            return;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void removeResources(Set<IResource> toBeRemoved) {
        try {
            HashMap<IProject, Integer> applications = new HashMap<IProject, Integer>();
            HashMap<IProject, HashSet<IResource>> resources = new HashMap<IProject, HashSet<IResource>>();
            Functions.Function1 _function = it -> it.getName();
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map(toBeRemoved, (Functions.Function1)_function), (CharSequence)",");
            String _plus = "Remove: " + _join;
            logger.debug((Object)_plus);
            for (IResource r : toBeRemoved) {
                IProject project = r.getProject();
                int size = 0;
                if (project == null || !project.isAccessible()) continue;
                Set _keySet = applicationConfigurators.keySet();
                for (String a : _keySet) {
                    boolean _contains = a.contains(project.getName());
                    if (!_contains) continue;
                    size = ((EMap)applicationConfigurators.get((Object)a)).keySet().size();
                    applications.put(project, size);
                }
                HashSet<IResource> projectResources = (HashSet<IResource>)resources.get(project);
                if (projectResources == null) {
                    HashSet<IResource> _hashSet;
                    projectResources = _hashSet = new HashSet<IResource>();
                    resources.put(project, projectResources);
                }
                projectResources.add(r);
            }
            DerivedAttributesNotifier.clearExternalAttributes();
            applicationConfigurators.clear();
            applicationEObjects.clear();
            Set _keySet = resources.keySet();
            for (IProject p : _keySet) {
                Integer _elvis = null;
                Integer _get = (Integer)applications.get(p);
                _elvis = _get != null ? _get : Integer.valueOf(0);
                Integer size = _elvis;
                int nbRemovedFiles = 0;
                boolean appliRemoved = false;
                Set _get_1 = (Set)resources.get(p);
                for (IResource r_1 : _get_1) {
                    String workspaceRelativePath = r_1.getFullPath().toString();
                    URI emfUri = URI.createPlatformResourceURI((String)workspaceRelativePath, (boolean)true);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Remove resource ");
                    _builder.append((Object)emfUri);
                    logger.debug((Object)_builder);
                    boolean _contains = workspaceRelativePath.contains("application.appcfg");
                    if (_contains) {
                        appliRemoved = true;
                    }
                    ++nbRemovedFiles;
                }
                if (size - nbRemovedFiles <= 0) continue;
                ComponentAPI.refreshApplication(p, appliRemoved);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof ResourceException) {
                ResourceException re = (ResourceException)_t;
                logger.error((Object)re.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static int projectNbFiles(IProject project) {
        int _xblockexpression = 0;
        ArrayList<IResource> files = new ArrayList<IResource>();
        ProjectListVisitor visitor = new ProjectListVisitor(files);
        try {
            project.accept((IResourceProxyVisitor)visitor, 0);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                logger.error((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = files.size();
        return _xblockexpression;
    }

    private static int displayCaches() {
        int _xblockexpression = 0;
        DerivedAttributesNotifier.displayCaches();
        int indent = 1;
        String _repeat = "\t".repeat(indent);
        String _plus = _repeat + "Configurators";
        System.out.println(_plus);
        ++indent;
        Set _keySet = enabledConfigurators.keySet();
        for (String cfg : _keySet) {
            Boolean externalAttrs = (Boolean)enabledConfigurators.get((Object)cfg);
            String _repeat_1 = "\t".repeat(indent);
            String _plus_1 = _repeat_1 + cfg;
            String _plus_2 = _plus_1 + " -> ";
            String _string = externalAttrs.toString();
            String _plus_3 = _plus_2 + _string;
            System.out.println(_plus_3);
        }
        _xblockexpression = indent--;
        return _xblockexpression;
    }

    public static void addResources(Set<IResource> toBeAdded) {
        HashMap<IProject, HashSet<IResource>> resources = new HashMap<IProject, HashSet<IResource>>();
        Functions.Function1 _function = it -> it.getName();
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(toBeAdded, (Functions.Function1)_function), (CharSequence)",");
        String _plus = "Add: " + _join;
        logger.debug((Object)_plus);
        for (IResource r : toBeAdded) {
            IProject project = r.getProject();
            if (project == null || !project.isAccessible()) continue;
            HashSet<IResource> projectResources = (HashSet<IResource>)resources.get(project);
            if (projectResources == null) {
                HashSet<IResource> _hashSet;
                projectResources = _hashSet = new HashSet<IResource>();
                resources.put(project, projectResources);
            }
            projectResources.add(r);
        }
        Set _keySet = resources.keySet();
        for (IProject p : _keySet) {
            Set _get = (Set)resources.get(p);
            for (IResource r_1 : _get) {
                String workspaceRelativePath = r_1.getFullPath().toString();
                URI emfUri = URI.createPlatformResourceURI((String)workspaceRelativePath, (boolean)true);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Add resource ");
                _builder.append((Object)emfUri);
                logger.debug((Object)_builder);
            }
            ComponentAPI.refreshApplication(p, true);
        }
    }

    public static void changeResources(Set<IResource> toBeChanged) {
        HashMap<IProject, HashSet<IResource>> resources = new HashMap<IProject, HashSet<IResource>>();
        Functions.Function1 _function = it -> it.getName();
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(toBeChanged, (Functions.Function1)_function), (CharSequence)",");
        String _plus = "Change: " + _join;
        logger.debug((Object)_plus);
        for (IResource r : toBeChanged) {
            IProject project = r.getProject();
            if (project == null || !project.isAccessible()) continue;
            HashSet<IResource> projectResources = (HashSet<IResource>)resources.get(project);
            if (projectResources == null) {
                HashSet<IResource> _hashSet;
                projectResources = _hashSet = new HashSet<IResource>();
                resources.put(project, projectResources);
            }
            projectResources.add(r);
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Set _keySet = resources.keySet();
        for (IProject p : _keySet) {
            Application app = ComponentAPI.getApplicationFromFile(p);
            Set _get = (Set)resources.get(p);
            for (IResource r_1 : _get) {
                String workspaceRelativePath = r_1.getFullPath().toString();
                URI emfUri = URI.createPlatformResourceURI((String)workspaceRelativePath, (boolean)true);
                try {
                    Resource resource = resourceSet.getResource(emfUri, false);
                    if (resource == null) continue;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Change resource ");
                    _builder.append((Object)emfUri);
                    logger.debug((Object)_builder);
                }
                catch (Throwable _t) {
                    if (_t instanceof ResourceException) continue;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            ComponentAPI.refreshExternalDependencies(app);
            ComponentAPI.refreshApplication(p, false);
        }
    }

    public static boolean checkUriExists(IProject project, String uriStr) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String _name = project.getName();
        String _plus = PATH_SEPARATOR + _name;
        String _plus_1 = _plus + PATH_SEPARATOR;
        String _string = uriStr.toString();
        String _plus_2 = _plus_1 + _string;
        Path path = new Path(_plus_2);
        IFile f = workspaceRoot.getFile((IPath)path);
        return f.exists();
    }

    public static Component getConfigurator(EObject object, String confId) {
        Application application = ComponentAPI.getApplication(object.eResource());
        if (application != null) {
            Component comp = ComponentAPI.getConfigurator(application, confId);
            return comp;
        }
        return null;
    }

    public static Component getConfigurator(Application app, String compId) {
        boolean _tripleEquals;
        if (app == null) {
            return null;
        }
        Resource _eResource = app.eResource();
        boolean bl = _tripleEquals = _eResource == null;
        if (_tripleEquals) {
            return null;
        }
        String appUri = app.eResource().getURI().path();
        EMap configuratorsUri = (EMap)applicationConfigurators.get((Object)appUri);
        if (configuratorsUri == null) {
            BasicEMap _basicEMap = new BasicEMap();
            configuratorsUri = _basicEMap;
            applicationConfigurators.put((Object)appUri, (Object)configuratorsUri);
        }
        IFile appFile = Utils.getFileFromResource(app.eResource().getURI());
        IProject project = appFile.getProject();
        Application application = app;
        EList<ComponentReference> configurators = application.getComponents();
        Component found = null;
        for (ComponentReference c : configurators) {
            boolean _isInstance;
            String _uri;
            String _name;
            String _plus;
            String _plus_1;
            String name;
            URI objectUri;
            boolean _isEnabled;
            if (found != null || !(_isEnabled = ComponentAPI.isEnabled((objectUri = URI.createPlatformResourceURI((String)(name = (_plus_1 = (_plus = PATH_SEPARATOR + (_name = project.getName())) + PATH_SEPARATOR) + (_uri = c.getUri())), (boolean)true)).toString()))) continue;
            EObject comp = (EObject)configuratorsUri.get((Object)objectUri.toString());
            if (comp == null) {
                comp = ComponentAPI.getEObject(application, objectUri.appendFragment(""));
                configuratorsUri.put((Object)objectUri.toString(), (Object)((Component)comp));
            }
            if (!(_isInstance = Component.class.isInstance(comp))) continue;
            Component ccomp = (Component)Component.class.cast(comp);
            ComponentAPI.addConfiguratorToApplication(appUri, ccomp);
            boolean _contains = ccomp.getExportedFeatures().contains((Object)compId);
            if (!_contains) continue;
            found = ccomp;
        }
        if (found != null) {
            return found;
        }
        return (Component)configuratorsUri.get((Object)compId);
    }

    public static Component addConfiguratorToApplication(String appUri, Component app) {
        Component _xblockexpression = null;
        IFile appFile = Utils.getFileFromResource(app.eResource().getURI());
        IProject project = appFile.getProject();
        String _name = project.getName();
        String _plus = PATH_SEPARATOR + _name;
        String projectPath = _plus + PATH_SEPARATOR;
        EMap appConfigurators = (EMap)applicationConfigurators.get((Object)appUri);
        if (appConfigurators == null) {
            BasicEMap _basicEMap = new BasicEMap();
            appConfigurators = _basicEMap;
            applicationConfigurators.put((Object)appUri, (Object)appConfigurators);
        }
        List<String> _removeDuplicates = Utils.removeDuplicates(app.getExportedFeatures());
        for (String f : _removeDuplicates) {
            appConfigurators.put((Object)(projectPath + f), (Object)app);
        }
        _xblockexpression = (Component)appConfigurators.put((Object)app.eResource().getURI().toString(), (Object)app);
        return _xblockexpression;
    }

    public static EObject getEObject(URI eObjectURI) {
        return eInstance.loadEObject(eObjectURI);
    }

    public static EObject getEObject(Application app, URI eObjectURI) {
        EObject o;
        String appUri = app.eResource().getURI().path();
        EMap eobjectsUri = (EMap)applicationEObjects.get((Object)appUri);
        if (eobjectsUri == null) {
            BasicEMap _basicEMap = new BasicEMap();
            eobjectsUri = _basicEMap;
            applicationEObjects.put((Object)appUri, (Object)eobjectsUri);
        }
        if ((o = (EObject)eobjectsUri.get((Object)eObjectURI.toString())) == null) {
            o = eInstance.loadEObject(eObjectURI);
            eobjectsUri.put((Object)eObjectURI.toString(), (Object)o);
        }
        return o;
    }

    private EObject loadEObject(URI eObjectURI) {
        try {
            block12: {
                ResourceSetImpl resourceSet = null;
                if (resourceSet == null) {
                    ResourceSetImpl _resourceSetImpl;
                    resourceSet = _resourceSetImpl = new ResourceSetImpl();
                    Map _extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
                    XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
                    _extensionToFactoryMap.put("*", _xMIResourceFactoryImpl);
                    resourceSet.getPackageRegistry().put((Object)"http://www.st.com/stellar/component/2.1.0", (Object)ComponentPackage.eINSTANCE);
                }
                try {
                    try {
                        Resource resource = resourceSet.getResource(eObjectURI.trimFragment(), true);
                        EObject eObject = resourceSet.getEObject(eObjectURI, true);
                        if (eObject == null) {
                            if (resource != null) {
                                EObject comp;
                                boolean _isInstance;
                                boolean _not;
                                InputOutput.println((Object)("load: " + String.valueOf(eObjectURI)));
                                resource.load(resourceSet.getLoadOptions());
                                EList contents = resource.getContents();
                                boolean _isEmpty = contents.isEmpty();
                                boolean bl = _not = !_isEmpty;
                                if (_not && (_isInstance = Component.class.isInstance(comp = (EObject)contents.get(0)))) {
                                    return comp;
                                }
                            }
                            break block12;
                        }
                        return eObject;
                    }
                    catch (Throwable _t) {
                        if (_t instanceof ResourceException) {
                            return null;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof WrappedException) {
                        return null;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Component getConfiguratorProperty(Component root) {
        Component newRoot = root;
        if (root == null) {
            return null;
        }
        EditingDomain editingDomain = ComponentAPI.eInstance.editingDomains.get(ComponentAPI.getPrefix(root));
        if (editingDomain != null) {
            URI rootUri = EcoreUtil.getURI((EObject)newRoot);
            EObject _eObjectFromEditingDomain = ComponentAPI.getEObjectFromEditingDomain(editingDomain, rootUri);
            newRoot = (Component)_eObjectFromEditingDomain;
            return newRoot;
        }
        return null;
    }

    public static Application getEditedApplication(Application root) {
        Application newRoot = root;
        if (root == null) {
            return null;
        }
        EditingDomain editingDomain = ComponentAPI.eInstance.editingDomains.get(ComponentAPI.getPrefix(root));
        if (editingDomain != null) {
            URI rootUri = EcoreUtil.getURI((EObject)newRoot);
            EObject _eObjectFromEditingDomain = ComponentAPI.getEObjectFromEditingDomain(editingDomain, rootUri);
            newRoot = (Application)_eObjectFromEditingDomain;
            return newRoot;
        }
        return null;
    }

    public static Pair<Component, Object> getPropertyValueFromPath(Component root, String path) {
        Component newRoot = root;
        boolean _contains = path.contains(PATH_SEPARATOR);
        if (_contains) {
            Object result = null;
            String[] pathSegments = SegmentSequence.create((String)PATH_SEPARATOR, (String)path).segments();
            ArrayList<CallSite> segments = new ArrayList<CallSite>();
            Object groupSegment = "";
            for (int i = 0; i < pathSegments.length - 1; ++i) {
                boolean _greaterThan;
                String _get = pathSegments[i];
                String seg = SEGMENT_SEPARATOR + _get;
                segments.add((CallSite)((Object)seg));
                int _length = ((String)groupSegment).length();
                boolean bl = _greaterThan = _length > 0;
                if (_greaterThan) {
                    String _groupSegment = groupSegment;
                    groupSegment = _groupSegment + PATH_SEPARATOR + seg;
                    continue;
                }
                String _groupSegment_1 = groupSegment;
                groupSegment = _groupSegment_1 + seg;
            }
            int _length = pathSegments.length;
            int _minus = _length - 1;
            String propName = pathSegments[_minus];
            try {
                EObject group = EcoreUtil.getEObject((EObject)newRoot, (String)groupSegment);
                EStructuralFeature property = group.eClass().getEStructuralFeature(propName);
                if (property != null) {
                    result = group.eGet(property);
                    EditingDomain editingDomain = ComponentAPI.eInstance.editingDomains.get(ComponentAPI.getPrefix(root));
                    if (editingDomain != null) {
                        EObject _eObjectFromEditingDomain;
                        URI groupUri = EcoreUtil.getURI((EObject)group);
                        group = _eObjectFromEditingDomain = ComponentAPI.getEObjectFromEditingDomain(editingDomain, groupUri);
                        result = group.eGet(property);
                    }
                } else {
                    EditingDomain editingDomain_1 = ComponentAPI.eInstance.editingDomains.get(ComponentAPI.getPrefix(root));
                    if (editingDomain_1 != null) {
                        EObject _eObjectFromEditingDomain_1;
                        URI groupUri_1 = EcoreUtil.getURI((EObject)group);
                        group = _eObjectFromEditingDomain_1 = ComponentAPI.getEObjectFromEditingDomain(editingDomain_1, groupUri_1);
                        result = EcoreUtil.getEObject((EObject)newRoot, (String)propName);
                    }
                }
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalArgumentException) {
                    logger.error((Object)("Cannot find property named '" + path + "'"));
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return new Pair((Object)newRoot, result);
        }
        EStructuralFeature property = newRoot.eClass().getEStructuralFeature(path);
        if (property != null) {
            Object propertyValue = newRoot.eGet(property);
            EditingDomain editingDomain = ComponentAPI.eInstance.editingDomains.get(ComponentAPI.getPrefix(root));
            if (editingDomain != null) {
                URI rootUri = EcoreUtil.getURI((EObject)newRoot);
                EObject _eObjectFromEditingDomain = ComponentAPI.getEObjectFromEditingDomain(editingDomain, rootUri);
                propertyValue = (newRoot = (Component)_eObjectFromEditingDomain) != null ? newRoot.eGet(property) : null;
            }
            return new Pair((Object)newRoot, propertyValue);
        }
        logger.error((Object)("Cannot find property named '" + path + "'"));
        return null;
    }

    public static EStructuralFeature getFeatureFromPath(Component root, String path) {
        Component newRoot = root;
        boolean _contains = path.contains(PATH_SEPARATOR);
        if (_contains) {
            String[] pathSegments = SegmentSequence.create((String)PATH_SEPARATOR, (String)path).segments();
            ArrayList<CallSite> segments = new ArrayList<CallSite>();
            Object groupSegment = "";
            for (int i = 0; i < pathSegments.length - 1; ++i) {
                boolean _greaterThan;
                String _get = pathSegments[i];
                String seg = SEGMENT_SEPARATOR + _get;
                segments.add((CallSite)((Object)seg));
                int _length = ((String)groupSegment).length();
                boolean bl = _greaterThan = _length > 0;
                if (_greaterThan) {
                    String _groupSegment = groupSegment;
                    groupSegment = _groupSegment + PATH_SEPARATOR + seg;
                    continue;
                }
                String _groupSegment_1 = groupSegment;
                groupSegment = _groupSegment_1 + seg;
            }
            int _length = pathSegments.length;
            int _minus = _length - 1;
            String propName = pathSegments[_minus];
            try {
                EObject group = EcoreUtil.getEObject((EObject)newRoot, (String)groupSegment);
                EStructuralFeature property = group.eClass().getEStructuralFeature(propName);
                return property;
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalArgumentException) {
                    logger.error((Object)("Cannot find property named '" + path + "'"));
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        EStructuralFeature property = newRoot.eClass().getEStructuralFeature(path);
        if (property != null) {
            return property;
        }
        logger.error((Object)("Cannot find property named '" + path + "'"));
        return null;
    }

    public static EAttribute getEAttributeFromURI(String uriString) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)uriString);
        Resource resource = resourceSet.getResource(uri.trimFragment(), true);
        EObject eObject = resource.getEObject(uri.fragment());
        if (eObject instanceof EAttribute) {
            return (EAttribute)eObject;
        }
        return null;
    }

    public static String getPrefix(EObject root) {
        if (root != null && root.eResource() != null) {
            URI fileUri = root.eResource().getURI();
            return fileUri.toString();
        }
        return null;
    }

    public static String getRelativePath(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        URI uri = EcoreUtil.getURI((EObject)eObject);
        return uri.fragment();
    }

    public static EObject getEObjectFromEditingDomain(EditingDomain editingDomain, URI eObjectURI) {
        ResourceSet rs = editingDomain.getResourceSet();
        Resource resource = rs.getResource(eObjectURI.trimFragment(), true);
        if (resource != null) {
            return resource.getEObject(eObjectURI.fragment());
        }
        return null;
    }

    private static Resource getResource(Resource context, String uriStr) {
        Resource res = null;
        if (uriStr != null && context != null) {
            try {
                boolean _greaterThan;
                Resource r = EcoreUtil2.getResource((Resource)context, (String)uriStr);
                if (r != null) {
                    r.load(null);
                }
                if (r == null) {
                    return null;
                }
                int _size = r.getContents().size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    res = r;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    logger.error((Object)e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return res;
    }

    public static Collection<URI> getConfigurators(Resource resource, IFile modelFile) {
        ArrayList<URI> list = new ArrayList<URI>();
        Collection<URI> localModels = ComponentAPI.getLocalModels(resource, modelFile);
        for (URI u : localModels) {
            list.add(u);
        }
        return list;
    }

    public static Collection<URI> getConfigurators(Resource resource, IFile modelFile, String suffix) {
        ArrayList<URI> list = new ArrayList<URI>();
        Collection<URI> localModels = ComponentAPI.getLocalModels(resource, modelFile, suffix);
        for (URI u : localModels) {
            list.add(u);
        }
        return list;
    }

    private static Collection<URI> getLocalModels(Resource context, IFile resource) {
        return ComponentAPI.getLocalModels(context, resource, null);
    }

    private static Collection<URI> getLocalModels(Resource context, IFile resource, String suffix) {
        ArrayList<IResource> files = new ArrayList<IResource>();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IFile file = resource;
        if (file == null) {
            return new ArrayList<URI>();
        }
        IProject project = file.getProject();
        ProjectVisitor visitor = new ProjectVisitor(files, suffix);
        ArrayList<URI> handles = new ArrayList<URI>();
        try {
            project.accept((IResourceProxyVisitor)visitor, 0);
        }
        catch (Throwable _t) {
            if (_t instanceof ResourceException) {
                ResourceException e = (ResourceException)_t;
                logger.error((Object)e.getMessage());
                return handles;
            }
            if (_t instanceof CoreException) {
                CoreException e_1 = (CoreException)_t;
                logger.error((Object)e_1.getMessage());
                return handles;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        for (IResource _next : files) {
            IFile f = (IFile)_next;
            String decodedUri = null;
            try {
                Component applicationComp;
                boolean _isInApplicationModel;
                EObject comp;
                boolean _isInstance;
                boolean match = true;
                if (suffix != null) {
                    match = f.getProjectRelativePath().toOSString().endsWith(suffix);
                }
                if (!match) continue;
                decodedUri = URLDecoder.decode(f.getProjectRelativePath().toOSString(), "UTF-8");
                Resource loadResource = ComponentAPI.getResource(context, decodedUri);
                Resource resource2 = resourceSet.createResource(URI.createFileURI((String)decodedUri));
                resourceSet.getResources().add((Object)resource2);
                if (loadResource == null) continue;
                loadResource.load(resourceSet.getLoadOptions());
                EList contents = loadResource.getContents();
                int _size = contents.size();
                boolean _greaterThan = _size > 0;
                if (!_greaterThan || !(_isInstance = Component.class.isInstance(comp = (EObject)contents.get(0))) || !(_isInApplicationModel = (applicationComp = (Component)Component.class.cast(comp)).isInApplicationModel())) continue;
                URI uri = URI.createFileURI((String)decodedUri);
                handles.add(uri);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    InputOutput.println((Object)e.getMessage());
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return handles;
    }

    public static EditingDomain getEditingDomainFromEditor(IEditorPart editorPart) {
        if (editorPart instanceof IEditingDomainProvider) {
            return ((IEditingDomainProvider)IEditingDomainProvider.class.cast(editorPart)).getEditingDomain();
        }
        EditingDomain _adapter = (EditingDomain)editorPart.getAdapter(EditingDomain.class);
        EditingDomain editingDomain = _adapter;
        if (editingDomain != null) {
            return editingDomain;
        }
        return null;
    }

    public static EditingDomain getEditingDomain(EObject obj) {
        IEditorReference[] editorReferences;
        if (obj == null) {
            return null;
        }
        boolean isWorkbenchRunning = PlatformUI.isWorkbenchRunning();
        if (!isWorkbenchRunning) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        for (IEditorReference editorReference : editorReferences = page.getEditorReferences()) {
            try {
                EditingDomain editingDomain;
                IEditorPart editorPart = editorReference.getEditor(true);
                if (editorPart == null || !(editorPart.getEditorInput() instanceof FileEditorInput)) continue;
                FileEditorInput fileEditorInput = (FileEditorInput)FileEditorInput.class.cast(editorPart.getEditorInput());
                Resource resource = obj.eResource();
                java.net.URI fileUri = fileEditorInput.getURI();
                if (resource == null) continue;
                URI fileUri2 = URI.createFileURI((String)resource.getURI().toPlatformString(true));
                boolean _contains = fileUri.toString().contains(fileUri2.toString());
                if (!_contains || (editingDomain = ComponentAPI.getEditingDomainFromEditor(editorPart)) == null) continue;
                return editingDomain;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    public static boolean isBeingValidated() {
        StackTraceElement[] _stackTrace;
        for (StackTraceElement element : _stackTrace = Thread.currentThread().getStackTrace()) {
            boolean _equals;
            boolean _startsWith = element.getClassName().startsWith("org.eclipse.emf.ecore.util.EObjectValidator");
            if (!_startsWith || !(_equals = element.getMethodName().equals("validate"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isCommandBeingEvaluated() {
        StackTraceElement[] _stackTrace;
        for (StackTraceElement element : _stackTrace = Thread.currentThread().getStackTrace()) {
            boolean _equals;
            boolean _startsWith = element.getClassName().startsWith("org.eclipse.emf.common.command.AbstractCommand");
            if (!_startsWith || !(_equals = element.getMethodName().equals("canExecute"))) continue;
            return true;
        }
        return false;
    }

    public static ExternalAttributeValueResult getExternalAttributeValue(EObject object, final EAttribute attr, String configuratorId, String path, Object oldValue, Component previousComponent) {
        Component _key;
        boolean _isBeingValidated = ComponentAPI.isBeingValidated();
        if (_isBeingValidated) {
            return new ExternalAttributeValueResult(oldValue, previousComponent);
        }
        Application app = ComponentAPI.getApplication(object.eResource());
        boolean needPopup = previousComponent == null && PlatformUI.isWorkbenchRunning();
        Component retComponent = ComponentAPI.getConfigurator(app, configuratorId);
        if (retComponent == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Cannot obtain value from ");
            _builder.append(configuratorId);
            _builder.append(PATH_SEPARATOR);
            _builder.append(path);
            logger.error((Object)_builder);
            return new ExternalAttributeValueResult(oldValue, previousComponent);
        }
        Pair<Component, Object> valuePair = ComponentAPI.getPropertyValueFromPath(retComponent, path);
        if (valuePair == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Cannot obtain value from ");
            _builder_1.append(configuratorId);
            _builder_1.append(PATH_SEPARATOR);
            _builder_1.append(path);
            logger.error((Object)_builder_1);
            return new ExternalAttributeValueResult(null, retComponent);
        }
        Object value = valuePair.getValue();
        retComponent = _key = (Component)valuePair.getKey();
        final EObject canObject = object;
        if (needPopup && value != null && value.toString().compareTo(oldValue.toString()) > 1) {
            final String externalFile = retComponent.eResource().getURI().lastSegment();
            final String currentFile = object.eResource().getURI().lastSegment();
            final Object oldVal = oldValue;
            final Object newVal = value;
            Display _default = Display.getDefault();
            _default.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EditingDomain editingDomain = ComponentAPI.getEditingDomain(canObject);
                    if (editingDomain != null) {
                        Shell _activeShell = Display.getDefault().getActiveShell();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Attribute '");
                        String _name = attr.getName();
                        _builder.append(_name);
                        _builder.append("':");
                        _builder.newLineIfNotEmpty();
                        _builder.append("Previous stored value in file '");
                        _builder.append(currentFile);
                        _builder.append("' -> ");
                        _builder.append(oldVal);
                        _builder.append(" differs from");
                        _builder.newLineIfNotEmpty();
                        _builder.append("current value in file '");
                        _builder.append(externalFile);
                        _builder.append("' -> ");
                        _builder.append(newVal);
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append("Do you want to align?");
                        boolean _openConfirm = MessageDialog.openConfirm((Shell)_activeShell, (String)"Confirmation", (String)_builder.toString());
                        if (_openConfirm) {
                            eInstance.setAttributeValue(canObject, attr, newVal.toString());
                        }
                    }
                }
            });
        }
        return new ExternalAttributeValueResult(value, retComponent);
    }

    public static void displayPopup(EObject object, EAttribute attr, Object value, Object oldValue) {
        if (value != null) {
            String _name;
            String _string = object.eResource().getURI().toString();
            String _plus = _string + "_";
            String key = _plus + (_name = attr.getName());
            DisplayPopupJob job = (DisplayPopupJob)((Object)displayPopupJobs.get((Object)key));
            if (job == null) {
                boolean _notEquals;
                int _compareTo = value.toString().compareTo(oldValue.toString());
                boolean bl = _notEquals = _compareTo != 0;
                if (_notEquals) {
                    DisplayPopupJob _displayPopupJob;
                    job = _displayPopupJob = new DisplayPopupJob(object, attr, value, oldValue);
                    displayPopupJobs.put((Object)key, (Object)job);
                    job.schedule(100L);
                }
            } else {
                boolean _notEquals_1;
                int _compareTo_1 = value.toString().compareTo(oldValue.toString());
                boolean bl = _notEquals_1 = _compareTo_1 != 0;
                if (_notEquals_1) {
                    job.schedule(100L);
                } else {
                    job.cancel();
                }
            }
        }
    }

    public void setAttributeValue(EObject object, EAttribute attribute, String value) {
        EditingDomain editingDomain = ComponentAPI.eInstance.editingDomains.get(ComponentAPI.getPrefix(EcoreUtil.getRootContainer((EObject)object)));
        EClassifier eClassifier = attribute.getEType();
        if (eClassifier instanceof EDataType) {
            EDataType eDataType = (EDataType)eClassifier;
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            Object newValue = eFactory.createFromString(eDataType, value);
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)attribute, (Object)newValue);
            editingDomain.getCommandStack().execute(command);
        }
    }

    public static EObject analyzeDependencies(EditingDomain domain) {
        boolean _not;
        Object _xblockexpression = null;
        logger.info((Object)("Analyze dependencies for: " + String.valueOf(domain)));
        ResourceSet resourceSet = domain.getResourceSet();
        boolean _isEmpty = resourceSet.getResources().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EObject root;
            DerivedAttributesNotifier notifierRoot;
            boolean _not_1;
            Resource resource = (Resource)resourceSet.getResources().get(0);
            Application app = ComponentAPI.getApplication(resource);
            if (app == null || app.eResource() == null) {
                return null;
            }
            String appUri = app.eResource().getURI().path();
            boolean _isEmpty_1 = resource.getContents().isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1 && (notifierRoot = DerivedAttributesNotifier.getDerivedAttributesNotifier(appUri, root = (EObject)resource.getContents().get(0))) != null) {
                notifierRoot.analyzeDependencies(root);
                return root;
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static void refreshExternalDependencies(Application app) {
        if (app == null) {
            return;
        }
        ComponentAPI.refreshApplication(app.eResource());
        DerivedAttributesNotifier.refreshExternalDependencies(app);
    }

    public static void setEnabledConfigurator(Application app, String uri, boolean state) {
        String appUri = app.eResource().getURI().path();
        EMap appConfigurators = (EMap)applicationConfigurators.get((Object)appUri);
        if (appConfigurators == null) {
            BasicEMap _basicEMap = new BasicEMap();
            appConfigurators = _basicEMap;
            applicationConfigurators.put((Object)appUri, (Object)appConfigurators);
        }
        if (!state) {
            appConfigurators.removeKey((Object)uri);
        }
        ComponentAPI.adaptEnabledConfigurator(uri, state);
        IFile appFile = Utils.getFileFromResource(app.eResource().getURI());
        IProject project = appFile.getProject();
        Component configurator = null;
        String objectname = uri;
        URI objectUri = URI.createURI((String)objectname, (boolean)true);
        EObject _eObject = ComponentAPI.getEObject(app, objectUri.appendFragment(""));
        configurator = (Component)_eObject;
        appConfigurators.put((Object)objectUri.toString(), (Object)configurator);
        if (configurator != null) {
            List<String> _removeDuplicates = Utils.removeDuplicates(configurator.getExportedFeatures());
            for (String exportedfeature : _removeDuplicates) {
                String _name = project.getName();
                String _plus = PATH_SEPARATOR + _name;
                String _plus_1 = _plus + PATH_SEPARATOR;
                String name = _plus_1 + exportedfeature;
                URI expuri = URI.createPlatformResourceURI((String)name, (boolean)true);
                if (state) {
                    String _repeat = "    ".repeat(indent);
                    String _plus_2 = _repeat + Boolean.valueOf(state);
                    String _plus_3 = _plus_2 + " ";
                    String _string = expuri.toString();
                    String _plus_4 = _plus_3 + (String)_string;
                    logger.debug((Object)_plus_4);
                    ComponentAPI.adaptEnabledConfigurator(expuri.toString(), true);
                    continue;
                }
                int nbEnabled = 0;
                Functions.Function1 _function = it -> it.isEnabled();
                Iterable _filter = IterableExtensions.filter(app.getComponents(), (Functions.Function1)_function);
                for (ComponentReference ref : _filter) {
                    String _uri;
                    String _name_1 = project.getName();
                    String _plus_5 = PATH_SEPARATOR + _name_1;
                    String _plus_6 = _plus_5 + PATH_SEPARATOR;
                    String refname = _plus_6 + (_uri = ref.getUri());
                    URI refuri = URI.createPlatformResourceURI((String)refname, (boolean)true);
                    Component refcomp = ComponentAPI.getConfigurator(app, refuri.toString());
                    if (refcomp == null || !Utils.removeDuplicates(refcomp.getExportedFeatures()).contains(exportedfeature)) continue;
                    ++nbEnabled;
                }
                if (nbEnabled >= true) continue;
                String _repeat_1 = "    ".repeat(indent);
                String _plus_5 = _repeat_1 + Boolean.valueOf(state);
                String _plus_6 = _plus_5 + " ";
                String _string_1 = expuri.toString();
                String _plus_7 = _plus_6 + _string_1;
                logger.debug((Object)_plus_7);
                ComponentAPI.adaptEnabledConfigurator(expuri.toString(), false);
                String _name_1 = project.getName();
                String _plus_8 = PATH_SEPARATOR + _name_1;
                String _plus_9 = _plus_8 + PATH_SEPARATOR;
                String featurename = _plus_9 + exportedfeature;
                URI featureuri = URI.createPlatformResourceURI((String)featurename, (boolean)true);
                ComponentAPI.adaptEnabledConfigurator(featureuri.toString(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshEnabledConfigurators(Application app) {
        if (app == null) {
            return;
        }
        ComponentAPI componentAPI = eInstance;
        synchronized (componentAPI) {
            logger.debug((Object)"refreshEnabledComponents");
            ++indent;
            EList<ComponentReference> components = app.getComponents();
            IFile appFile = Utils.getFileFromResource(app.eResource().getURI());
            IProject project = appFile.getProject();
            List<String> _unmodifiableList = Collections.unmodifiableList(IterableExtensions.toList((Iterable)enabledConfigurators.keySet()));
            for (String en : _unmodifiableList) {
                Object _name;
                String _plus;
                String name;
                URI projectUri;
                boolean _startsWith = en.startsWith((projectUri = URI.createPlatformResourceURI((String)(name = (_plus = PATH_SEPARATOR + (String)(_name = project.getName())) + PATH_SEPARATOR), (boolean)true)).toString());
                if (!_startsWith) continue;
                enabledConfigurators.remove((Object)en);
            }
            Functions.Function1 _function = it -> {
                boolean _isEnabled = it.isEnabled();
                return !_isEnabled;
            };
            List nonEnabledComponents = IterableExtensions.toList((Iterable)IterableExtensions.filter(components, (Functions.Function1)_function));
            for (ComponentReference c : nonEnabledComponents) {
                String _name = project.getName();
                String _plus = PATH_SEPARATOR + _name;
                String _plus_1 = _plus + PATH_SEPARATOR;
                String _uri = c.getUri();
                String name = _plus_1 + _uri;
                String _repeat = "    ".repeat(indent);
                String _plus_2 = _repeat + "false ";
                String _plus_3 = _plus_2 + name;
                logger.debug((Object)_plus_3);
                URI objectUri = URI.createPlatformResourceURI((String)name, (boolean)true);
                ComponentAPI.setEnabledConfigurator(app, objectUri.toString(), false);
            }
            Functions.Function1 _function_1 = it -> it.isEnabled();
            List enComponents = IterableExtensions.toList((Iterable)IterableExtensions.filter(components, (Functions.Function1)_function_1));
            for (ComponentReference c_1 : enComponents) {
                String _name = project.getName();
                String _plus = PATH_SEPARATOR + _name;
                String _plus_1 = _plus + PATH_SEPARATOR;
                String _uri = c_1.getUri();
                String name = _plus_1 + _uri;
                String _repeat = "    ".repeat(indent);
                String _plus_2 = _repeat + "true ";
                String _plus_3 = _plus_2 + name;
                logger.debug((Object)_plus_3);
                URI objectUri = URI.createPlatformResourceURI((String)name, (boolean)true);
                EObject comp = ComponentAPI.getEObject(app, objectUri.appendFragment(""));
                if (comp == null) continue;
                ComponentAPI.setEnabledConfigurator(app, objectUri.toString(), true);
            }
            --indent;
            logger.debug((Object)"...done");
        }
    }

    public static void resetConfigurator(EObject conf) {
        if (conf == null) {
            return;
        }
        DerivedAttributesNotifier.resetConfigurator(conf);
    }

    public static EObject refreshComponent(EObject obj) {
        EditingDomain editingDomain;
        boolean _not;
        EObject res = obj;
        boolean _isJUnitTest = ComponentAPI.isJUnitTest();
        boolean bl = _not = !_isJUnitTest;
        if (_not && (editingDomain = ComponentAPI.getEditingDomain(res)) != null) {
            EObject newObj;
            URI objUri = EcoreUtil.getURI((EObject)res);
            res = newObj = ComponentAPI.getEObjectFromEditingDomain(editingDomain, objUri);
        }
        return res;
    }

    public static boolean isJUnitTest() {
        StackTraceElement[] _stackTrace;
        for (StackTraceElement element : _stackTrace = Thread.currentThread().getStackTrace()) {
            boolean _startsWith = element.getClassName().startsWith("org.junit.");
            if (!_startsWith) continue;
            return true;
        }
        return false;
    }

    public static Object getAttributeValue(EObject destinationObject, Object oldValue, Object apiObj, String apiMethodName, Object ... args) {
        Object _xifexpression = null;
        boolean _isEnabled = ComponentAPI.isEnabled(destinationObject);
        if (_isEnabled) {
            Object _xtrycatchfinallyexpression = null;
            try {
                Method[] _methods;
                Class<?> clazz = apiObj.getClass();
                for (Method m : _methods = clazz.getMethods()) {
                    boolean _equals = m.getName().equals(apiMethodName);
                    if (!_equals) continue;
                    Object result = m.invoke(apiObj, args);
                    if (result != null) {
                        return result;
                    }
                    return oldValue;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalAccessException) {
                    IllegalAccessException e = (IllegalAccessException)_t;
                    logger.error((Object)e.getMessage());
                    return oldValue;
                }
                if (_t instanceof InvocationTargetException) {
                    InvocationTargetException e_1 = (InvocationTargetException)_t;
                    logger.error((Object)e_1.getMessage());
                    return oldValue;
                }
                if (_t instanceof ClassNotFoundException) {
                    ClassNotFoundException e_2 = (ClassNotFoundException)_t;
                    logger.error((Object)e_2.getMessage());
                    return oldValue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xifexpression = _xtrycatchfinallyexpression;
        }
        return _xifexpression;
    }

    public static void openConfiguratorInEditor(Component retComponent) {
        block13: {
            if (retComponent == null || retComponent.eResource() == null) {
                return;
            }
            URI emfUri = retComponent.eResource().getURI();
            try {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage previousPage = window.getActivePage();
                IWorkbenchPart _xifexpression = null;
                _xifexpression = previousPage != null ? previousPage.getActivePart() : null;
                IWorkbenchPart previousPart = _xifexpression;
                boolean _isPlatformResource = emfUri.isPlatformResource();
                if (_isPlatformResource) {
                    String platformPath = emfUri.toPlatformString(true);
                    IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                    String _substring = platformPath.substring(1);
                    Path _path = new Path(_substring);
                    IFile file = _root.getFile((IPath)_path);
                    IWorkbenchPage page = window.getActivePage();
                    try {
                        FileEditorInput _fileEditorInput = new FileEditorInput(file);
                        page.openEditor((IEditorInput)_fileEditorInput, wb.getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId(), false);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof PartInitException) {
                            PartInitException exception = (PartInitException)_t;
                            MessageDialog.openError((Shell)window.getShell(), (String)"Open editor fails", (String)exception.getMessage());
                            return;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                } else {
                    logger.error((Object)("Cannot open configurators from non platform resources: " + String.valueOf(emfUri)));
                }
                if (previousPage == null || previousPart == null) break block13;
                try {
                    previousPage.activate(previousPart);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        logger.warn((Object)"Cannot open reactivate previous part", (Throwable)e);
                        break block13;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    logger.error((Object)("Cannot open configurator editor for " + String.valueOf(emfUri)), (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public static class ProjectListVisitor
    implements IResourceProxyVisitor {
        private List<IResource> _list;

        public ProjectListVisitor(List<IResource> list) {
            this._list = list;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            boolean _equals;
            int _type = proxy.getType();
            boolean bl = _equals = _type == 1;
            if (_equals) {
                this._list.add(proxy.requestResource());
            }
            return true;
        }
    }

    public static class ProjectVisitor
    implements IResourceProxyVisitor {
        private List<IResource> _list;
        private String _extensions;

        public ProjectVisitor(List<IResource> list, String ext) {
            this._list = list;
            String _xifexpression = null;
            _xifexpression = ext == null ? "" : ext;
            this._extensions = _xifexpression;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            String _name;
            Path path;
            boolean _checkComponent;
            boolean _equals;
            int _type = proxy.getType();
            boolean bl = _equals = _type == 1;
            if (_equals && (_checkComponent = this.checkComponent(path = new Path(_name = proxy.getName())))) {
                this._list.add(proxy.requestResource());
            }
            return true;
        }

        public boolean checkComponent(Path path) {
            String[] _split;
            for (String e : _split = this._extensions.split(",")) {
                boolean _endsWith = path.toString().endsWith(e);
                if (!_endsWith) continue;
                return true;
            }
            return false;
        }
    }

    public static class DisplayPopupJob
    extends Job {
        private String currentFile;
        private Object oldVal;
        private Object newVal;
        private EObject object;
        private EAttribute attr;

        public DisplayPopupJob(EObject object, EAttribute attr, Object value, Object oldValue) {
            super("DisplayPopup");
            this.object = object;
            this.currentFile = object.eResource().getURI().lastSegment();
            this.oldVal = oldValue;
            this.newVal = value;
            this.attr = attr;
        }

        public void setAttributeValue(EObject object, EAttribute attribute, String value) {
            EditingDomain editingDomain = ComponentAPI.eInstance.editingDomains.get(ComponentAPI.getPrefix(EcoreUtil.getRootContainer((EObject)object)));
            EClassifier eClassifier = attribute.getEType();
            if (eClassifier instanceof EDataType && editingDomain != null) {
                EDataType eDataType = (EDataType)eClassifier;
                EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                Object newValue = eFactory.createFromString(eDataType, value);
                Command command = SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)attribute, (Object)newValue);
                String _name = attribute.getName();
                String _plus = "Attribute '" + _name;
                String _plus_1 = _plus + "' set to ";
                String _string = newValue.toString();
                String _plus_2 = _plus_1 + _string;
                logger.debug((Object)_plus_2);
                editingDomain.getCommandStack().execute(command);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display _default = Display.getDefault();
            _default.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell _activeShell = Display.getDefault().getActiveShell();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Attribute '");
                    String _name = attr.getName();
                    _builder.append(_name);
                    _builder.append("':");
                    _builder.newLineIfNotEmpty();
                    _builder.append("Previous stored value in file '");
                    _builder.append(currentFile);
                    _builder.append("' -> ");
                    _builder.append(oldVal);
                    _builder.append(" differs from");
                    _builder.newLineIfNotEmpty();
                    _builder.append("current value -> ");
                    _builder.append(newVal);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append("Do you want to align?");
                    boolean _openConfirm = MessageDialog.openConfirm((Shell)_activeShell, (String)"Confirmation", (String)_builder.toString());
                    if (_openConfirm) {
                        this.setAttributeValue(object, attr, newVal.toString());
                    }
                }
            });
            String _string = this.object.eResource().getURI().toString();
            String _plus = _string + "_";
            String _name = this.attr.getName();
            String key = _plus + _name;
            displayPopupJobs.put((Object)key, null);
            return Status.OK_STATUS;
        }
    }
}

