/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component;

import com.google.common.collect.ImmutableList;
import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.API.Utils;
import com.st.stellar.component.Application;
import com.st.stellar.component.AttributeAPI;
import com.st.stellar.component.AttributeDependency;
import com.st.stellar.component.Component;
import com.st.stellar.component.ComponentReference;
import com.st.stellar.component.DependsOn;
import com.st.stellar.component.DependsOnExternalAttributes;
import com.st.stellar.component.DerivedAttributesDependency;
import com.st.stellar.external.api.ExternalAPIFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class DerivedAttributesNotifier
implements Adapter,
IDisposable {
    static Logger logger = LogManager.getLogger(DerivedAttributesNotifier.class);
    static int instancesNb = 0;
    public Notifier target = null;
    EObject component;
    boolean disposed = false;
    private static EMap<String, EMap<String, DerivedAttributesNotifier>> derivedAttributesNotifier = new BasicEMap();
    private static Set<DerivedAttributesNotifier> notifiers = new HashSet<DerivedAttributesNotifier>();
    RemoveListener removeListener = new RemoveListener();
    static int indent = 0;
    boolean beingNotified = false;
    boolean analyzed = false;
    static EMap<String, EMap<URI, List<AttributeDependency>>> attributeDependencies = new BasicEMap();
    static EMap<String, EMap<String, EList<Pair<String, List<DerivedAttributesDependency>>>>> externalAttributesDependencies = new BasicEMap();
    EMap<URI, Object> cachedValues = new BasicEMap();

    public EObject getComponent() {
        return this.component;
    }

    private static boolean isBeingValidated() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.eclipse.emf.ecore.util.EObjectValidator") || !element.getMethodName().equals("validate")) continue;
            return true;
        }
        return false;
    }

    public DerivedAttributesNotifier(EObject comp) {
        ++instancesNb;
        if (DerivedAttributesNotifier.isBeingValidated()) {
            return;
        }
        this.component = comp;
        comp.eAdapters().add((Object)this.removeListener);
        logger.setLevel(Utils.getDebugOption() ? Level.DEBUG : Level.INFO);
        notifiers.add(this);
    }

    public static DerivedAttributesNotifier getDerivedAttributesNotifier(String appUri, EObject obj) {
        DerivedAttributesNotifier dan = (DerivedAttributesNotifier)DerivedAttributesNotifier.getDerivedAttributesNotifier(appUri).get((Object)EcoreUtil.getURI((EObject)obj).toString());
        if (dan == null) {
            dan = new DerivedAttributesNotifier(obj);
        } else {
            dan.dispose();
            obj.eAdapters().remove((Object)dan);
            dan = new DerivedAttributesNotifier(obj);
        }
        DerivedAttributesNotifier.getDerivedAttributesNotifier(appUri).put((Object)EcoreUtil.getURI((EObject)obj).toString(), (Object)dan);
        dan.analyzeDependencies(obj);
        dan.analyzeExternalDependencies(obj);
        if (!obj.eAdapters().contains((Object)dan)) {
            obj.eAdapters().add((Object)dan);
        }
        return dan;
    }

    private EAttribute getEAttribute(EObject root, int featureId) {
        ArrayList<EObject> allEObjects = new ArrayList<EObject>();
        EAttribute attr = null;
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)root, (boolean)true);
        allEObjects.add(root);
        while (iterator.hasNext()) {
            EObject o = (EObject)iterator.next();
            EStructuralFeature feature = o.eClass().getEStructuralFeature(featureId);
            if (!EAttribute.class.isInstance(feature)) continue;
            attr = (EAttribute)EAttribute.class.cast(feature);
            break;
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeDependencies(EObject notifier) {
        if (this.disposed) {
            return;
        }
        if (this.analyzed) {
            return;
        }
        String componentName = null;
        EObject root = EcoreUtil.getRootContainer((EObject)this.component);
        if (notifier.eResource() == null) {
            return;
        }
        if (Component.class.isInstance(root)) {
            componentName = ((Component)Component.class.cast(root)).getName();
        }
        String componentUri = EcoreUtil.getURI((EObject)this.component).toString();
        try {
            this.analyzed = true;
            if (componentName != null) {
                this.debug("Analysing dependencies for " + componentName + ": " + componentUri);
            } else {
                this.debug("Analysing dependencies for: " + componentUri);
            }
            ++indent;
            Application app = ComponentAPI.getApplication(this.component.eResource());
            if (app != null) {
                String appUri = app.eResource().getURI().path();
                DependsOnExternalAttributes dependsOnExtAttr = null;
                for (Method m : notifier.getClass().getMethods()) {
                    DependsOn[] dependsOnList;
                    for (DependsOn depends : dependsOnList = (DependsOn[])m.getAnnotationsByType(DependsOn.class)) {
                        EObject attrOwner = null;
                        if (depends.path().equals("#")) {
                            attrOwner = notifier;
                        } else if (!depends.path().isEmpty()) {
                            URI rootUri = EcoreUtil.getURI((EObject)root).trimFragment();
                            URI objectUri = rootUri.appendFragment(depends.path());
                            try {
                                attrOwner = ComponentAPI.getEObject(app, objectUri);
                            }
                            catch (IllegalArgumentException iae) {
                                logger.error((Object)iae.getMessage());
                                IWorkbench workbench = PlatformUI.getWorkbench();
                                IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                                String errorMessage = String.format("Cannot get object from URI: %s", objectUri);
                                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Add dependencies", (String)errorMessage);
                            }
                        } else {
                            attrOwner = root;
                        }
                        EStructuralFeature sourceAttr = notifier.eClass().getEStructuralFeature(depends.source());
                        if (sourceAttr == null) {
                            logger.error((Object)(depends.source() + " is not found in class " + notifier.eClass().getName()));
                            continue;
                        }
                        if (!EAttribute.class.isInstance(sourceAttr)) {
                            logger.error((Object)(sourceAttr.getName() + "(" + sourceAttr.getClass().getName() + ") is not authorized. Only EAttributes are authorized"));
                            continue;
                        }
                        EAttribute source = (EAttribute)EAttribute.class.cast(sourceAttr);
                        this.debug("Attribute '" + source.getName() + "' depends on: ");
                        for (int d : depends.dependencies()) {
                            URI sourceURI;
                            AttributeDependency alreadyThereDep;
                            EStructuralFeature depAttr = attrOwner.eClass().getEStructuralFeature(d);
                            if (depAttr == null) {
                                logger.error((Object)(d + " is not found in class " + attrOwner.eClass().getName()));
                                depAttr = this.getEAttribute(root, d);
                            } else if (!EAttribute.class.isInstance(depAttr)) {
                                logger.error((Object)(depAttr.getName() + "(" + depAttr.getClass().getName() + ") is not authorized. Only EAttributes are authorized"));
                                depAttr = null;
                            }
                            if (depAttr == null || attrOwner == null) continue;
                            EAttribute dependency = (EAttribute)EAttribute.class.cast(depAttr);
                            URI dependencyUri = URI.createURI((String)(EcoreUtil.getURI((EObject)attrOwner).toString() + "/" + dependency.getName()));
                            this.debug("     - " + dependency.getName());
                            ArrayList<AttributeDependency> featureIDs = (ArrayList<AttributeDependency>)DerivedAttributesNotifier.getAttributeDependencies(appUri).get((Object)dependencyUri);
                            if (featureIDs == null) {
                                featureIDs = new ArrayList<AttributeDependency>();
                                DerivedAttributesNotifier.getAttributeDependencies(appUri).put((Object)dependencyUri, featureIDs);
                            }
                            if ((alreadyThereDep = this.getAttributeDependency(featureIDs, source, sourceURI = URI.createURI((String)(componentUri + "/" + source.getName())))) == null) {
                                featureIDs.add(new AttributeDependency(notifier, source, sourceURI));
                                continue;
                            }
                            alreadyThereDep.owner = notifier;
                        }
                    }
                    dependsOnExtAttr = (DependsOnExternalAttributes)DependsOnExternalAttributes.class.cast(m.getAnnotation(DependsOnExternalAttributes.class));
                    if (dependsOnExtAttr == null) continue;
                    this.debug("Method " + m.getName());
                    EStructuralFeature destinationAttr = notifier.eClass().getEStructuralFeature(dependsOnExtAttr.destination());
                    if (!EAttribute.class.isInstance(destinationAttr)) {
                        logger.error((Object)(destinationAttr.getName() + "(" + destinationAttr.getClass().getName() + ") is not authorized. Only EAttributes are authorized"));
                        continue;
                    }
                    EAttribute source = (EAttribute)EAttribute.class.cast(destinationAttr);
                    this.debug("Attribute '" + source.getName() + "' depends on: ");
                    if (dependsOnExtAttr.dependencies() != null) {
                        for (int d : dependsOnExtAttr.dependencies()) {
                            URI sourceURI;
                            EStructuralFeature depAttr = notifier.eClass().getEStructuralFeature(d);
                            if (!EAttribute.class.isInstance(depAttr)) {
                                logger.error((Object)(depAttr.getName() + "(" + depAttr.getClass().getName() + ") is not authorized. Only EAttributes are authorized"));
                                continue;
                            }
                            EAttribute dependency = (EAttribute)EAttribute.class.cast(depAttr);
                            URI dependencyUri = URI.createURI((String)(componentUri + "/" + destinationAttr.getName()));
                            this.debug("     - " + dependency.getName());
                            ArrayList<AttributeDependency> featureIDs = (ArrayList<AttributeDependency>)DerivedAttributesNotifier.getAttributeDependencies(appUri).get((Object)dependencyUri);
                            if (featureIDs == null) {
                                featureIDs = new ArrayList<AttributeDependency>();
                            }
                            if (!this.contains(featureIDs, source, sourceURI = URI.createURI((String)(componentUri + "/" + source.getName())))) {
                                featureIDs.add(new AttributeDependency(this.component, source, sourceURI));
                            }
                            DerivedAttributesNotifier.getAttributeDependencies(appUri).put((Object)dependencyUri, featureIDs);
                        }
                    }
                    if (dependsOnExtAttr.extensions() == null) continue;
                    for (int i = 0; i < dependsOnExtAttr.extensions().length; ++i) {
                        Optional<DerivedAttributesDependency> alreadyThere;
                        EList pairList;
                        String dep = dependsOnExtAttr.extensions()[i] + "|" + dependsOnExtAttr.paths()[i];
                        BasicEMap pairs = DerivedAttributesNotifier.getExternalAttributesDependencies(app);
                        if (pairs == null) {
                            pairs = new BasicEMap();
                            this.addApplicationDependencies(app, (EMap<String, EList<Pair<String, List<DerivedAttributesDependency>>>>)pairs);
                        }
                        if ((pairList = (EList)pairs.get((Object)dep)) == null) {
                            pairList = new BasicEList();
                            pairs.put((Object)dep, (Object)pairList);
                        }
                        String compUri = EcoreUtil.getURI((EObject)this.component).toString();
                        List<DerivedAttributesDependency> dependencies = null;
                        for (Pair p : pairList) {
                            if (!((String)p.getKey()).equals(compUri)) continue;
                            dependencies = (List)p.getValue();
                            break;
                        }
                        if (dependencies == null) {
                            dependencies = new ArrayList();
                            Pair pair = Pair.of((Object)compUri, dependencies);
                            pairList.add((Object)pair);
                        }
                        if ((alreadyThere = dependencies.stream().filter(it -> it.compareTo(source) == 0).findFirst()).isEmpty()) {
                            DerivedAttributesDependency sourceDep = new DerivedAttributesDependency(this.component, source);
                            dependencies.add(sourceDep);
                            continue;
                        }
                        DerivedAttributesDependency alreadyThereDep = alreadyThere.get();
                        alreadyThereDep.obj = this.component;
                        alreadyThereDep.resource = this.component.eResource();
                    }
                }
                ImmutableList contents = ImmutableList.copyOf((Collection)this.component.eContents());
                for (EObject c : contents) {
                    DerivedAttributesNotifier notifierComponent;
                    if (c.equals((Object)this.component) || (notifierComponent = DerivedAttributesNotifier.getDerivedAttributesNotifier(appUri, c)) == null || c.equals((Object)notifierComponent.component)) continue;
                    notifierComponent.analyzeDependencies(c);
                }
            }
        }
        finally {
            --indent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeExternalDependencies(EObject notifier) {
        String componentUri = EcoreUtil.getURI((EObject)this.component).toString();
        try {
            this.debug("Analysing external dependencies for " + componentUri);
            ++indent;
            Application app = ComponentAPI.getApplication(this.component.eResource());
            if (app != null) {
                String appUri = app.eResource().getURI().path();
                DependsOnExternalAttributes dependsOnExtAttr = null;
                for (Method m : notifier.getClass().getMethods()) {
                    dependsOnExtAttr = (DependsOnExternalAttributes)DependsOnExternalAttributes.class.cast(m.getAnnotation(DependsOnExternalAttributes.class));
                    if (dependsOnExtAttr == null) continue;
                    this.debug("Method " + m.getName());
                    EStructuralFeature destinationAttr = notifier.eClass().getEStructuralFeature(dependsOnExtAttr.destination());
                    if (!EAttribute.class.isInstance(destinationAttr)) {
                        logger.error((Object)(destinationAttr.getName() + "(" + destinationAttr.getClass().getName() + ") is not authorized. Only EAttributes are authorized"));
                        continue;
                    }
                    EAttribute source = (EAttribute)EAttribute.class.cast(destinationAttr);
                    this.debug("Attribute '" + source.getName() + "' depends on: ");
                    if (dependsOnExtAttr.dependencies() != null) {
                        for (int d : dependsOnExtAttr.dependencies()) {
                            EStructuralFeature depAttr = notifier.eClass().getEStructuralFeature(d);
                            if (!EAttribute.class.isInstance(depAttr)) {
                                logger.error((Object)(depAttr.getName() + "(" + depAttr.getClass().getName() + ") is not authorized. Only EAttributes are authorized"));
                                continue;
                            }
                            EAttribute dependency = (EAttribute)EAttribute.class.cast(depAttr);
                            this.debug("     - " + dependency.getName());
                            URI sourceUri = URI.createURI((String)(componentUri + "/" + source.getName()));
                            ArrayList<AttributeDependency> featureIDs = (ArrayList<AttributeDependency>)DerivedAttributesNotifier.getAttributeDependencies(appUri).get((Object)sourceUri);
                            if (featureIDs == null) {
                                featureIDs = new ArrayList<AttributeDependency>();
                            }
                            if (!this.contains(featureIDs, source, sourceUri)) {
                                featureIDs.add(new AttributeDependency(this.component, source, sourceUri));
                            }
                            DerivedAttributesNotifier.getAttributeDependencies(appUri).put((Object)sourceUri, featureIDs);
                        }
                    }
                    if (dependsOnExtAttr.extensions() == null) continue;
                    for (int i = 0; i < dependsOnExtAttr.extensions().length; ++i) {
                        Optional<DerivedAttributesDependency> alreadyThere;
                        EList pairList;
                        String dep = dependsOnExtAttr.extensions()[i] + "|" + dependsOnExtAttr.paths()[i];
                        BasicEMap pairs = DerivedAttributesNotifier.getExternalAttributesDependencies(app);
                        if (pairs == null) {
                            pairs = new BasicEMap();
                            this.addApplicationDependencies(app, (EMap<String, EList<Pair<String, List<DerivedAttributesDependency>>>>)pairs);
                        }
                        if ((pairList = (EList)pairs.get((Object)dep)) == null) {
                            pairList = new BasicEList();
                            pairs.put((Object)dep, (Object)pairList);
                        }
                        String compUri = EcoreUtil.getURI((EObject)this.component).toString();
                        List<DerivedAttributesDependency> dependencies = null;
                        for (Pair p : pairList) {
                            if (!((String)p.getKey()).equals(compUri)) continue;
                            dependencies = (List)p.getValue();
                            break;
                        }
                        if (dependencies == null) {
                            dependencies = new ArrayList();
                            Pair pair = Pair.of((Object)compUri, dependencies);
                            pairList.add((Object)pair);
                        }
                        if ((alreadyThere = dependencies.stream().filter(it -> it.compareTo(source) == 0).findFirst()).isEmpty()) {
                            DerivedAttributesDependency sourceDep = new DerivedAttributesDependency(this.component, source);
                            dependencies.add(sourceDep);
                            continue;
                        }
                        DerivedAttributesDependency alreadyThereDep = alreadyThere.get();
                        alreadyThereDep.obj = this.component;
                        alreadyThereDep.resource = this.component.eResource();
                    }
                }
                if (!this.component.eResource().getContents().isEmpty()) {
                    EList contents = this.component.eContents();
                    for (EObject c : contents) {
                        DerivedAttributesNotifier notifierComponent;
                        if (c.equals((Object)this.component) || (notifierComponent = DerivedAttributesNotifier.getDerivedAttributesNotifier(appUri, c)) == null || notifierComponent.getComponent().equals((Object)c)) continue;
                        notifierComponent.analyzeExternalDependencies(c);
                    }
                }
            }
        }
        finally {
            --indent;
            this.debug("Analysing external dependencies for " + componentUri + "... Done");
        }
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public Notifier getTarget() {
        return this.target;
    }

    public void setTarget(Notifier newTarget) {
        this.target = newTarget;
    }

    void unsetTarget(Notifier oldTarget) {
        if (this.target == oldTarget) {
            this.setTarget(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChanged(Notification notification) {
        block46: {
            Application app;
            if (this.disposed) {
                return;
            }
            if (notification.getEventType() == 4 && EObject.class.isInstance(notification.getOldValue())) {
                EObject removedObject = (EObject)EObject.class.cast(notification.getOldValue());
                logger.debug((Object)("removing " + notification.getOldValue().toString()));
                removedObject.eAdapters().remove((Object)this.removeListener);
                removedObject.eAdapters().remove((Object)this);
                ArrayList<DerivedAttributesDependency> toBeRemoved = new ArrayList<DerivedAttributesDependency>();
                for (String appliKey : Collections.unmodifiableList(IterableExtensions.toList((Iterable)externalAttributesDependencies.keySet()))) {
                    EMap appliMap = (EMap)externalAttributesDependencies.get((Object)appliKey);
                    for (String attributesKey : Collections.unmodifiableList(IterableExtensions.toList((Iterable)appliMap.keySet()))) {
                        EList aList = (EList)appliMap.get((Object)attributesKey);
                        for (Pair a : aList) {
                            List deps = (List)a.getValue();
                            for (DerivedAttributesDependency dep : Collections.unmodifiableList(IterableExtensions.toList((Iterable)deps))) {
                                if (!dep.obj.equals((Object)removedObject)) continue;
                                toBeRemoved.add(dep);
                            }
                            for (DerivedAttributesDependency dep : toBeRemoved) {
                                deps.remove(dep);
                            }
                            if (deps.size() >= 1) continue;
                            appliMap.removeKey((Object)attributesKey);
                        }
                    }
                }
                Application app2 = ComponentAPI.getApplication(this.component.eResource());
                DerivedAttributesNotifier.refreshExternalDependencies(app2);
                return;
            }
            if (notification.getEventType() != 1) {
                return;
            }
            if (this.beingNotified || DerivedAttributesNotifier.isBeingValidated()) {
                return;
            }
            if (notification.getNewValue() != null && notification.getOldValue() != null && notification.getNewValue().equals(notification.getOldValue())) {
                return;
            }
            if (!EObject.class.isInstance(notification.getNotifier())) {
                return;
            }
            if (this.component == null || this.component.eResource() == null) {
                // empty if block
            }
            if ((app = ComponentAPI.getApplication(this.component.eResource())) == null || app.eResource() == null) {
                return;
            }
            String appUri = app.eResource().getURI().path();
            try {
                EObject obj;
                this.beingNotified = true;
                this.component = this.refreshComponent(this.component);
                EMap<String, EList<Pair<String, List<DerivedAttributesDependency>>>> pairs = DerivedAttributesNotifier.getExternalAttributesDependencies(app);
                if (pairs == null || pairs.isEmpty()) {
                    // empty if block
                }
                if (ENamedElement.class.isInstance(this.component)) {
                    ENamedElement ne = (ENamedElement)ENamedElement.class.cast(this.component);
                    this.debug("     - Feature changed: " + notification.getFeature().toString() + ne.toString());
                }
                int modifiedAttribute = notification.getFeatureID(this.component.getClass());
                EStructuralFeature attr = this.component.eClass().getEStructuralFeature(modifiedAttribute);
                if (!EAttribute.class.isInstance(attr)) {
                    return;
                }
                if (AdapterFactoryEditingDomain.getEditingDomainFor((Object)notification.getNotifier()) == null) break block46;
                this.cachedValues.clear();
                EAttribute dependency = (EAttribute)EAttribute.class.cast(attr);
                String componentUri = EcoreUtil.getURI((EObject)this.component).toString();
                URI dependencyUri = URI.createURI((String)(componentUri + "/" + dependency.getName()));
                ArrayList derivedAttributes = (ArrayList)DerivedAttributesNotifier.getAttributeDependencies(appUri).get((Object)dependencyUri);
                if (attr == null) {
                    if (EAttribute.class.isInstance(this.component)) {
                        attr = (EStructuralFeature)EAttribute.class.cast(this.component);
                        dependency = (EAttribute)EAttribute.class.cast(this.component);
                        derivedAttributes = (List)DerivedAttributesNotifier.getAttributeDependencies(appUri).get((Object)dependencyUri);
                    }
                } else {
                    if (!EAttribute.class.isInstance(attr)) {
                        logger.error((Object)(attr.getName() + "(" + attr.getClass().getName() + ") is not authorized. Only EAttributes are authorized"));
                        return;
                    }
                    dependency = (EAttribute)EAttribute.class.cast(this.component.eClass().getEStructuralFeature(modifiedAttribute));
                    dependencyUri = URI.createURI((String)(componentUri + "/" + dependency.getName()));
                    derivedAttributes = (List)DerivedAttributesNotifier.getAttributeDependencies(appUri).get((Object)dependencyUri);
                }
                if (derivedAttributes == null) {
                    return;
                }
                ArrayList<AttributeDependency> recursiveListOfDependencies = new ArrayList<AttributeDependency>();
                this.getRecursiveDependencies(appUri, dependencyUri, recursiveListOfDependencies);
                String depStringList = recursiveListOfDependencies.stream().map(it -> it.getName()).collect(Collectors.joining(", "));
                String spaces = "    ".repeat(indent);
                logger.debug((Object)(spaces + dependency.getName() + " has changed to " + String.valueOf(notification.getNewValue()) + ", need to modify: " + depStringList));
                if (notification.getNewValue() != null && notification.getOldValue() != null && notification.getNewValue().equals(notification.getOldValue())) {
                    logger.error((Object)("Must not notify values if nothing changes: " + String.valueOf(notification.getOldValue()) + " -> " + String.valueOf(notification.getNewValue())));
                }
                ++indent;
                for (AttributeDependency derivedAttribute : recursiveListOfDependencies) {
                    Object currentValueOfDerivedAttribute = this.getCachedValue(derivedAttribute.owner, (EStructuralFeature)derivedAttribute.attribute, derivedAttribute.uri);
                    spaces = "    ".repeat(indent);
                    logger.debug((Object)(spaces + derivedAttribute.attribute.getName() + " set to " + String.valueOf(currentValueOfDerivedAttribute)));
                    derivedAttribute.owner.eNotify((Notification)new ENotificationImpl((InternalEObject)derivedAttribute.owner, 1, (EStructuralFeature)derivedAttribute.attribute, null, currentValueOfDerivedAttribute));
                }
                if (EObject.class.isInstance(notification.getNotifier()) && (obj = (EObject)EObject.class.cast(notification.getNotifier())).eResource() != null) {
                    String lastSegment2;
                    String lastSegment = obj.eResource().getURI().lastSegment();
                    HashSet<String> extensions = new HashSet<String>();
                    EObject root = EcoreUtil.getRootContainer((EObject)this.component);
                    if (Component.class.isInstance(root)) {
                        Component rootComp = (Component)Component.class.cast(root);
                        rootComp.getExportedFeatures().stream().forEach(it -> extensions.add((String)it));
                    }
                    extensions.add(obj.eClass().getEPackage().getNsPrefix());
                    Object needToModify = "";
                    boolean notifyExternal = true;
                    Component relatedComponent = ComponentAPI.getConfigurator(obj, obj.eClass().getEPackage().getNsPrefix());
                    if (relatedComponent != null && EAttribute.class.isInstance(notification.getFeature()) && !lastSegment.equals(lastSegment2 = EcoreUtil.getURI((EObject)relatedComponent).lastSegment())) {
                        notifyExternal = false;
                    }
                    if (notifyExternal) {
                        derivedAttributes = new ArrayList();
                        ArrayList<DerivedAttributesDependency> recursiveListOfNamedDependencies = new ArrayList<DerivedAttributesDependency>();
                        this.getExternalDependencies(appUri, dependencyUri, recursiveListOfNamedDependencies);
                        String dependenciesStringList = recursiveListOfNamedDependencies.stream().map(it -> String.valueOf(EcoreUtil.getURI((EObject)it.obj)) + "." + it.dependency.getName()).collect(Collectors.joining(", "));
                        needToModify = (String)needToModify + dependenciesStringList;
                        if (!((String)needToModify).isEmpty()) {
                            this.debug("Need also to modify: " + (String)needToModify);
                        }
                        for (AttributeDependency eAttribute : recursiveListOfDependencies) {
                            List<String> paths = this.getPropertyPath(DerivedAttributesNotifier.getRootComponent(obj), eAttribute.attribute);
                            for (String path : paths) {
                                for (String extension : extensions) {
                                    String attributePath = path.substring(1);
                                    if (pairs == null) continue;
                                    EList pairList = (EList)pairs.get((Object)(extension + "|" + attributePath));
                                    if (pairList != null) {
                                        for (Pair dependencies : pairList) {
                                            String key = (String)dependencies.getKey();
                                            EObject newObj = ComponentAPI.getEObject(app, URI.createURI((String)key, (boolean)true));
                                            EObject newObjRoot = EcoreUtil.getRootContainer((EObject)newObj);
                                            String prefix = ComponentAPI.getPrefix(newObjRoot);
                                            EditingDomain editingDomain = ComponentAPI.getEditingDomain(prefix);
                                            ComponentAPI.addEditingDomain(prefix, editingDomain);
                                            boolean componentIsEnabled = ComponentAPI.isEnabled(newObjRoot);
                                            if (!componentIsEnabled) continue;
                                            if (editingDomain == null) {
                                                this.ensureEditorIsActive(app, newObj, eAttribute.attribute, (Pair<String, List<DerivedAttributesDependency>>)dependencies);
                                            }
                                            this.notifyExternalChanges(app, newObj, editingDomain, eAttribute.attribute, (Pair<String, List<DerivedAttributesDependency>>)dependencies);
                                        }
                                        continue;
                                    }
                                    int indexOfSlash = attributePath.replaceAll("Attribute:", "").lastIndexOf(47);
                                    String attrName = "";
                                    attrName = indexOfSlash > 0 ? attributePath.substring(indexOfSlash + 1) : attributePath;
                                    if (attrName.length() <= 0 || (pairList = (EList)pairs.get((Object)(extension + "|Attribute:" + attrName))) == null) continue;
                                    for (Pair dependencies : pairList) {
                                        this.debug("Check attribute: " + attrName);
                                        String key = (String)dependencies.getKey();
                                        URI uri = URI.createURI((String)key, (boolean)true);
                                        EObject newObj = ComponentAPI.getEObject(app, uri);
                                        AttributeAPI api = (AttributeAPI)ExternalAPIFactory.INSTANCE.getAPI("AttributeAPI");
                                        if (api == null) continue;
                                        EObject newObjRoot = EcoreUtil.getRootContainer((EObject)newObj);
                                        boolean destinationComponentIsEnabled = ComponentAPI.isEnabled(newObjRoot);
                                        boolean sourceComponentIsEnabled = ComponentAPI.isEnabled(root);
                                        if (!destinationComponentIsEnabled || !sourceComponentIsEnabled) continue;
                                        String componentActualPlugin = root.eClass().getEPackage().getNsPrefix();
                                        EAttribute externalSourceAttribute = api.getAttribute(root, componentActualPlugin, attrName);
                                        if (externalSourceAttribute == null) {
                                            return;
                                        }
                                        String destinationPlugin = newObj.eClass().getEPackage().getNsPrefix();
                                        EAttribute externalDestinationAttribute = api.getAttribute(newObj, destinationPlugin, attrName);
                                        if (externalDestinationAttribute == null) {
                                            return;
                                        }
                                        String prefix = ComponentAPI.getPrefix(newObjRoot);
                                        EditingDomain editingDomain = ComponentAPI.getEditingDomain(prefix);
                                        ComponentAPI.addEditingDomain(prefix, editingDomain);
                                        this.debug("Configurator " + prefix + (destinationComponentIsEnabled ? " is enabled" : " is not enabled"));
                                        if (editingDomain == null) {
                                            this.ensureEditorIsActive(app, newObj, eAttribute.attribute, (Pair<String, List<DerivedAttributesDependency>>)dependencies);
                                            editingDomain = ComponentAPI.getEditingDomain(prefix);
                                        }
                                        URI newObjUri = URI.createURI((String)(EcoreUtil.getURI((EObject)eAttribute.owner).toString() + "/" + externalSourceAttribute.getName()));
                                        Object currentValueOfExternal = this.getCachedValue(this.component, (EStructuralFeature)externalSourceAttribute, newObjUri);
                                        currentValueOfExternal = this.getCachedValue(eAttribute.owner, (EStructuralFeature)eAttribute.attribute, newObjUri);
                                        this.notifyExternalChanges2(app, newObj, editingDomain, externalDestinationAttribute, (Pair<String, List<DerivedAttributesDependency>>)dependencies, currentValueOfExternal);
                                    }
                                }
                            }
                        }
                    }
                }
                --indent;
            }
            finally {
                this.beingNotified = false;
            }
        }
    }

    private void ensureEditorIsActive(final Application app, final EObject newObj, final EAttribute eAttribute, final Pair<String, List<DerivedAttributesDependency>> dependencies) {
        IWorkbenchPage page;
        EObject newObjRoot = EcoreUtil.getRootContainer((EObject)newObj);
        final String prefix = ComponentAPI.getPrefix(newObjRoot);
        IFile file = Utils.getFileFromResource(newObjRoot.eResource().getURI());
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (page = workbench.getActiveWorkbenchWindow().getActivePage()) != null && this.isEditorPresentForObject(newObj, prefix)) {
            String editorId = workbench.getEditorRegistry().getDefaultEditor(newObjRoot.eResource().getURI().lastSegment()).getId();
            try {
                IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true, 3);
                editor.setFocus();
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            EditingDomain editingDomain = ComponentAPI.getEditingDomain(prefix);
                            DerivedAttributesNotifier.this.notifyExternalChanges(app, newObj, editingDomain, eAttribute, (Pair<String, List<DerivedAttributesDependency>>)dependencies);
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyExternalChanges(Application app, EObject newObjRoot, EditingDomain editingDomain, EAttribute eAttribute, Pair<String, List<DerivedAttributesDependency>> dependencies) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (editingDomain != null) {
            List derivedName2Attributes = (List)dependencies.getValue();
            for (DerivedAttributesDependency dep : derivedName2Attributes) {
                dep.refreshComponent(app, editingDomain);
                EObject obj = dep.obj;
                EAttribute attr = dep.dependency;
                URI objUri = URI.createURI((String)(EcoreUtil.getURI((EObject)obj).toString() + "/" + attr.getName()));
                Object currentValueOfDerivedAttribute = this.getCachedValue(this.component, (EStructuralFeature)eAttribute, objUri);
                EAttribute property = attr;
                if (property == null) continue;
                EClassifier eClassifier = property.getEType();
                if (eClassifier instanceof EDataType) {
                    EDataType eDataType = (EDataType)eClassifier;
                    EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                    Object newValue = eFactory.createFromString(eDataType, currentValueOfDerivedAttribute.toString());
                    Command command = SetCommand.create((EditingDomain)editingDomain, (Object)obj, (Object)property, (Object)newValue);
                    commands.add(command);
                    continue;
                }
                logger.error((Object)("wrong type for '" + property.getName() + "'"));
            }
            for (Command command : commands) {
                editingDomain.getCommandStack().execute(command);
            }
        }
    }

    private void notifyExternalChanges2(Application app, EObject newObjRoot, EditingDomain editingDomain, EAttribute eAttribute, Pair<String, List<DerivedAttributesDependency>> dependencies, Object value) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (editingDomain != null) {
            List derivedName2Attributes = (List)dependencies.getValue();
            for (DerivedAttributesDependency dep : derivedName2Attributes) {
                dep.refreshComponent(app, editingDomain);
                EObject obj = dep.obj;
                EAttribute attr = dep.dependency;
                EAttribute property = attr;
                if (property == null) continue;
                EClassifier eClassifier = property.getEType();
                if (eClassifier instanceof EDataType) {
                    EDataType eDataType = (EDataType)eClassifier;
                    EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                    Object newValue = eFactory.createFromString(eDataType, value.toString());
                    Command command = SetCommand.create((EditingDomain)editingDomain, (Object)obj, (Object)property, (Object)newValue);
                    commands.add(command);
                    continue;
                }
                logger.error((Object)("wrong type for '" + property.getName() + "'"));
            }
            for (Command command : commands) {
                editingDomain.getCommandStack().execute(command);
            }
        }
    }

    private EObject refreshComponent(EObject obj) {
        EditingDomain editingDomain;
        if (!DerivedAttributesNotifier.isJUnitTest() && (editingDomain = ComponentAPI.getEditingDomain(obj)) != null) {
            EObject newObj;
            URI objUri = EcoreUtil.getURI((EObject)obj);
            obj = newObj = ComponentAPI.getEObjectFromEditingDomain(editingDomain, objUri);
        }
        return obj;
    }

    public static boolean isJUnitTest() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    private Object getCachedValue(EObject obj, EStructuralFeature feature, URI objUri) {
        Object value = null;
        if (value == null) {
            Object newVal = obj.eGet(feature, true);
            this.cachedValues.put((Object)objUri, value);
            value = newVal;
        }
        return value;
    }

    public void getRecursiveDependencies(String appUri, URI sourceUri, List<AttributeDependency> deps) {
        List dependencyList = (List)DerivedAttributesNotifier.getAttributeDependencies(appUri).get((Object)sourceUri);
        if (dependencyList != null) {
            for (AttributeDependency d : ImmutableList.copyOf((Collection)dependencyList)) {
                if (d.uri != sourceUri) continue;
                dependencyList.remove(d);
            }
        }
        if (dependencyList != null) {
            ImmutableList cloneDeps = ImmutableList.copyOf((Collection)dependencyList);
            for (AttributeDependency dep : cloneDeps) {
                if (this.contains(deps, dep)) continue;
                this.getRecursiveDependencies(appUri, dep.uri, deps);
                deps.add(dep);
            }
        }
    }

    private boolean contains(List<AttributeDependency> deps, AttributeDependency dep) {
        boolean found = false;
        for (AttributeDependency d : deps) {
            if (d.attribute != dep.attribute || !d.uri.equals(dep.uri) || d.owner != dep.owner) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean contains(List<AttributeDependency> deps, URI uri) {
        boolean found = false;
        for (AttributeDependency d : deps) {
            if (!d.uri.equals(uri)) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean contains(List<AttributeDependency> deps, EAttribute dep, URI uri) {
        boolean found = false;
        for (AttributeDependency d : deps) {
            if (d.attribute != dep || !d.uri.equals(uri)) continue;
            found = true;
            break;
        }
        return found;
    }

    private AttributeDependency getAttributeDependency(List<AttributeDependency> deps, EAttribute dep, URI uri) {
        AttributeDependency found = null;
        for (AttributeDependency d : deps) {
            if (d.attribute != dep || !d.uri.equals(uri)) continue;
            found = d;
            break;
        }
        return found;
    }

    public void getRecursiveExternalDependencies(String appUri, URI sourceUri, List<AttributeDependency> deps) {
        List dependencyList = (List)DerivedAttributesNotifier.getAttributeDependencies(appUri).get((Object)sourceUri);
        if (dependencyList != null && !this.contains((List<AttributeDependency>)dependencyList, sourceUri)) {
            for (AttributeDependency dep : dependencyList) {
                this.getRecursiveDependencies(appUri, dep.uri, deps);
                if (deps.contains(dep)) continue;
                deps.add(dep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getExternalDependencies(String appUri, URI sourceUri, List<DerivedAttributesDependency> deps) {
        ArrayList<AttributeDependency> recursiveListOfExternalDependencies = new ArrayList<AttributeDependency>();
        DerivedAttributesNotifier derivedAttributesNotifier = this;
        synchronized (derivedAttributesNotifier) {
            this.getRecursiveExternalDependencies(appUri, sourceUri, recursiveListOfExternalDependencies);
            this.getExternalDependencies(appUri, sourceUri, deps, recursiveListOfExternalDependencies);
        }
    }

    private void getExternalDependencies(String appUri, URI sourceUri, List<DerivedAttributesDependency> deps, List<AttributeDependency> normalDeps) {
        List dependencyList = (List)DerivedAttributesNotifier.getAttributeDependencies(appUri).get((Object)sourceUri);
        if (dependencyList != null) {
            for (AttributeDependency dep : dependencyList) {
                if (normalDeps.contains(dep)) continue;
                normalDeps.add(dep);
                this.getExternalDependencies(appUri, dep.uri, deps, normalDeps);
            }
        }
        ImmutableList newDeps = ImmutableList.copyOf(normalDeps);
        for (AttributeDependency d : newDeps) {
            Application app;
            EMap<String, EList<Pair<String, List<DerivedAttributesDependency>>>> pairs;
            String attrUri = d.attribute.getName();
            HashSet<String> extensions = new HashSet<String>();
            EObject root = EcoreUtil.getRootContainer((EObject)this.component);
            if (Component.class.isInstance(root)) {
                Component rootComp = (Component)Component.class.cast(root);
                rootComp.getExportedFeatures().stream().forEach(it -> extensions.add((String)it));
            }
            if ((pairs = DerivedAttributesNotifier.getExternalAttributesDependencies(app = ComponentAPI.getApplication(this.component.eResource()))) == null) continue;
            extensions.add(this.component.eClass().getEPackage().getNsPrefix());
            for (String ext : extensions) {
                List dependencyNameList;
                EList pairList = (EList)pairs.get((Object)(ext + "|" + attrUri));
                if (pairList != null) {
                    for (Pair pair : pairList) {
                        dependencyNameList = (List)pair.getValue();
                        if (dependencyNameList == null) continue;
                        for (DerivedAttributesDependency dep : dependencyNameList) {
                            if (deps.contains(dep) || this.contains(normalDeps, dep.dependency, dep.uri)) continue;
                            deps.add(dep);
                            this.getExternalDependencies(appUri, dep.uri, deps, normalDeps);
                        }
                    }
                    continue;
                }
                pairList = (EList)pairs.get((Object)(ext + "|Attribute:" + attrUri));
                if (pairList == null) continue;
                for (Pair pair : pairList) {
                    dependencyNameList = (List)pair.getValue();
                    if (dependencyNameList == null) continue;
                    for (DerivedAttributesDependency dep : dependencyNameList) {
                        if (deps.contains(dep) || this.contains(normalDeps, dep.dependency, dep.uri)) continue;
                        deps.add(dep);
                        this.getExternalDependencies(appUri, dep.uri, deps, normalDeps);
                    }
                }
            }
        }
        for (AttributeDependency a : newDeps) {
            if (normalDeps.contains(a)) continue;
            normalDeps.add(a);
        }
    }

    public static String capitalize(String word) {
        if (word == null || word.isEmpty()) {
            return word;
        }
        return word.substring(0, 1).toUpperCase(Locale.ENGLISH) + word.substring(1);
    }

    public List<String> getPropertyPath(EObject obj, EAttribute targetAttribute) {
        return this.findMatchingPaths(DerivedAttributesNotifier.getRootComponent(obj), targetAttribute.getName());
    }

    private static Component getRootComponent(EObject eObject) {
        StringBuilder path = new StringBuilder();
        while (eObject != null && !Component.class.isInstance(eObject)) {
            path.insert(0, "/" + eObject.eClass().getName());
            eObject = eObject.eContainer();
        }
        if (Component.class.isInstance(eObject)) {
            return (Component)Component.class.cast(eObject);
        }
        return null;
    }

    private List<String> findMatchingPaths(EObject eObject, String attributeName) {
        List<String> paths = this.findAllPaths(eObject, "");
        return paths.stream().filter(it -> it.endsWith(attributeName)).collect(Collectors.toList());
    }

    private List<String> findAllPaths(EObject eObject, String path) {
        ArrayList<String> res = new ArrayList<String>();
        if (eObject == null) {
            return res;
        }
        for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
            URI objUri;
            Object value = this.getCachedValue(eObject, feature, objUri = URI.createURI((String)(EcoreUtil.getURI((EObject)eObject).toString() + "/" + feature.getName())));
            if (value instanceof EObject) {
                List<String> subObjects = this.findAllPaths((EObject)value, path + "/" + feature.getName());
                for (String o : subObjects) {
                    res.add(o);
                }
                continue;
            }
            if (value instanceof EList) {
                EList list = (EList)value;
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (item instanceof EObject) {
                        List<String> subObjects = this.findAllPaths((EObject)item, path + "/" + feature.getName() + "[" + i + "]");
                        for (String o : subObjects) {
                            res.add(o);
                        }
                        continue;
                    }
                    res.add(path + "/" + feature.getName() + "[" + i + "]");
                }
                continue;
            }
            res.add(path + "/" + feature.getName());
        }
        return res;
    }

    private void debug(String message) {
        logger.debug((Object)("    ".repeat(indent) + message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshExternalDependencies(Application app) {
        if (app == null) {
            return;
        }
        Application application = app;
        synchronized (application) {
            DerivedAttributesNotifier.refreshDependencies(app);
            String appUri = app.eResource().getURI().path();
            EList<ComponentReference> components = app.getComponents();
            IFile appFile = Utils.getFileFromResource(app.eResource().getURI());
            IProject project = appFile.getProject();
            for (ComponentReference c : components.stream().filter(it -> it.isEnabled()).collect(Collectors.toList())) {
                DerivedAttributesNotifier notifier;
                String name = "/" + project.getName() + "/" + c.getUri();
                URI objectUri = URI.createPlatformResourceURI((String)name, (boolean)true);
                EObject comp = ComponentAPI.getEObject(app, objectUri.appendFragment(""));
                if (comp == null || (notifier = (DerivedAttributesNotifier)DerivedAttributesNotifier.getDerivedAttributesNotifier(appUri).get((Object)EcoreUtil.getURI((EObject)comp).toString())) == null) continue;
                notifier.analyzeDependencies(comp);
                notifier.analyzeExternalDependencies(comp);
            }
        }
    }

    private static EMap<String, DerivedAttributesNotifier> getDerivedAttributesNotifier(String appUri) {
        EMap appDependencies = (EMap)derivedAttributesNotifier.get((Object)appUri);
        if (appDependencies == null) {
            appDependencies = new BasicEMap();
            derivedAttributesNotifier.put((Object)appUri, (Object)appDependencies);
        }
        return appDependencies;
    }

    private static EMap<URI, List<AttributeDependency>> getAttributeDependencies(String appUri) {
        EMap attrDependencies = (EMap)attributeDependencies.get((Object)appUri);
        if (attrDependencies == null) {
            attrDependencies = new BasicEMap();
            attributeDependencies.put((Object)appUri, (Object)attrDependencies);
        }
        return attrDependencies;
    }

    private void addApplicationDependencies(Application app, EMap<String, EList<Pair<String, List<DerivedAttributesDependency>>>> pairs) {
        externalAttributesDependencies.put((Object)app.eResource().getURI().path(), pairs);
    }

    private static EMap<String, EList<Pair<String, List<DerivedAttributesDependency>>>> getExternalAttributesDependencies(Application app) {
        String appUri = app.eResource().getURI().path();
        EMap extDependencies = (EMap)externalAttributesDependencies.get((Object)appUri);
        if (extDependencies == null) {
            extDependencies = new BasicEMap();
            externalAttributesDependencies.put((Object)appUri, (Object)extDependencies);
        }
        return extDependencies;
    }

    private static void refreshDependencies(Application app) {
        EMap<String, EList<Pair<String, List<DerivedAttributesDependency>>>> pairs = DerivedAttributesNotifier.getExternalAttributesDependencies(app);
        ArrayList<Resource> resourcesToBeRemoved = new ArrayList<Resource>();
        BasicEMap uriMap = new BasicEMap();
        EList<ComponentReference> components = app.getComponents();
        IFile appFile = Utils.getFileFromResource(app.eResource().getURI());
        IProject project = appFile.getProject();
        for (ComponentReference c : components.stream().filter(it -> it.isEnabled()).collect(Collectors.toList())) {
            String name = "/" + project.getName() + "/" + c.getUri();
            URI objectUri = URI.createPlatformResourceURI((String)name, (boolean)true);
            EObject comp = ComponentAPI.getEObject(app, objectUri.appendFragment(""));
            if (!c.isEnabled()) {
                resourcesToBeRemoved.add(comp.eResource());
                continue;
            }
            String suffix = name.substring(name.indexOf(46) + 1);
            uriMap.put((Object)suffix, (Object)objectUri.toString());
        }
        for (String key : pairs.keySet()) {
            System.out.println("Refreshing dependencies of " + key);
            EList list = (EList)pairs.get((Object)key);
            if (list == null) continue;
            for (Pair p : list) {
                List dependencies = (List)p.getValue();
                if (dependencies == null) continue;
                for (DerivedAttributesDependency depAttr : dependencies) {
                    if (resourcesToBeRemoved.contains(depAttr.resource)) {
                        System.out.println("Remove resource: " + depAttr.resource.getURI().toString());
                    }
                    String oldDepAttrUri = depAttr.resource.getURI().toString();
                    String oldSuffix = oldDepAttrUri.substring(oldDepAttrUri.indexOf(46) + 1);
                    String oldResourceName = depAttr.resource.getURI().toString();
                    String newResourceName = (String)uriMap.get((Object)oldSuffix);
                    if (newResourceName != null) {
                        String newUri = depAttr.uri.toString().replace(oldResourceName, newResourceName);
                        URI newDepAttrUri = URI.createURI((String)newUri, (boolean)true);
                        EObject newObj = ComponentAPI.getEObject(app, newDepAttrUri);
                        if (newObj != null) {
                            Resource newResource = newObj.eResource();
                            System.out.println("      " + depAttr.dependency.getName());
                            System.out.println("      " + depAttr.resource.getURI().toString() + " -> " + newResource.getURI().toString());
                            System.out.println("      " + String.valueOf(depAttr.uri) + " -> " + String.valueOf(EcoreUtil.getURI((EObject)newObj)));
                            depAttr.obj = newObj;
                            depAttr.resource = newResource;
                            depAttr.uri = EcoreUtil.getURI((EObject)newObj);
                            continue;
                        }
                        pairs.put((Object)key, null);
                        continue;
                    }
                    pairs.put((Object)key, null);
                }
                String oldKey = (String)p.getKey();
                Pattern pattern = Pattern.compile("^([^.]+\\.[^.]+)#.*$");
                Matcher matcher = pattern.matcher(oldKey);
                if (!matcher.find()) continue;
                String oldUri = matcher.group(1);
                String oldSuffix = oldUri.substring(oldUri.indexOf(46) + 1);
                String newUri = (String)uriMap.get((Object)oldSuffix);
                if (newUri != null) {
                    String newKey = oldKey.replace(oldUri, newUri);
                    System.out.println(oldKey + " replaced by " + newKey);
                    Pair newDependencies = Pair.of((Object)newKey, (Object)((List)p.getValue()));
                    BasicEList lists = new BasicEList();
                    lists.add((Object)newDependencies);
                    pairs.put((Object)key, (Object)lists);
                    continue;
                }
                pairs.put((Object)key, null);
            }
        }
    }

    public boolean isEditorPresentForObject(EObject obj, String prefix) {
        IEditorReference[] editors;
        String editorId = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(obj.eResource().getURI().lastSegment()).getId();
        for (IEditorReference editorRef : editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences()) {
            String editorUri;
            IEditorPart editor = editorRef.getEditor(true);
            EditingDomain adapter = (EditingDomain)editor.getAdapter(EditingDomain.class);
            if (adapter == null || !(editorUri = ((Resource)adapter.getResourceSet().getResources().get(0)).getURI().toString()).equals(prefix) || !editorRef.getId().equals(editorId)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.component.eAdapters().remove((Object)this);
        this.component.eAdapters().remove((Object)this.removeListener);
        this.disposed = true;
        --instancesNb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(EObject type) {
        logger.debug((Object)("Notifiers Before: " + notifiers.size()));
        ArrayList<DerivedAttributesNotifier> toBeRemoved = new ArrayList<DerivedAttributesNotifier>();
        for (DerivedAttributesNotifier n : notifiers) {
            if (n.component.eResource() != null && !type.equals((Object)n.component)) continue;
            toBeRemoved.add(n);
        }
        Set<DerivedAttributesNotifier> set = notifiers;
        synchronized (set) {
            for (DerivedAttributesNotifier n : toBeRemoved) {
                notifiers.remove(n);
                n.dispose();
            }
            logger.debug((Object)("Notifiers After: " + notifiers.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetConfigurator(EObject component) {
        if (component == null) {
            return;
        }
        EObject eObject = component;
        synchronized (eObject) {
            Application app = ComponentAPI.getApplication(component.eResource());
            String appUri = app.eResource().getURI().path();
            attributeDependencies.clear();
            ComponentAPI.refreshApplication(app);
            DerivedAttributesNotifier.getDerivedAttributesNotifier(appUri, component);
        }
    }

    public static void clearExternalAttributes() {
    }

    public static void displayCaches() {
        int indent = 1;
        for (String app : externalAttributesDependencies.keySet()) {
            System.out.println("\t".repeat(indent) + "Application: " + app);
            EMap externalAttrs = (EMap)externalAttributesDependencies.get((Object)app);
            for (String extAttr : externalAttrs.keySet()) {
                System.out.println("\t".repeat(indent) + "External attribute: " + extAttr);
                EList dependencies = (EList)externalAttrs.get((Object)extAttr);
                ++indent;
                for (Pair dep : dependencies) {
                    System.out.println("\t".repeat(indent) + (String)dep.getKey());
                    for (DerivedAttributesDependency d : (List)dep.getValue()) {
                        System.out.println("\t".repeat(indent) + "attribute: " + d.dependency.getName() + "uri: " + String.valueOf(d.uri));
                    }
                }
                --indent;
            }
        }
    }

    class RemoveListener
    extends AdapterImpl {
        RemoveListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() != 8) {
                return;
            }
            if (DerivedAttributesNotifier.this.component.eAdapters().remove((Object)this)) {
                System.out.println("successfully removed " + String.valueOf(DerivedAttributesNotifier.this.component));
                notifiers.remove(DerivedAttributesNotifier.this);
            }
        }
    }
}

