/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.impl;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.API.Utils;
import com.st.stellar.component.Application;
import com.st.stellar.component.Component;
import com.st.stellar.component.ComponentReferenceDev;
import com.st.stellar.component.impl.ComponentReferenceImpl;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ComponentReferenceDevImpl
extends ComponentReferenceImpl
implements ComponentReferenceDev {
    @Override
    public void editConfiguration() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            IFile ifile = Utils.getFileFromResource(this.eResource().getURI());
            IProject project = ifile.getProject();
            URI fileUri = URI.createPlatformResourceURI((String)("/" + project.getName() + "/" + this.getUri()), (boolean)true);
            IFile modelFile = Utils.getFileFromResource(fileUri);
            page.openEditor((IEditorInput)new FileEditorInput(modelFile), workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Open Editor", (String)exception.getMessage());
        }
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        super.setEnabled(newEnabled);
        if (this.eResource() != null) {
            IFile file = Utils.getFileFromResource(this.eResource().getURI());
            IProject project = file.getProject();
            String uri = "/" + project.getName() + "/" + this.getUri();
            URI objectUri = URI.createPlatformResourceURI((String)uri, (boolean)true);
            Application app = (Application)EcoreUtil.getRootContainer((EObject)this);
            ComponentAPI.setEnabledConfigurator(app, objectUri.toString(), newEnabled);
            ComponentAPI.refreshApplication(app);
        }
        if (this.eContainer != null) {
            ComponentAPI.refreshComponent(this.eContainer());
        }
        if (this.eContainer() != null) {
            Diagnostic diag = Diagnostician.INSTANCE.validate(this.eContainer());
            String mess = "";
            if (diag.getSeverity() != 0) {
                mess = Utils.populateDiagnostics(diag);
            }
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, null, (Object)mess));
        }
    }

    @Override
    public String getRequiredFeatures() {
        Component comp;
        IFile appFile;
        IProject project;
        String name;
        URI objectUri;
        String features = "";
        EObject parent = this.eContainer();
        Application app = (Application)Application.class.cast(parent);
        EObject obj = ComponentAPI.getEObject(app, (objectUri = URI.createPlatformResourceURI((String)(name = "/" + (project = (appFile = Utils.getFileFromResource(app.eResource().getURI())).getProject()).getName() + "/" + this.getUri()), (boolean)true)).appendFragment(""));
        if (obj instanceof Component && (comp = (Component)obj).getRequiredFeatures().size() > 0) {
            features = Utils.removeDuplicates(comp.getRequiredFeatures()).stream().collect(Collectors.joining("\n"));
        }
        return features;
    }

    @Override
    public String getExportedFeatures() {
        IFile appFile;
        IProject project;
        String name;
        URI objectUri;
        Object features = "";
        EObject parent = this.eContainer();
        Application app = (Application)Application.class.cast(parent);
        EObject obj = ComponentAPI.getEObject(app, (objectUri = URI.createPlatformResourceURI((String)(name = "/" + (project = (appFile = Utils.getFileFromResource(app.eResource().getURI())).getProject()).getName() + "/" + this.getUri()), (boolean)true)).appendFragment(""));
        if (obj instanceof Component) {
            Component comp = (Component)obj;
            if (comp.getExportedFeatures().size() > 0) {
                features = (String)features + Utils.removeDuplicates(comp.getExportedFeatures()).stream().collect(Collectors.joining("\n"));
            }
            return features;
        }
        return features;
    }

    @Override
    public void setErrors(String newErrors) {
        if (ComponentAPI.isBeingValidated()) {
            this.errors = newErrors;
        } else {
            super.setErrors(newErrors);
        }
    }
}

