/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.impl;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.Component;
import com.st.stellar.component.Dependency;
import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class DependencyImpl
implements Dependency {
    Adapter adapter = null;
    Component component;

    public DependencyImpl(final EObject destinationObject, final EAttribute destinationAttr, Component component, final EAttribute expectedAttr) {
        this.component = component;
        this.adapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                EAttribute changedAttr;
                if (msg.getEventType() != 1) {
                    return;
                }
                if (EAttribute.class.isInstance(msg.getFeature()) && (changedAttr = (EAttribute)EAttribute.class.cast(msg.getFeature())) == expectedAttr && ComponentAPI.isEnabled(destinationObject)) {
                    System.out.println("need to change " + destinationAttr.getName() + " to " + String.valueOf(msg.getNewValue()));
                    DependencyImpl.this.notifyExternalChanges(destinationObject, destinationAttr, msg.getNewValue());
                }
            }
        };
        component.eAdapters().add((Object)this.adapter);
    }

    @Override
    public void dispose() {
        if (this.adapter != null) {
            this.component.eAdapters().remove((Object)this.adapter);
            this.adapter = null;
        }
    }

    private void notifyExternalChanges(EObject obj, EAttribute eAttribute, Object value) {
        EClassifier eClassifier;
        EditingDomain editingDomain = ComponentAPI.getEditingDomain(obj);
        ArrayList<Command> commands = new ArrayList<Command>();
        if (editingDomain != null && (eClassifier = eAttribute.getEType()) instanceof EDataType) {
            EDataType eDataType = (EDataType)eClassifier;
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            Object newValue = eFactory.createFromString(eDataType, value.toString());
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)obj, (Object)eAttribute, (Object)newValue);
            commands.add(command);
        }
        for (Command command : commands) {
            editingDomain.getCommandStack().execute(command);
        }
    }
}

