/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.impl;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.API.Utils;
import com.st.stellar.component.Application;
import com.st.stellar.component.Component;
import com.st.stellar.component.ComponentPackage;
import com.st.stellar.component.ComponentReference;
import com.st.stellar.component.ComponentValidation;
import com.st.stellar.component.util.ComponentValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MyComponentValidator
extends ComponentValidator {
    public static final MyComponentValidator INSTANCE = new MyComponentValidator();
    private Application currentApplication = null;
    private ComponentReference currentComponentRef = null;
    private static final String ISSUE_CODE_PREFIX = "com.st.stellar.component.";
    private static final String WRONG_URI = "com.st.stellar.component.wrongUri";
    private static final String WRONG_NAME = "com.st.stellar.component.wrongName";
    private static final String ONE_OF_A_TYPE = "com.st.stellar.component.oneOfAType";
    private static final String MISSING_FEATURE = "com.st.stellar.component.missingfeature";
    private static final Pattern REGEX_NAME = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^[a-zA-Z]+[a-zA-Z0-9\\._]*$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();

    protected boolean validate_DataValueConforms(EObject eObject, EAttribute eAttribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return ComponentValidation.validate_DataValueConforms(eObject, eAttribute, diagnostics, context);
    }

    @Override
    public boolean validateApplication(Application application, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean _xblockexpression = false;
        this.currentApplication = application;
        _xblockexpression = super.validateApplication(application, diagnostics, context);
        return _xblockexpression;
    }

    @Override
    public boolean validateComponentReference(ComponentReference ref, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean _xblockexpression = false;
        EObject _eContainer = ref.eContainer();
        this.currentApplication = (Application)_eContainer;
        this.currentComponentRef = ref;
        boolean res = super.validateComponentReference(ref, diagnostics, context);
        boolean _isInstance = BasicDiagnostic.class.isInstance(diagnostics);
        if (_isInstance) {
            boolean _notEquals;
            BasicDiagnostic diag = (BasicDiagnostic)BasicDiagnostic.class.cast(diagnostics);
            String mess = "";
            int _severity = diag.getSeverity();
            boolean bl = _notEquals = _severity != 0;
            if (_notEquals) {
                mess = Utils.populateDiagnostics((Diagnostic)diag, 99);
            }
            ref.setErrors(mess);
        } else {
            ref.setErrors("");
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    @Override
    public boolean validateComponentReference_checkUri(ComponentReference componentRef, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Application app = this.currentApplication;
        IFile appFile = Utils.getFileFromResource(app.eResource().getURI());
        IProject project = appFile.getProject();
        boolean res = true;
        boolean _isEnabled = componentRef.isEnabled();
        if (_isEnabled) {
            String _uri;
            String _name = project.getName();
            String _plus = "/" + _name;
            String _plus_1 = _plus + "/";
            String uriToValidateStr = _plus_1 + (_uri = componentRef.getUri());
            URI uriToValidate = URI.createPlatformResourceURI((String)uriToValidateStr, (boolean)true);
            EObject _eObject = ComponentAPI.getEObject(app, uriToValidate.appendFragment(""));
            Component compToValidate = (Component)_eObject;
            if (compToValidate != null) {
                List<String> requiredFeatures = Utils.removeDuplicates(compToValidate.getRequiredFeatures());
                for (String feature : requiredFeatures) {
                    HashSet configuratorsList = CollectionLiterals.newHashSet();
                    Functions.Function1 _function = it -> it.isEnabled();
                    Iterable _filter = IterableExtensions.filter(app.getComponents(), (Functions.Function1)_function);
                    for (ComponentReference ref : _filter) {
                        boolean _contains;
                        String _uri_1;
                        String _name_1;
                        String _plus_2;
                        String _plus_3;
                        String name;
                        URI refUri;
                        EObject _eObject_1;
                        Component comp;
                        if (ref == componentRef || (comp = (Component)(_eObject_1 = ComponentAPI.getEObject(app, (refUri = URI.createPlatformResourceURI((String)(name = (_plus_3 = (_plus_2 = "/" + (_name_1 = project.getName())) + "/") + (_uri_1 = ref.getUri())), (boolean)true)).appendFragment("")))) == null || !(_contains = Utils.removeDuplicates(comp.getExportedFeatures()).contains(feature))) continue;
                        configuratorsList.add(comp);
                    }
                    boolean _isEmpty = configuratorsList.isEmpty();
                    if (_isEmpty) {
                        if (diagnostics != null) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("At least one configurator must export feature '");
                            _builder.append(feature);
                            _builder.append("'.");
                            String _uri_2 = componentRef.getUri();
                            BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, MISSING_FEATURE, 99, _builder.toString(), new Object[]{_uri_2});
                            diagnostics.add((Diagnostic)_basicDiagnostic);
                        }
                        res = false;
                        continue;
                    }
                    int _size = configuratorsList.size();
                    boolean _greaterThan = _size > 1;
                    if (!_greaterThan) continue;
                    if (diagnostics != null) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Only one configurator must export feature '");
                        _builder_1.append(feature);
                        _builder_1.append("'.");
                        String _uri_3 = componentRef.getUri();
                        BasicDiagnostic _basicDiagnostic_1 = new BasicDiagnostic(4, MISSING_FEATURE, 99, _builder_1.toString(), new Object[]{_uri_3});
                        diagnostics.add((Diagnostic)_basicDiagnostic_1);
                    }
                    res = false;
                }
            }
        } else {
            res = true;
        }
        return res;
    }

    @Override
    public boolean validateuri_t_checkUri(String nameToValidate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Application app = this.currentApplication;
        if (app == null) {
            return true;
        }
        boolean res = this.checkUriExists(nameToValidate);
        if (!res) {
            if (diagnostics != null) {
                String _valueLabel = EObjectValidator.getValueLabel((EDataType)ComponentPackage.Literals.URI_T, (Object)nameToValidate, context);
                diagnostics.add((Diagnostic)this.createDiagnostic(4, WRONG_URI, 99, "_UI_GenericConstraint_diagnostic", new Object[]{"checkUriExists", _valueLabel}, new Object[]{nameToValidate}, context));
                res = false;
            }
        } else {
            res = this.checkName(nameToValidate);
            if (!res) {
                if (diagnostics != null) {
                    String _valueLabel_1 = EObjectValidator.getValueLabel((EDataType)ComponentPackage.Literals.URI_T, (Object)nameToValidate, context);
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, WRONG_NAME, 99, "_UI_GenericConstraint_diagnostic", new Object[]{"checkName", _valueLabel_1}, new Object[]{nameToValidate}, context));
                    res = false;
                }
            } else {
                res = this.checkDuplicates(nameToValidate);
                if (!res && diagnostics != null) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Only one configurator of type '");
                    int _indexOf = nameToValidate.indexOf(".");
                    int _plus = _indexOf + 1;
                    String _substring = nameToValidate.substring(_plus);
                    _builder.append(_substring);
                    _builder.append("' must be enabled.");
                    BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, ONE_OF_A_TYPE, 99, _builder.toString(), new Object[]{nameToValidate});
                    diagnostics.add((Diagnostic)_basicDiagnostic);
                    res = false;
                }
            }
        }
        return res;
    }

    @Override
    public boolean validateuri_t_checkEnable(String uri, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean _tripleEquals;
        Functions.Function1 _function_1;
        boolean _xblockexpression = false;
        ComponentReference componentRef = this.currentComponentRef;
        Application app = this.currentApplication;
        if (componentRef == null) {
            return true;
        }
        boolean res = true;
        String uriExtension = MyComponentValidator.getExtension(componentRef.getUri());
        Functions.Function1 _function = it -> MyComponentValidator.getExtension(uri).equals(uriExtension);
        List name_list = IterableExtensions.toList((Iterable)IterableExtensions.filter(app.getComponents(), (Functions.Function1)_function));
        ComponentReference _findFirst = (ComponentReference)IterableExtensions.findFirst((Iterable)name_list, (Functions.Function1)(_function_1 = it -> it.isEnabled()));
        boolean bl = _tripleEquals = _findFirst == null;
        if (_tripleEquals && diagnostics != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("At least one configurator of type '");
            _builder.append(uriExtension);
            _builder.append("' must be enabled.");
            String _uri = componentRef.getUri();
            BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, MISSING_FEATURE, 99, _builder.toString(), new Object[]{_uri});
            diagnostics.add((Diagnostic)_basicDiagnostic);
            res = false;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public boolean checkUriExists(String uriStr) {
        boolean _tripleNotEquals;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Resource _eResource = this.currentApplication.eResource();
        boolean bl = _tripleNotEquals = _eResource != null;
        if (_tripleNotEquals) {
            IFile ifile = Utils.getFileFromResource(this.currentApplication.eResource().getURI());
            IProject project = ifile.getProject();
            String _name = project.getName();
            String _plus = "/" + _name;
            String _plus_1 = _plus + "/";
            String _string = uriStr.toString();
            String _plus_2 = _plus_1 + _string;
            Path path = new Path(_plus_2);
            IFile f = workspaceRoot.getFile((IPath)path);
            return f.exists();
        }
        return true;
    }

    public boolean checkName(String nameToValidate) {
        boolean noDuplicates;
        boolean _xblockexpression = false;
        Application parent = this.currentApplication;
        if (parent == null) {
            return true;
        }
        boolean matches = REGEX_NAME.matcher(nameToValidate).matches();
        if (!matches) {
            return false;
        }
        Functions.Function1 _function = it -> it != this.currentComponentRef;
        Functions.Function1 _function_1 = it -> it.getUri();
        List name_list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(parent.getComponents(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        if (name_list == null) {
            return true;
        }
        Functions.Function1 _function_2 = it -> it.equals(nameToValidate);
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)name_list, (Functions.Function1)_function_2));
        _xblockexpression = noDuplicates = _size < 1;
        return _xblockexpression;
    }

    public boolean checkDuplicates(String nameToValidate) {
        boolean noDuplicates;
        boolean _not;
        boolean _xblockexpression = false;
        boolean _isEnabled = this.currentComponentRef.isEnabled();
        boolean bl = _not = !_isEnabled;
        if (_not) {
            return true;
        }
        Application parent = this.currentApplication;
        if (parent == null) {
            return true;
        }
        Functions.Function1 _function = it -> it != this.currentComponentRef && it.isEnabled();
        Functions.Function1 _function_1 = it -> MyComponentValidator.getExtension(it.getUri());
        List name_list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(parent.getComponents(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        if (name_list == null) {
            return true;
        }
        Functions.Function1 _function_2 = it -> it.equals(MyComponentValidator.getExtension(nameToValidate));
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)name_list, (Functions.Function1)_function_2));
        _xblockexpression = noDuplicates = _size < 1;
        return _xblockexpression;
    }

    public boolean checkNoComponentEnabled(String nameToValidate) {
        boolean noDuplicates;
        boolean _not;
        boolean _xblockexpression = false;
        boolean _isEnabled = this.currentComponentRef.isEnabled();
        boolean bl = _not = !_isEnabled;
        if (_not) {
            return true;
        }
        Application parent = this.currentApplication;
        if (parent == null) {
            return true;
        }
        Functions.Function1 _function = it -> it != this.currentComponentRef && it.isEnabled();
        Functions.Function1 _function_1 = it -> MyComponentValidator.getExtension(it.getUri());
        List name_list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(parent.getComponents(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        if (name_list == null) {
            return true;
        }
        Functions.Function1 _function_2 = it -> it.equals(MyComponentValidator.getExtension(nameToValidate));
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)name_list, (Functions.Function1)_function_2));
        _xblockexpression = noDuplicates = _size < 1;
        return _xblockexpression;
    }

    public static String getExtension(String uri) {
        if (uri == null) {
            return null;
        }
        int lastIndexOfDot = uri.lastIndexOf(".");
        if (lastIndexOfDot == -1) {
            return null;
        }
        return uri.substring(lastIndexOfDot + 1);
    }
}

