/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.util;

import com.google.common.base.Preconditions;
import com.st.stellar.component.ComponentPackage;
import com.st.stellar.component.impl.ComponentFactoryDevImpl;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class EMFModelGenerator {
    static EPackage.Descriptor des = new EPackage.Descriptor(){

        public EPackage getEPackage() {
            return GenModelPackage.eINSTANCE;
        }

        public EFactory getEFactory() {
            return null;
        }
    };
    static EPackage.Descriptor desComp = new EPackage.Descriptor(){

        public EPackage getEPackage() {
            return ComponentPackage.eINSTANCE;
        }

        public EFactory getEFactory() {
            return new ComponentFactoryDevImpl();
        }
    };

    public static void printStatus(String prefix, IStatus status) {
        System.err.print(prefix);
        System.err.println(status.getMessage());
        IStatus[] children = status.getChildren();
        String childPrefix = "  " + prefix;
        for (int i = 0; i < children.length; ++i) {
            EMFModelGenerator.printStatus(childPrefix, children[i]);
        }
    }

    private static void registerPlatformToFileURIMapping(URI uri, String componentProjectPath) {
        Pattern pattern = Pattern.compile("(platform:/plugin/)(.+)$");
        Matcher matcher = pattern.matcher(uri.toString());
        if (matcher.find()) {
            String prefix = componentProjectPath;
            URI uriOrig = URI.createURI((String)(matcher.group(1) + matcher.group(2)));
            URI fileURI = URI.createFileURI((String)(prefix + "/" + matcher.group(2)));
            File file = new File(fileURI.toFileString());
            Preconditions.checkArgument((boolean)file.exists());
            URIConverter.URI_MAP.put(uriOrig, fileURI);
            EcorePlugin.INSTANCE.log((Object)(String.valueOf(uriOrig) + " mapped to: " + String.valueOf(fileURI)));
        }
    }

    public static void main(String[] args) {
        Diagnostic editorDiag;
        Diagnostic editDiag;
        Diagnostic diagnostic;
        System.out.println("Project: " + args[0]);
        String project = args[0];
        System.out.println("Project path = " + args[1]);
        String projectPath = args[1];
        System.out.println("Model path path = " + args[2]);
        String modelPath = args[2];
        System.out.println("Component path = " + args[3]);
        String componentProjectPath = args[3];
        EcorePlugin.getPlatformResourceMap().put(project, URI.createURI((String)("file:///" + projectPath + "\\" + project + "/")));
        EcorePlugin.getPlatformResourceMap().put(project + ".edit", URI.createURI((String)("file:///" + projectPath + "\\" + project + ".edit/")));
        EcorePlugin.getPlatformResourceMap().put(project + ".editor", URI.createURI((String)("file:///" + projectPath + "\\" + project + ".editor/")));
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("ecore", new XMIResourceFactoryImpl());
        m.put("genmodel", new EcoreResourceFactoryImpl());
        EMFModelGenerator.registerPlatformToFileURIMapping(URI.createURI((String)"platform:/plugin/com.st.stellar.component.model/model/component.genmodel"), componentProjectPath);
        EMFModelGenerator.registerPlatformToFileURIMapping(URI.createURI((String)"platform:/plugin/com.st.stellar.component.model/model/component.ecore"), componentProjectPath);
        try {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)des);
            EPackage.Registry.INSTANCE.put((Object)"http://www.st.com/stellar/component/2.1.0", (Object)desComp);
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        EcorePackage.eINSTANCE.eClass();
        GenModelPackage.eINSTANCE.eClass();
        ComponentPackage.eINSTANCE.getName();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)new File(modelPath).getAbsolutePath());
        Resource resource = resSet.getResource(fileURI, true);
        GenModel genModel = (GenModel)resource.getContents().get(0);
        genModel.reconcile();
        genModel.setCanGenerate(true);
        EcoreUtil.resolveAll((EObject)genModel);
        Generator generator = new Generator();
        GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", GenModelGeneratorAdapterFactory.DESCRIPTOR);
        generator.setInput((Object)genModel);
        IStatus status = genModel.validate();
        if (!status.isOK()) {
            EMFModelGenerator.printStatus("", status);
        }
        if ((diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor.Printing(System.out))).getSeverity() != 0) {
            System.err.println(diagnostic);
        }
        if ((editDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)new BasicMonitor.Printing(System.out))).getSeverity() != 0) {
            System.err.println(editDiag);
        }
        if ((editorDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", (Monitor)new BasicMonitor.Printing(System.out))).getSeverity() != 0) {
            System.err.println(editorDiag);
        }
    }
}

