package com.st.stellar.component

import java.util.Collection
import java.util.HashMap
import java.util.List
import java.util.Map
import org.eclipse.emf.common.util.DiagnosticChain
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EDataType
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EStructuralFeature
import org.eclipse.emf.ecore.util.ExtendedMetaData
import org.eclipse.emf.ecore.util.FeatureMap
import org.eclipse.emf.ecore.util.FeatureMapUtil
import org.eclipse.emf.ecore.EValidator
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.BasicDiagnostic
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.ecore.util.EObjectValidator
import org.eclipse.emf.common.util.ResourceLocator
import org.eclipse.emf.ecore.plugin.EcorePlugin

/**
 * Collection of functions copied from EObjectValidator
 * In order to supersede validation of properties even if they are set to their default values
 */
class ComponentValidation {
	
	

	static def boolean validate_DataValueConforms(EObject eObject, EAttribute eAttribute, DiagnosticChain diagnostics,
		Map<Object, Object> context) {

		if (!eObject.eIsSet(eAttribute)) {
//			println(eAttribute.name + " is not set")
//			return true;
		}
		var result = true
		val eDataType = eAttribute.EAttributeType
		val rootValidator = getRootEValidator(context)
		var value = eObject.eGet(eAttribute)
		if (FeatureMapUtil.isFeatureMap(eAttribute)) {
			val featureMap = value as Collection<FeatureMap.Entry>
			val eClass = eObject.eClass
			var Map<EStructuralFeature, DiagnosticChain> entryFeatureToDiagnosticChainMap = null
			for (val i = featureMap.iterator(); i.hasNext() && (result || diagnostics !== null);) {
				val entry = i.next
				val entryFeature = entry.EStructuralFeature
				if (entryFeature instanceof EAttribute &&
					ExtendedMetaData.INSTANCE.getAffiliation(eClass, entryFeature) == eAttribute) {
					val entryType = entryFeature.getEType() as EDataType
					val entryValue = entry.value
					val entryIsValid = rootValidator.validate(entryType, entryValue, null, context)
					if (!entryIsValid) {
						result = false;
						if (diagnostics !== null) {
							if (entryFeatureToDiagnosticChainMap === null) {
								entryFeatureToDiagnosticChainMap = new HashMap<EStructuralFeature, DiagnosticChain>()
							}
							var entryFeatureDiagnostic = entryFeatureToDiagnosticChainMap.get(entryFeature)
							if (entryFeatureDiagnostic === null) {
								entryFeatureDiagnostic = createBadDataValueDiagnostic(eObject,
									entryFeature as EAttribute, diagnostics, context)
								entryFeatureToDiagnosticChainMap.put(entryFeature, entryFeatureDiagnostic)
							}
							rootValidator.validate(entryType, entryValue, entryFeatureDiagnostic, context)
						}
					}
				}
			}
		} else if (eAttribute.isMany()) {
			val List<?> vallist = value as List<?>;
			for (val i = vallist.iterator(); i.hasNext() && result;) {
				result = result && rootValidator.validate(eDataType, i.next(), null, context);
			}

			if (!result && diagnostics !== null) {
				val diagnostic = createBadDataValueDiagnostic(eObject, eAttribute, diagnostics, context);
				val List<?> vallist2 = value as List<?>;
				for (val i = vallist2.iterator(); i.hasNext();) {
					rootValidator.validate(eDataType, i.next(), diagnostic, context);
				}
			}
		} else if (value !== null) {
			result = rootValidator.validate(eDataType, value, null, context);
			if (!result && diagnostics !== null) {
				val diagnostic = createBadDataValueDiagnostic(eObject, eAttribute, diagnostics, context);
				rootValidator.validate(eDataType, value, diagnostic, context);
			}
		}

		return result;
	}

	protected static def EValidator getRootEValidator(Map<Object, Object> context) {
		if (context !== null) {
			val result = context.get(EValidator) as EValidator;
			if (result !== null) {
				return result;
			}
		}

		return Diagnostician.INSTANCE;
	}

	static def protected String getEcoreString(String key, Object [] substitutions) {
		return getString(getEcoreResourceLocator(), key, substitutions);
	}

	static def protected boolean isEcoreString(String key) {
		return "_UI_GenericConstraint_diagnostic".equals(key) || "_UI_GenericInvariant_diagnostic".equals(key) ||
			"_UI_ConstraintDelegateException_diagnostic".equals(key) ||
			"_UI_InvariantDelegateException_diagnostic".equals(key) ||
			"_UI_ConstraintDelegateNotFound_diagnostic".equals(key) ||
			"_UI_InvariantDelegateNotFound_diagnostic".equals(key);
	}

	static def protected String getString(String key, Object [] substitutions) {
		return getString(isEcoreString(key) ? getEcoreResourceLocator() : getResourceLocator(), key, substitutions);
	}

	static private def String getString(ResourceLocator resourceLocator, String key, Object [] substitutions) {
		return substitutions === null ? resourceLocator.getString(key) : resourceLocator.getString(key, substitutions);
	}

	static def protected ResourceLocator getResourceLocator() {
		return getEcoreResourceLocator();
	}

	static protected def ResourceLocator getEcoreResourceLocator() {
		return EcorePlugin.INSTANCE;
	}

	protected static def BasicDiagnostic createDiagnostic(int severity, String source, int code, String messageKey,
		Object[] messageSubstitutions, Object[] data, Map<Object, Object> context) {
		val message = EObjectValidator.DIAGNOSTIC_SOURCE.equals(source) ? getEcoreString(messageKey,
				messageSubstitutions) : getString(messageKey, messageSubstitutions);
		return new BasicDiagnostic(severity, source, code, message, data);
	}

	protected static def DiagnosticChain createBadDataValueDiagnostic(EObject eObject, EAttribute eAttribute,
		DiagnosticChain diagnostics, Map<Object, Object> context) {
		val labels = #[EObjectValidator.getFeatureLabel(eAttribute, context),
			EObjectValidator.getObjectLabel(eObject, context)]
		val objects = #[eObject, eAttribute]
		val diagnostic = createDiagnostic(Diagnostic.ERROR, EObjectValidator.DIAGNOSTIC_SOURCE,
			EObjectValidator.EOBJECT__EVERY_DATA_VALUE_CONFORMS, "_UI_BadDataValue_diagnostic", labels, objects,
			context);
		diagnostics.add(diagnostic);
		return diagnostic;
	}

}
