package com.st.stellar.component.model

import java.util.List
import org.apache.log4j.LogManager
import org.apache.log4j.Logger
import org.eclipse.emf.common.notify.Notification
import org.eclipse.emf.common.notify.impl.AdapterImpl
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.InternalEObject
import org.eclipse.emf.ecore.impl.EAttributeImpl
import org.eclipse.emf.ecore.impl.ENotificationImpl
import org.eclipse.emf.ecp.changebroker.internal.ChangeBrokerImpl
import org.eclipse.emf.ecp.changebroker.spi.ChangeBroker
import org.eclipse.emf.ecp.changebroker.spi.ChangeObserver
import org.eclipse.emf.ecp.changebroker.spi.NotificationProvider
import org.osgi.framework.FrameworkUtil
import org.eclipse.emf.ecp.changebroker.provider.internal.ECPNotificationProvider

class DerivedAttributeService {

	Logger logger = LogManager.getLogger(DerivedAttributeService);

	static var initDone = false;

	static public var DerivedAttributeService INSTANCE = DerivedAttributeService.init()

	ChangeBrokerImpl broker
	NotificationProvider provider

	static def DerivedAttributeService init() {
		if (initDone) {
			return INSTANCE
		}
		initDone = true
		new DerivedAttributeService
	}

	private new() {
//		try {
//			val bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext()
//			val serviceReference = bundleContext.getServiceReference(ChangeBroker)
//			broker = ChangeBrokerImpl.cast(bundleContext.getService(serviceReference))
//
//			val serviceReference2 = bundleContext.getServiceReference(NotificationProvider)
//			provider = bundleContext.getService(serviceReference2);
//			provider.addReceiver(broker)
//
//		} catch (NullPointerException npe) {
			broker = new ChangeBrokerImpl
			provider = new ECPNotificationProvider
			provider.addReceiver(broker)
//		}
	}

	def void addDependencyListener(EObject source, EAttribute derivedAttribute) {

		source.eAdapters().add(new AdapterImpl() {
			override notifyChanged(Notification notification) {
				try {
					if (notification.notifier === source) {
						broker.notify(notification)
					}

				} catch (Exception ex) {
					logger.error(ex.message)
				}
			}
		})
	}

	def void addDependencyListener(EObject source, EAttribute derivedAttribute, List<EAttribute> featureIDs) {
		if (source instanceof InternalEObject) {
			val obs = new ChangeObserver() {

				override handleNotification(Notification notification) {
					switch (notification.getEventType()) {
						case Notification.SET: {
							if (notification.feature instanceof EAttributeImpl) {
								source.eNotify(
									new ENotificationImpl(source as InternalEObject, Notification.SET,
										derivedAttribute, null, source.eGet(derivedAttribute, true)))
							}
						}
						default: {
						}
					}
				}
			}
			for (f : featureIDs) {
				broker.subscribeToFeature(obs, f)
			}

			source.eAdapters().add(new AdapterImpl() {
				override notifyChanged(Notification notification) {
					try {
						if (notification.notifier === source) {
							broker.notify(notification)
						}

					} catch (Exception ex) {
						logger.error(ex.message)
					}
				}
			})
		}
	}
}
