/*
 * Decompiled with CFR 0.152.
 */
package org.spiritconsorsium.xml.spiritmodel.Spirit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AccessType implements Enumerator
{
    READ_ONLY(0, "readOnly", "read-only"),
    WRITE_ONLY(1, "writeOnly", "write-only"),
    READ_WRITE(2, "readWrite", "read-write"),
    WRITE_ONCE(3, "writeOnce", "writeOnce"),
    READ_WRITE_ONCE(4, "readWriteOnce", "read-writeOnce");

    public static final int READ_ONLY_VALUE = 0;
    public static final int WRITE_ONLY_VALUE = 1;
    public static final int READ_WRITE_VALUE = 2;
    public static final int WRITE_ONCE_VALUE = 3;
    public static final int READ_WRITE_ONCE_VALUE = 4;
    private static final AccessType[] VALUES_ARRAY;
    public static final List<AccessType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static AccessType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            AccessType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static AccessType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            AccessType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static AccessType get(int value) {
        switch (value) {
            case 0: {
                return READ_ONLY;
            }
            case 1: {
                return WRITE_ONLY;
            }
            case 2: {
                return READ_WRITE;
            }
            case 3: {
                return WRITE_ONCE;
            }
            case 4: {
                return READ_WRITE_ONCE;
            }
        }
        return null;
    }

    private AccessType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new AccessType[]{READ_ONLY, WRITE_ONLY, READ_WRITE, WRITE_ONCE, READ_WRITE_ONCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

