/*
 * Decompiled with CFR 0.152.
 */
package org.spiritconsorsium.xml.spiritmodel.Spirit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InterfaceModeType implements Enumerator
{
    MASTER(0, "master", "master"),
    SLAVE(1, "slave", "slave"),
    SYSTEM(2, "system", "system"),
    MIRRORED_MASTER(3, "mirroredMaster", "mirroredMaster"),
    MIRRORED_SLAVE(4, "mirroredSlave", "mirroredSlave"),
    MIRRORED_SYSTEM(5, "mirroredSystem", "mirroredSystem");

    public static final int MASTER_VALUE = 0;
    public static final int SLAVE_VALUE = 1;
    public static final int SYSTEM_VALUE = 2;
    public static final int MIRRORED_MASTER_VALUE = 3;
    public static final int MIRRORED_SLAVE_VALUE = 4;
    public static final int MIRRORED_SYSTEM_VALUE = 5;
    private static final InterfaceModeType[] VALUES_ARRAY;
    public static final List<InterfaceModeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static InterfaceModeType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            InterfaceModeType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static InterfaceModeType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            InterfaceModeType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static InterfaceModeType get(int value) {
        switch (value) {
            case 0: {
                return MASTER;
            }
            case 1: {
                return SLAVE;
            }
            case 2: {
                return SYSTEM;
            }
            case 3: {
                return MIRRORED_MASTER;
            }
            case 4: {
                return MIRRORED_SLAVE;
            }
            case 5: {
                return MIRRORED_SYSTEM;
            }
        }
        return null;
    }

    private InterfaceModeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new InterfaceModeType[]{MASTER, SLAVE, SYSTEM, MIRRORED_MASTER, MIRRORED_SLAVE, MIRRORED_SYSTEM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

