/*
 * Decompiled with CFR 0.152.
 */
package org.spiritconsorsium.xml.spiritmodel.Spirit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ReadActionType implements Enumerator
{
    CLEAR(0, "clear", "clear"),
    SET(1, "set", "set"),
    MODIFY(2, "modify", "modify");

    public static final int CLEAR_VALUE = 0;
    public static final int SET_VALUE = 1;
    public static final int MODIFY_VALUE = 2;
    private static final ReadActionType[] VALUES_ARRAY;
    public static final List<ReadActionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ReadActionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ReadActionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ReadActionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ReadActionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ReadActionType get(int value) {
        switch (value) {
            case 0: {
                return CLEAR;
            }
            case 1: {
                return SET;
            }
            case 2: {
                return MODIFY;
            }
        }
        return null;
    }

    private ReadActionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ReadActionType[]{CLEAR, SET, MODIFY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

