/*
 * Decompiled with CFR 0.152.
 */
package org.spiritconsorsium.xml.spiritmodel.Spirit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BankAlignmentType implements Enumerator
{
    SERIAL(0, "serial", "serial"),
    PARALLEL(1, "parallel", "parallel");

    public static final int SERIAL_VALUE = 0;
    public static final int PARALLEL_VALUE = 1;
    private static final BankAlignmentType[] VALUES_ARRAY;
    public static final List<BankAlignmentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static BankAlignmentType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BankAlignmentType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static BankAlignmentType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BankAlignmentType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static BankAlignmentType get(int value) {
        switch (value) {
            case 0: {
                return SERIAL;
            }
            case 1: {
                return PARALLEL;
            }
        }
        return null;
    }

    private BankAlignmentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new BankAlignmentType[]{SERIAL, PARALLEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

