/*
 * Decompiled with CFR 0.152.
 */
package org.spiritconsorsium.xml.spiritmodel.Spirit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DirectionType implements Enumerator
{
    IN(0, "in", "in"),
    OUT(1, "out", "out"),
    INOUT(2, "inout", "inout");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int INOUT_VALUE = 2;
    private static final DirectionType[] VALUES_ARRAY;
    public static final List<DirectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static DirectionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DirectionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DirectionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DirectionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DirectionType get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
        }
        return null;
    }

    private DirectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new DirectionType[]{IN, OUT, INOUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

