/*
 * Decompiled with CFR 0.152.
 */
package org.spiritconsorsium.xml.spiritmodel.Spirit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EdgeValueType implements Enumerator
{
    RISE(0, "rise", "rise"),
    FALL(1, "fall", "fall");

    public static final int RISE_VALUE = 0;
    public static final int FALL_VALUE = 1;
    private static final EdgeValueType[] VALUES_ARRAY;
    public static final List<EdgeValueType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static EdgeValueType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            EdgeValueType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static EdgeValueType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            EdgeValueType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static EdgeValueType get(int value) {
        switch (value) {
            case 0: {
                return RISE;
            }
            case 1: {
                return FALL;
            }
        }
        return null;
    }

    private EdgeValueType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new EdgeValueType[]{RISE, FALL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

