/*
 * Decompiled with CFR 0.152.
 */
package org.spiritconsorsium.xml.spiritmodel.Spirit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EndianessType implements Enumerator
{
    BIG(0, "big", "big"),
    LITTLE(1, "little", "little");

    public static final int BIG_VALUE = 0;
    public static final int LITTLE_VALUE = 1;
    private static final EndianessType[] VALUES_ARRAY;
    public static final List<EndianessType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static EndianessType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            EndianessType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static EndianessType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            EndianessType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static EndianessType get(int value) {
        switch (value) {
            case 0: {
                return BIG;
            }
            case 1: {
                return LITTLE;
            }
        }
        return null;
    }

    private EndianessType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new EndianessType[]{BIG, LITTLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

