/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.action.renderer.actioncontrol;

import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.textControlEnablement.model.VTTextControlEnablementStyleProperty;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ActionControlRenderer
extends TextControlSWTRenderer {
    private static Logger logger = LogManager.getLogger(ActionControlRenderer.class);
    private Button button;
    private static final String PATH_SEPARATOR = "/";
    private static final String SEGMENT_SEPARATOR = "@";

    @Inject
    public ActionControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
    }

    protected int getDefaultAlignment() {
        return 131072;
    }

    protected Control createSWTControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        Text text = new Text(composite, 0);
        text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        SWTDataElementIdHelper.setElementIdDataForVControl((Widget)text, (VControl)((VControl)this.getVElement()), (ViewModelContext)this.getViewModelContext());
        text.setVisible(false);
        this.button = null;
        try {
            String action;
            EClassifier type = this.getFeature().getEType();
            EAnnotation annotation = type.getEAnnotation("com.st.stellar.annotation");
            if (annotation != null && (action = (String)annotation.getDetails().get((Object)"Action")) != null && !action.isEmpty()) {
                String desc;
                String label = (String)annotation.getDetails().get((Object)"Label");
                this.button = new Button(composite, 16392);
                this.button.setText(label);
                EAnnotation genModel = type.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
                if (genModel != null && (desc = (String)genModel.getDetails().get((Object)"documentation")) != null) {
                    this.button.setToolTipText(desc);
                }
                this.button.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        try {
                            EObject root = ActionControlRenderer.this.getViewModelContext().getDomainModel();
                            EObject parent = ActionControlRenderer.this.getParent(root, ActionControlRenderer.this.getFeature());
                            if (parent != null) {
                                ActionControlRenderer.this.callAction(parent, action);
                            } else {
                                ActionControlRenderer.this.callAction(root, action);
                            }
                        }
                        catch (DatabindingFailedException ex) {
                            logger.error((Object)"Cannot obtain feature");
                        }
                    }
                });
            }
        }
        catch (DatabindingFailedException ex) {
            logger.error((Object)ex.getMessage());
        }
        FormData buttonLayoutData = new FormData();
        buttonLayoutData.top = new FormAttachment(-2, -1);
        this.button.setLayoutData((Object)buttonLayoutData);
        return composite;
    }

    protected EObject getParent(EObject root, EStructuralFeature feature) {
        EObject parent = null;
        for (EObject c : root.eContents()) {
            EClass clazz = c.eClass();
            if (!clazz.getEAllAttributes().contains((Object)feature)) continue;
            parent = c;
        }
        return parent;
    }

    public Object callAction(EObject root, String method) {
        if (method.contains(PATH_SEPARATOR)) {
            Object result = null;
            String[] pathSegments = SegmentSequence.create((String)PATH_SEPARATOR, (String)method).segments();
            ArrayList<CallSite> segments = new ArrayList<CallSite>();
            Object groupSegment = "";
            for (int i = 0; i < pathSegments.length - 1; ++i) {
                String seg = SEGMENT_SEPARATOR + pathSegments[i];
                segments.add((CallSite)((Object)seg));
                groupSegment = ((String)groupSegment).length() > 0 ? (String)groupSegment + PATH_SEPARATOR + seg : (String)groupSegment + seg;
            }
            String propName = pathSegments[pathSegments.length - 1];
            EObject group = EcoreUtil.getEObject((EObject)root, (String)groupSegment);
            EStructuralFeature property = group.eClass().getEStructuralFeature(propName);
            result = group.eGet(property);
            return result;
        }
        Functions.Function1 _function = it -> it.getName().equals(method);
        Method op = (Method)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)root.getClass().getMethods())), (Functions.Function1)_function);
        if (op != null) {
            try {
                op.invoke((Object)root, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                logger.error((Object)("Cannot invoke method '" + method + "'"));
                logger.error((Object)ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)("Cannot invoke method '" + method + "'"));
                logger.error((Object)ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                logger.error((Object)("Cannot invoke method '" + method + "'"));
                logger.error((Object)ex.getMessage());
            }
        } else {
            logger.error((Object)("Cannot find property named '" + method + "'"));
        }
        return null;
    }

    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        super.setControlEnabled(gridCell, control, enabled);
        if (this.isDisableRenderedAsEditable() && (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE && gridCell.getColumn() == 1 || this.hasLeftLabelAlignment() && gridCell.getColumn() == 2)) {
            Control controlToUnset = control;
            controlToUnset = this.isControlUnsettable() ? ((Composite)Composite.class.cast(((Composite)Composite.class.cast(this.getControlCompositeFromControl(control))).getChildren()[0])).getChildren()[0] : ((Composite)Composite.class.cast(control)).getChildren()[0];
            ((Text)Text.class.cast(controlToUnset)).setEditable(enabled);
        } else if (!(((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE && gridCell.getColumn() == 1 || this.hasLeftLabelAlignment() && gridCell.getColumn() == 2)) {
            try {
                Control controlToUnset = control;
                controlToUnset = ((Composite)Composite.class.cast(((Composite)Composite.class.cast(control.getParent())).getChildren()[2])).getChildren()[1];
                controlToUnset.setEnabled(enabled);
            }
            catch (ClassCastException e) {
                logger.error((Object)e.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.button.setEnabled(enabled);
    }

    private boolean isDisableRenderedAsEditable() {
        VTViewTemplateProvider vtViewTemplateProvider = this.getVTViewTemplateProvider();
        if (vtViewTemplateProvider == null) {
            return false;
        }
        Set styleProperties = vtViewTemplateProvider.getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTTextControlEnablementStyleProperty.class.isInstance(styleProperty)) continue;
            return ((VTTextControlEnablementStyleProperty)VTTextControlEnablementStyleProperty.class.cast(styleProperty)).isRenderDisableAsEditable();
        }
        return false;
    }

    private boolean isControlUnsettable() {
        IValueProperty valueProperty;
        try {
            valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return false;
        }
        EStructuralFeature feature = (EStructuralFeature)valueProperty.getValueType();
        boolean unsettable = feature.isUnsettable();
        return unsettable;
    }
}

