/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.renderer;

import com.st.stellar.component.renderer.LabelMouseListener;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRendererUtil;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.mandatory.model.VTMandatoryStyleProperty;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;
import org.eclipse.emfforms.spi.core.services.view.RootDomainModelChangeListener;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsControlProcessorService;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.ui.SWTValidationHelper;
import org.eclipse.emfforms.spi.swt.core.ui.SWTValidationUiService;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public abstract class ComponentAbstractControlSWTRenderer<VCONTROL extends VControl>
extends AbstractSWTRenderer<VCONTROL>
implements RootDomainModelChangeListener {
    private SWTValidationHelper swtValidationHelper = SWTValidationHelper.INSTANCE;
    final EMFFormsDatabinding emfFormsDatabinding;
    private final EMFFormsLabelProvider emfFormsLabelProvider;
    private final VTViewTemplateProvider vtViewTemplateProvider;
    private boolean isDisposed;
    private IObservableValue modelValue;
    private final Map<Integer, Color> severityBackgroundColorMap = new LinkedHashMap<Integer, Color>();
    private final Map<Integer, Color> severityForegroundColorMap = new LinkedHashMap<Integer, Color>();
    private final Map<Integer, Image> severityIconMap = new LinkedHashMap<Integer, Image>();
    private final SWTValidationUiService validationUiService;
    private DataBindingContext dataBindingContext;
    private ModelChangeListener modelChangeListener;
    protected final EMFDataBindingContext viewModelDBC;
    private LabelMouseListener labelMouseListener;
    private Control popupLabel = null;

    public ComponentAbstractControlSWTRenderer(VCONTROL vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        this(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, (SWTValidationUiService)viewContext.getService(SWTValidationUiService.class));
        this.labelMouseListener = new LabelMouseListener();
    }

    public ComponentAbstractControlSWTRenderer(VCONTROL vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, SWTValidationHelper swtValidationHelper) {
        this(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.swtValidationHelper = swtValidationHelper;
    }

    public ComponentAbstractControlSWTRenderer(VCONTROL vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, SWTValidationUiService validationUiService) {
        super(vElement, viewContext, reportService);
        this.emfFormsDatabinding = emfFormsDatabinding;
        this.emfFormsLabelProvider = emfFormsLabelProvider;
        this.vtViewTemplateProvider = vtViewTemplateProvider;
        this.validationUiService = validationUiService;
        this.viewModelDBC = new EMFDataBindingContext();
        viewContext.registerRootDomainModelChangeListener((RootDomainModelChangeListener)this);
        this.isDisposed = false;
    }

    protected EMFFormsDatabinding getEMFFormsDatabinding() {
        return this.emfFormsDatabinding;
    }

    protected EMFFormsLabelProvider getEMFFormsLabelProvider() {
        return this.emfFormsLabelProvider;
    }

    protected VTViewTemplateProvider getVTViewTemplateProvider() {
        return this.vtViewTemplateProvider;
    }

    protected void postInit() {
        super.postInit();
        this.modelChangeListener = new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (ComponentAbstractControlSWTRenderer.this.isDisposed) {
                    return;
                }
                EMFFormsStructuralChangeTester changeTester = (EMFFormsStructuralChangeTester)ComponentAbstractControlSWTRenderer.this.getViewModelContext().getService(EMFFormsStructuralChangeTester.class);
                if (changeTester.isStructureChanged(((VControl)ComponentAbstractControlSWTRenderer.this.getVElement()).getDomainModelReference(), ComponentAbstractControlSWTRenderer.this.getViewModelContext().getDomainModel(), notification)) {
                    Display.getDefault().asyncExec(() -> {
                        if (!ComponentAbstractControlSWTRenderer.this.isDisposed) {
                            ComponentAbstractControlSWTRenderer.this.applyEnable();
                        }
                    });
                }
            }
        };
        if (((VControl)this.getVElement()).getDomainModelReference() != null) {
            this.getViewModelContext().registerDomainChangeListener(this.modelChangeListener);
        }
        this.applyEnable();
        this.applyReadOnly();
        if (this.isUnchangeableFeature()) {
            this.applyUnchangeableFeature();
        }
    }

    protected boolean isUnchangeableFeature() {
        VDomainModelReference ref = ((VControl)this.getVElement()).getDomainModelReference();
        if (ref == null) {
            this.getReportService().report(new AbstractReport(String.format("No DomainModelReference could be found for the VElement %1$s.", ((VControl)this.getVElement()).getName()), 4));
        }
        EObject eObject = this.getViewModelContext().getDomainModel();
        try {
            IValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(ref, eObject);
            return !((EStructuralFeature)EStructuralFeature.class.cast(valueProperty.getValueType())).isChangeable();
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return false;
        }
    }

    public Control render(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Control control = super.render(cell, parent);
        if (control == null) {
            return null;
        }
        if (!this.canHandleControlProcessor()) {
            this.defaultHandleControlProcessorForCell(control, cell);
        }
        return control;
    }

    protected void applyUnchangeableFeature() {
        ((VControl)this.getVElement()).setReadonly(true);
    }

    protected boolean canHandleControlProcessor() {
        return false;
    }

    protected void defaultHandleControlProcessorForCell(Control control, SWTGridCell cell) {
        if (cell.getColumn() == 2) {
            this.defaultHandleControlProcessor(control);
        }
    }

    protected void defaultHandleControlProcessor(Control control) {
        if (this.getViewModelContext().hasService(EMFFormsControlProcessorService.class)) {
            EMFFormsControlProcessorService service = (EMFFormsControlProcessorService)this.getViewModelContext().getService(EMFFormsControlProcessorService.class);
            service.process(control, (VControl)this.getVElement(), this.getViewModelContext());
        }
    }

    protected void dispose() {
        this.isDisposed = true;
        this.getViewModelContext().unregisterDomainChangeListener(this.modelChangeListener);
        this.getViewModelContext().unregisterRootDomainModelChangeListener((RootDomainModelChangeListener)this);
        this.modelChangeListener = null;
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
            this.dataBindingContext = null;
        }
        this.viewModelDBC.dispose();
        if (this.modelValue != null) {
            this.modelValue.dispose();
        }
        if (this.popupLabel != null) {
            this.popupLabel.dispose();
            this.labelMouseListener.dispose();
            this.popupLabel = null;
        }
        super.dispose();
    }

    @Deprecated
    protected final Image getValidationIcon(int severity) {
        if (!this.severityIconMap.containsKey(severity)) {
            Image validationIcon = this.swtValidationHelper.getValidationIcon(severity, this.getVElement(), this.getViewModelContext());
            this.severityIconMap.put(severity, validationIcon);
        }
        return this.severityIconMap.get(severity);
    }

    protected final Image getValidationIcon() {
        return this.validationUiService.getValidationIcon(this.getVElement(), this.getViewModelContext());
    }

    @Deprecated
    protected final Color getValidationBackgroundColor(int severity) {
        if (this.isDisposed) {
            return null;
        }
        if (!this.severityBackgroundColorMap.containsKey(severity)) {
            Color validationBackgroundColor = this.swtValidationHelper.getValidationBackgroundColor(severity, this.getVElement(), this.getViewModelContext());
            this.severityBackgroundColorMap.put(severity, validationBackgroundColor);
        }
        return this.severityBackgroundColorMap.get(severity);
    }

    protected final Color getValidationBackgroundColor() {
        if (this.isDisposed) {
            return null;
        }
        return this.validationUiService.getValidationBackgroundColor(this.getVElement(), this.getViewModelContext());
    }

    @Deprecated
    protected final Color getValidationForegroundColor(int severity) {
        if (this.isDisposed) {
            return null;
        }
        if (!this.severityForegroundColorMap.containsKey(severity)) {
            Color validationForegroundColor = this.swtValidationHelper.getValidationForegroundColor(severity, this.getVElement(), this.getViewModelContext());
            this.severityForegroundColorMap.put(severity, validationForegroundColor);
        }
        return this.severityForegroundColorMap.get(severity);
    }

    protected final Color getValidationForegroundColor() {
        if (this.isDisposed) {
            return null;
        }
        return this.validationUiService.getValidationForegroundColor(this.getVElement(), this.getViewModelContext());
    }

    protected final DataBindingContext getDataBindingContext() {
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new EMFDataBindingContext();
        }
        return this.dataBindingContext;
    }

    protected final IObservableValue getModelValue() throws DatabindingFailedException {
        if (this.modelValue == null) {
            VDomainModelReference ref = ((VControl)this.getVElement()).getDomainModelReference();
            if (ref == null) {
                throw new DatabindingFailedException(String.format("No DomainModelReference could be found for the VElement %1$s.", ((VControl)this.getVElement()).getName()));
            }
            EObject eObject = this.getViewModelContext().getDomainModel();
            EMFFormsDatabinding databindingService = this.getEMFFormsDatabinding();
            this.modelValue = databindingService.getObservableValue(ref, eObject);
        }
        return this.modelValue;
    }

    protected final EditingDomain getEditingDomain(EObject domainModel) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)domainModel);
    }

    protected Control createLabel(Composite parent) {
        Label label;
        block6: {
            label = null;
            if (this.hasLeftLabelAlignment()) {
                IValueProperty valueProperty;
                VDomainModelReference domainModelReference = ((VControl)this.getVElement()).getDomainModelReference();
                try {
                    valueProperty = this.getEMFFormsDatabinding().getValueProperty(domainModelReference, this.getViewModelContext().getDomainModel());
                }
                catch (DatabindingFailedException ex) {
                    this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                    break block6;
                }
                catch (IllegalArgumentException ex) {
                    this.getReportService().report(new AbstractReport((Throwable)ex));
                    break block6;
                }
                EMFFormsLabelProvider labelProvider = this.getEMFFormsLabelProvider();
                label = new Label(parent, this.getLabelStyleBits());
                label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
                SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)label, (VElement)this.getVElement(), (String)"control_label", (ViewModelContext)this.getViewModelContext());
                label.setBackground(parent.getBackground());
                EObject rootObject = this.getViewModelContext().getDomainModel();
                try {
                    ISWTObservableValue textObservable = WidgetProperties.text().observe((Widget)label);
                    IObservableValue displayNameObservable = labelProvider.getDisplayName(domainModelReference, rootObject);
                    this.viewModelDBC.bindValue((IObservableValue)textObservable, displayNameObservable, null, new UpdateValueStrategy(){

                        public Object convert(Object value) {
                            String extra = "";
                            VTMandatoryStyleProperty mandatoryStyle = ComponentAbstractControlSWTRenderer.this.getMandatoryStyle();
                            EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
                            if (mandatoryStyle.isHighliteMandatoryFields() && structuralFeature.getLowerBound() > 0) {
                                extra = mandatoryStyle.getMandatoryMarker();
                            }
                            String result = (String)super.convert(value);
                            return result + extra;
                        }
                    });
                    ISWTObservableValue tooltipObservable = WidgetProperties.tooltipText().observe((Widget)label);
                    IObservableValue descriptionObservable = labelProvider.getDescription(domainModelReference, rootObject);
                    this.viewModelDBC.bindValue((IObservableValue)tooltipObservable, descriptionObservable);
                }
                catch (NoLabelFoundException e) {
                    this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
                }
            }
        }
        return label;
    }

    protected int getLabelStyleBits() {
        return AbstractControlSWTRendererUtil.getLabelStyleBits((VTViewTemplateProvider)this.getVTViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext());
    }

    protected boolean hasLeftLabelAlignment() {
        return ((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.LEFT || ((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.DEFAULT;
    }

    VTMandatoryStyleProperty getMandatoryStyle() {
        return AbstractControlSWTRendererUtil.getMandatoryStyle((VTViewTemplateProvider)this.vtViewTemplateProvider, (VControl)((VControl)this.getVElement()), (ViewModelContext)this.getViewModelContext());
    }

    protected Label createValidationIcon(Composite composite) {
        Label validationLabel = new Label(composite, 0);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)validationLabel, (VElement)this.getVElement(), (String)"control_validation", (ViewModelContext)this.getViewModelContext());
        validationLabel.setBackground(composite.getBackground());
        return validationLabel;
    }

    protected void applyEnable() {
        for (SWTGridCell gridCell : this.getControls().keySet()) {
            try {
                boolean observedNotNull = ((IObserving)this.getModelValue()).getObserved() != null;
                boolean enabled = observedNotNull && ((VControl)this.getVElement()).isEffectivelyEnabled();
                this.setControlEnabled(gridCell, (Control)this.getControls().get(gridCell), enabled);
                if (!Boolean.FALSE.equals(enabled)) continue;
                ((VControl)this.getVElement()).setDiagnostic(null);
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                this.setControlEnabled(gridCell, (Control)this.getControls().get(gridCell), false);
                ((VControl)this.getVElement()).setDiagnostic(null);
            }
        }
    }

    public void notifyChange() {
        if (this.modelValue != null) {
            this.modelValue.dispose();
            this.modelValue = null;
        }
        try {
            this.rootDomainModelChanged();
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, "Could not process the root domain model change."));
        }
    }

    protected void rootDomainModelChanged() throws DatabindingFailedException {
    }

    protected void applyReadOnly() {
        for (SWTGridCell gridCell : this.getControls().keySet()) {
            this.setControlEnabled(gridCell, (Control)this.getControls().get(gridCell), !((VControl)this.getVElement()).isEffectivelyReadonly());
        }
    }

    protected void addPopupMenu(Control label) {
        if (label == null) {
            return;
        }
        this.popupLabel = label;
        label.addMouseTrackListener((MouseTrackListener)this.labelMouseListener);
        MenuManager menuMgr = new MenuManager();
        final Menu menu = menuMgr.createContextMenu(label);
        final VControl velt = (VControl)this.getVElement();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (menu.isDisposed()) {
                    return;
                }
                for (MenuItem item : menu.getItems()) {
                    item.dispose();
                }
                ComponentAbstractControlSWTRenderer.this.createMenuItems(menu, velt);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        label.setMenu(menu);
    }

    protected Control getPreviousLabel(Composite root) {
        Composite parent = root;
        if (parent == null) {
            return null;
        }
        int index = parent.getChildren().length - 3;
        while (parent != null) {
            Control child = parent.getChildren()[index];
            if (child != null && Label.class.isInstance(child)) {
                return child;
            }
            --index;
        }
        return null;
    }

    private void createMenuItems(Menu menu, final VControl velt) {
        MenuItem menuGetPath = new MenuItem(menu, 8);
        final EObject eObject = this.getViewModelContext().getDomainModel();
        menuGetPath.setText("Copy object path to the clipboard");
        menuGetPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (velt.getDomainModelReference() != null) {
                    try {
                        IObservableValue observableValue = ComponentAbstractControlSWTRenderer.this.emfFormsDatabinding.getObservableValue(velt.getDomainModelReference(), ComponentAbstractControlSWTRenderer.this.getViewModelContext().getDomainModel());
                        if (EAttribute.class.isInstance(observableValue.getValueType())) {
                            EAttribute obj = (EAttribute)EAttribute.class.cast(observableValue.getValueType());
                            EObject root = EcoreUtil.getRootContainer((EObject)eObject, (boolean)true);
                            String rootpath = EcoreUtil.getRelativeURIFragmentPath((EObject)root, (EObject)eObject);
                            String path = rootpath != null && !rootpath.isEmpty() ? rootpath + "/" + obj.getName() : obj.getName();
                            String retValue = path.replaceAll("@", "");
                            System.out.println(retValue);
                            Clipboard clipboard = new Clipboard(Display.getDefault());
                            TextTransfer textTransfer = TextTransfer.getInstance();
                            StringBuilder pathBuilder = new StringBuilder();
                            pathBuilder.append("extensions=#[\"");
                            EPackage pack = (EPackage)EcoreUtil.getRootContainer((EObject)obj);
                            pathBuilder.append(pack.getNsPrefix());
                            pathBuilder.append("\"], paths=#[\"");
                            pathBuilder.append(retValue);
                            pathBuilder.append("\"]");
                            clipboard.setContents(new Object[]{pathBuilder.toString()}, new Transfer[]{textTransfer});
                            clipboard.dispose();
                        }
                    }
                    catch (DatabindingFailedException ex) {
                        ComponentAbstractControlSWTRenderer.this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                    }
                } else {
                    IObservableValue modelValue = EMFEditObservables.observeValue((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)velt), (EObject)velt, (EStructuralFeature)VViewPackage.eINSTANCE.getElement_Label());
                    if (EAttribute.class.isInstance(modelValue.getValueType())) {
                        EAttribute obj = (EAttribute)EAttribute.class.cast(modelValue.getValueType());
                        EObject root = EcoreUtil.getRootContainer((EObject)eObject, (boolean)true);
                        String rootpath = EcoreUtil.getRelativeURIFragmentPath((EObject)root, (EObject)eObject);
                        String path = rootpath != null && !rootpath.isEmpty() ? rootpath + "/" + obj.getName() : obj.getName();
                        String retValue = path.replaceAll("@", "");
                        System.out.println(retValue);
                        Clipboard clipboard = new Clipboard(Display.getDefault());
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        StringBuilder pathBuilder = new StringBuilder();
                        pathBuilder.append("extensions=#[\"");
                        EPackage pack = (EPackage)EcoreUtil.getRootContainer((EObject)obj);
                        pathBuilder.append(pack.getNsPrefix());
                        pathBuilder.append("\"], paths=#[\"");
                        pathBuilder.append(retValue);
                        pathBuilder.append("\"]");
                        clipboard.setContents(new Object[]{pathBuilder.toString()}, new Transfer[]{textTransfer});
                        clipboard.dispose();
                    }
                }
            }
        });
        menuGetPath.setSelection(false);
    }
}

