/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.renderer;

import com.st.stellar.component.renderer.ComponentBooleanControlSWTRenderer;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;

public class ComponentBooleanControlSWTRendererService
implements EMFFormsDIRendererService<VControl> {
    private EMFFormsDatabinding databindingService;
    private ReportService reportService;

    protected void setEMFFormsDatabinding(EMFFormsDatabinding databindingService) {
        this.databindingService = databindingService;
    }

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        IValueProperty valueProperty;
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VControl control = (VControl)vElement;
        if (control.getDomainModelReference() == null) {
            return Double.NaN;
        }
        try {
            valueProperty = this.databindingService.getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        EStructuralFeature eStructuralFeature = (EStructuralFeature)EStructuralFeature.class.cast(valueProperty.getValueType());
        if (eStructuralFeature.isMany()) {
            return Double.NaN;
        }
        if (!EAttribute.class.isInstance(eStructuralFeature)) {
            return Double.NaN;
        }
        EAttribute eAttribute = (EAttribute)EAttribute.class.cast(eStructuralFeature);
        Class instanceClass = eAttribute.getEAttributeType().getInstanceClass();
        if (instanceClass == null) {
            return Double.NaN;
        }
        if (instanceClass.isPrimitive() ? !Boolean.TYPE.equals(instanceClass) : !Boolean.class.isAssignableFrom(instanceClass)) {
            return Double.NaN;
        }
        return 3.1;
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return ComponentBooleanControlSWTRenderer.class;
    }
}

