/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.renderer;

import com.st.stellar.component.renderer.ComponentTextControlSWTRenderer;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.controls.NumericalHelper;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleChangeListener;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ComponentNumberControlSWTRenderer
extends ComponentTextControlSWTRenderer {
    private final EMFFormsLocalizationService localizationService;
    private final EMFFormsLocaleProvider localeProvider;
    private EMFFormsLocaleChangeListener emfFormsLocaleChangeListener;

    @Inject
    public ComponentNumberControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport, EMFFormsLocalizationService localizationService, EMFFormsLocaleProvider localeProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        this.localizationService = localizationService;
        this.localeProvider = localeProvider;
    }

    @Override
    protected int getDefaultAlignment() {
        return 131072;
    }

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_numerical";
    }

    @Override
    protected String getTextMessage() {
        try {
            IValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
            EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
            DecimalFormat format = NumericalHelper.setupFormat((Locale)this.localeProvider.getLocale(), this.getInstanceClass(structuralFeature));
            if (format.getMaximumFractionDigits() > 1) {
                format.setMaximumFractionDigits(1);
            }
            return format.toLocalizedPattern();
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return "";
        }
    }

    @Override
    protected Object convert(Text text, EDataType attributeType, String value) throws DatabindingFailedException {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)this.getModelValue().getValueType();
        NumericalTargetToModelUpdateStrategy converter = new NumericalTargetToModelUpdateStrategy(eStructuralFeature, this.getModelValue(), this.getDataBindingContext(), text);
        return converter.convert(value);
    }

    @Override
    protected Binding[] createBindings(final Control control) throws DatabindingFailedException {
        EStructuralFeature structuralFeature = (EStructuralFeature)this.getModelValue().getValueType();
        UpdateValueStrategy targetToModelStrategy = this.withPreSetValidation((UpdateValueStrategy)new NumericalTargetToModelUpdateStrategy(structuralFeature, this.getModelValue(), this.getDataBindingContext(), (Text)((Composite)Composite.class.cast(control)).getChildren()[0]));
        NumericalModelToTargetUpdateStrategy modelToTargetStrategy = new NumericalModelToTargetUpdateStrategy(this.getInstanceClass(structuralFeature), false);
        final Binding binding = this.bindValue(control, this.getModelValue(), this.getDataBindingContext(), targetToModelStrategy, (UpdateValueStrategy)modelToTargetStrategy);
        Binding tooltipBinding = this.createTooltipBinding(control, this.getModelValue(), this.getDataBindingContext(), targetToModelStrategy, (UpdateValueStrategy)new NumericalModelToTargetUpdateStrategy(this.getInstanceClass(structuralFeature), true));
        this.emfFormsLocaleChangeListener = new EMFFormsLocaleChangeListener(){

            public void notifyLocaleChange() {
                ((Text)control).setMessage(ComponentNumberControlSWTRenderer.this.getTextMessage());
                binding.updateModelToTarget();
            }
        };
        this.localeProvider.addEMFFormsLocaleChangeListener(this.emfFormsLocaleChangeListener);
        return new Binding[]{binding, tooltipBinding};
    }

    private Class<?> getInstanceClass(EStructuralFeature feature) {
        return feature.getEType().getInstanceClass();
    }

    @Override
    protected String getTextFromTextField(Text text, EDataType attributeType) {
        if (!Object.class.isAssignableFrom(attributeType.getInstanceClass())) {
            return super.getTextFromTextField(text, attributeType);
        }
        if (text.getText() != null && text.getText().isEmpty()) {
            return null;
        }
        return super.getTextFromTextField(text, attributeType);
    }

    @Override
    protected String getUnsetText() {
        return this.localizationService.getString(((Object)((Object)this)).getClass(), "NumericalControl_NoNumberClickToSetNumber");
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.localeProvider.removeEMFFormsLocaleChangeListener(this.emfFormsLocaleChangeListener);
    }

    private class NumericalTargetToModelUpdateStrategy
    extends ComponentTextControlSWTRenderer.TargetToModelUpdateStrategy {
        private final Text text;
        private final IObservableValue modelValue;
        private final EStructuralFeature eStructuralFeature;
        private final DataBindingContext dataBindingContext;

        NumericalTargetToModelUpdateStrategy(EStructuralFeature eStructuralFeature, IObservableValue modelValue, DataBindingContext dataBindingContext, Text text) {
            super(ComponentNumberControlSWTRenderer.this, eStructuralFeature.isUnsettable());
            this.eStructuralFeature = eStructuralFeature;
            this.modelValue = modelValue;
            this.dataBindingContext = dataBindingContext;
            this.text = text;
        }

        private DecimalFormat getFormat() {
            return NumericalHelper.setupFormat((Locale)ComponentNumberControlSWTRenderer.this.localeProvider.getLocale(), ComponentNumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
        }

        @Override
        protected Object convertValue(Object value) {
            DecimalFormat format = this.getFormat();
            try {
                Number number = null;
                if (value == null) {
                    number = NumericalHelper.getDefaultValue(ComponentNumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
                } else {
                    ParsePosition pp = new ParsePosition(0);
                    number = format.parse((String)value, pp);
                    if (pp.getErrorIndex() != -1 || pp.getIndex() != ((String)value).length()) {
                        return this.getOldValue(value);
                    }
                    if (NumericalHelper.isInteger(ComponentNumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature))) {
                        boolean maxValue = false;
                        boolean minValue = false;
                        Class<?> instanceClass = ComponentNumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature);
                        try {
                            if (number.doubleValue() >= this.getInstanceMaxValue(instanceClass)) {
                                maxValue = true;
                            } else if (number.doubleValue() <= this.getInstanceMinValue(instanceClass)) {
                                minValue = true;
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            Activator.logException((Exception)ex);
                        }
                        catch (SecurityException ex) {
                            Activator.logException((Exception)ex);
                        }
                        catch (IllegalAccessException ex) {
                            Activator.logException((Exception)ex);
                        }
                        catch (NoSuchFieldException ex) {
                            Activator.logException((Exception)ex);
                        }
                        if (maxValue || minValue) {
                            return NumericalHelper.numberToInstanceClass((Number)number, ComponentNumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
                        }
                    }
                }
                String formatedNumber = "";
                if (number != null) {
                    formatedNumber = format.format(number);
                }
                if (formatedNumber.length() == 0) {
                    return null;
                }
                return NumericalHelper.numberToInstanceClass((Number)format.parse(formatedNumber), ComponentNumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
            }
            catch (ParseException ex) {
                return this.getOldValue(value);
            }
        }

        private double getInstanceMinValue(Class<?> instanceClass) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
            if (Integer.class.isAssignableFrom(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                return -2.147483648E9;
            }
            if (Long.class.isAssignableFrom(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) {
                return -9.223372036854776E18;
            }
            if (Short.class.isAssignableFrom(instanceClass) || Short.class.getField("TYPE").get(null).equals(instanceClass)) {
                return -32768.0;
            }
            return Double.NaN;
        }

        private double getInstanceMaxValue(Class<?> instanceClass) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
            if (Integer.class.isAssignableFrom(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                return 2.147483647E9;
            }
            if (Long.class.isAssignableFrom(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) {
                return 9.223372036854776E18;
            }
            if (Short.class.isAssignableFrom(instanceClass) || Short.class.getField("TYPE").get(null).equals(instanceClass)) {
                return 32767.0;
            }
            return Double.NaN;
        }

        protected IStatus doSet(IObservableValue observableValue, Object value) {
            IStatus status = super.doSet(observableValue, value);
            this.dataBindingContext.updateTargets();
            return status;
        }

        private Object getOldValue(Object value) {
            if (this.eStructuralFeature.getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = this.modelValue.getValue();
            MessageDialog messageDialog = new MessageDialog(this.text.getShell(), ComponentNumberControlSWTRenderer.this.localizationService.getString(((Object)((Object)this)).getClass(), "NumericalControl_InvalidNumber"), null, ComponentNumberControlSWTRenderer.this.localizationService.getString(((Object)((Object)this)).getClass(), "NumericalControl_InvalidNumberWillBeUnset"), 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor(this, (Dialog)messageDialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
            this.dataBindingContext.updateTargets();
            if (this.eStructuralFeature.isUnsettable() && result == null) {
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }

    private class NumericalModelToTargetUpdateStrategy
    extends ComponentTextControlSWTRenderer.ModelToTargetUpdateStrategy {
        private final Class<?> instanceClass;

        NumericalModelToTargetUpdateStrategy(Class<?> instanceClass, boolean tooltip) {
            super(ComponentNumberControlSWTRenderer.this, tooltip);
            this.instanceClass = instanceClass;
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return "";
            }
            DecimalFormat format = NumericalHelper.setupFormat((Locale)ComponentNumberControlSWTRenderer.this.localeProvider.getLocale(), this.instanceClass);
            return format.format(value);
        }
    }
}

