/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.dynamicChoice.renderer.dynamicChoiceControl;

import com.st.stellar.StellarHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.emf.databinding.IEMFObservable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.view.internal.core.swt.MatchItemComboViewer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emfforms.spi.common.BundleResolver;
import org.eclipse.emfforms.spi.common.BundleResolverFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;

public class DynamicChoiceCellEditor
extends CellEditor
implements ECPCellEditor {
    private static final String LOCALIZATION_KEY_TEMPLATE = "_UI_%s_%s_literal";
    private EMFFormsLocalizationService l10n;
    private MatchItemComboViewer viewer;
    private int minWidth;
    private EAttribute attribute;
    private EObject modelObject;
    private BundleResolver bundleResolver = BundleResolverFactory.createBundleResolver();
    private Optional<Bundle> editBundle;
    private Optional<EObject> source = Optional.empty();

    public DynamicChoiceCellEditor(Composite parent) {
        super(parent);
    }

    public DynamicChoiceCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    public DynamicChoiceCellEditor(Composite parent, int style, BundleResolver bundleResolver, EMFFormsLocalizationService l10n) {
        this(parent, style);
        this.bundleResolver = bundleResolver;
        this.l10n = l10n;
    }

    public UpdateValueStrategy getModelToTargetStrategy(final DataBindingContext databindingContext) {
        return new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (!DynamicChoiceCellEditor.this.source.isPresent()) {
                    DynamicChoiceCellEditor.this.source = DynamicChoiceCellEditor.this.inferSource(databindingContext);
                }
                return value;
            }
        };
    }

    public UpdateValueStrategy getTargetToModelStrategy(DataBindingContext databindingContext) {
        return new UpdateValueStrategy();
    }

    protected Control createControl(Composite parent) {
        this.viewer = new MatchItemComboViewer(new CCombo(parent, 0)){

            public void onEnter() {
                super.onEnter();
                DynamicChoiceCellEditor.this.applySelection();
                DynamicChoiceCellEditor.this.focusLost();
            }

            protected void onEscape() {
                DynamicChoiceCellEditor.this.fireCancelEditor();
            }
        };
        CCombo combo = this.viewer.getCCombo();
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)combo);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EnumLabelProvider());
        combo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                DynamicChoiceCellEditor.this.applySelection();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        return combo;
    }

    private void applySelection() {
        CCombo combo = this.viewer.getCCombo();
        int selection = combo.getSelectionIndex();
        if (selection >= 0) {
            List input = (List)this.viewer.getInput();
            this.viewer.setSelection((ISelection)new StructuredSelection(input.get(selection)));
        }
    }

    protected List<?> getChoiceOfValues() {
        Collection providerChoices = this.getPropertyDescriptor().map(descriptor -> descriptor.getChoiceOfValues((Object)this.getSource().get())).orElse(Collections.emptySet());
        List<String> result = this.getELiterals();
        if (!providerChoices.isEmpty()) {
            result.retainAll(providerChoices);
        }
        return result;
    }

    public String getFormatedString(Object value) {
        return this.getPropertyDescriptor().map(desc -> desc.getLabelProvider((Object)this.getSource().get())).map(lp -> lp.getText(value)).orElseGet(() -> this.getLabel((String)value));
    }

    private String getLabel(String enumValue) {
        return enumValue;
    }

    public void instantiate(EStructuralFeature feature, ViewModelContext viewModelContext) {
        if (this.l10n == null) {
            this.l10n = (EMFFormsLocalizationService)viewModelContext.getService(EMFFormsLocalizationService.class);
        }
        this.attribute = (EAttribute)feature;
        this.modelObject = viewModelContext.getDomainModel();
        try {
            this.editBundle = Optional.of(this.bundleResolver.getEditBundle(feature.getEType()));
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            ((ReportService)viewModelContext.getService(ReportService.class)).report(new AbstractReport(MessageFormat.format("No edit bundle was found for EEnum ''{0}''. Hence, its literals cannot be internationalized for feature ''{1}''.", feature.getEType().getName(), feature.getName()), 2));
            this.editBundle = Optional.empty();
        }
        List<?> choices = this.getChoiceOfValues();
        this.viewer.getCCombo().setVisibleItemCount(Math.min(choices.size(), 8));
        Point emptyViewerSize = this.viewer.getCCombo().computeSize(-1, -1, true);
        this.minWidth = 50;
        this.minWidth += emptyViewerSize.x;
    }

    public IValueProperty getValueProperty() {
        return new ComboValueProperty();
    }

    public void activate(ColumnViewerEditorActivationEvent actEvent) {
        CCombo control;
        this.viewer.setInput(this.getChoiceOfValues());
        this.source.ifPresent(obj -> this.viewer.getCCombo().setText(this.getFormatedString(obj.eGet((EStructuralFeature)this.attribute))));
        super.activate(actEvent);
        if (actEvent.eventType == 1 && (control = (CCombo)this.getControl()) != null && Character.isLetterOrDigit(actEvent.character)) {
            this.viewer.getBuffer().reset();
            this.viewer.getBuffer().addLast(Character.valueOf(actEvent.character));
        }
    }

    public void deactivate() {
        super.deactivate();
        this.source = Optional.empty();
    }

    public int getColumnWidthWeight() {
        return 100;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public Image getImage(Object value) {
        return null;
    }

    public void setEditable(boolean editable) {
        this.viewer.getCCombo().setEnabled(editable);
    }

    private Optional<EObject> inferSource(DataBindingContext context) {
        return context.getBindings().stream().map(Binding.class::cast).map(Binding::getModel).filter(IEMFObservable.class::isInstance).map(IEMFObservable.class::cast).filter(obs -> obs.getStructuralFeature() == this.attribute).map(IObserving::getObserved).map(EObject.class::cast).findAny();
    }

    protected Optional<EObject> getSource() {
        return this.source;
    }

    protected Optional<IItemPropertyDescriptor> getPropertyDescriptor() {
        return this.getSource().flatMap(source -> DynamicChoiceCellEditor.getPropertyDescriptor(source, this.attribute.getName()));
    }

    protected Object doGetValue() {
        return this.viewer.getStructuredSelection().getFirstElement();
    }

    protected void doSetValue(Object value) {
        this.viewer.setSelection((ISelection)(value == null ? StructuredSelection.EMPTY : new StructuredSelection(value)));
    }

    protected void doSetFocus() {
        CCombo combo = this.viewer.getCCombo();
        if (combo == null || combo.isDisposed()) {
            return;
        }
        combo.setFocus();
        String text = combo.getText();
        if (text != null) {
            combo.setSelection(new Point(text.length(), text.length()));
        }
    }

    static Optional<IItemPropertyDescriptor> getPropertyDescriptor(EObject object, String propertyName) {
        return EMFUtils.adapt((EObject)object, IItemPropertySource.class).map(propertySource -> propertySource.getPropertyDescriptor((Object)object, (Object)propertyName));
    }

    public List<String> getELiterals() {
        String[] eLiterals;
        ArrayList<String> filtered = new ArrayList<String>();
        for (String literal : eLiterals = this.getItems().split(",")) {
            filtered.add(literal);
        }
        return filtered;
    }

    public String getItems() {
        String res = null;
        EAttribute feature = this.attribute;
        EAnnotation featureAnnotation = feature.getEType().getEAnnotation("com.st.stellar.annotation");
        if (featureAnnotation != null) {
            String itemsStr;
            String functionName = (String)featureAnnotation.getDetails().get((Object)"DynamicChoice");
            res = itemsStr = StellarHelper.getItems((Object)this.modelObject, (String)functionName);
        }
        return res;
    }

    private class EnumLabelProvider
    extends LabelProvider {
        EnumLabelProvider() {
        }

        public String getText(Object element) {
            return DynamicChoiceCellEditor.this.getFormatedString(element);
        }
    }

    private class ComboValueProperty
    extends SimpleValueProperty<Object, Object> {
        private ComboValueProperty() {
        }

        public Object getValueType() {
            return CCombo.class;
        }

        protected Object doGetValue(Object source) {
            return DynamicChoiceCellEditor.this.getValue();
        }

        protected void doSetValue(Object source, Object value) {
            DynamicChoiceCellEditor.this.doSetValue(value);
        }

        public IObservableValue observe(Object source) {
            if (source != DynamicChoiceCellEditor.this) {
                return Observables.constantObservableValue(null);
            }
            return ViewerProperties.singleSelection().observe((Viewer)DynamicChoiceCellEditor.this.viewer);
        }

        public INativePropertyListener<Object> adaptListener(ISimplePropertyListener<Object, ValueDiff<? extends Object>> listener) {
            return null;
        }
    }
}

