<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" indent="yes" />
    <xsl:template match="/">
        <html lang="fr">
        <head>
            <meta charset="UTF-8"/>
            <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
            <title>Welcome</title>
            <style>
                body, html {
                    margin: 0;
                    padding: 0;
                    height: 100%;
                    overflow: hidden;
                }
                .header {
                    background-color: #ececec;
                    color: black;
                    display: flex;
                    align-items: center;
                    padding: 1em;
                    font-size: 1.5em;
                    position: relative;
                }
                .header img {
                    height: 50px;
                    margin-right: 10px;
                }
                .header-content {
                    flex: 1;
                    text-align: center;
                }
                .header-text {
                    margin: 0;
                }
                .copyright-text {
                    font-size: 0.5em;
                    margin-top: 0.5em;
                }
                .license {
                    font-size: 0.5em;
                    margin-top: 0.5em;
                    text-decoration: underline;
                }
                .container {
                    display: flex;
                    height: calc(100% - 60px);
                }
                .left, .center, .right {
                    flex: 1;
                    transition: flex 0.8s;
                    position: relative;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                }
                .left img, .center img, .right img {
                    width: 100%;
                    height: 100%;
                    object-fit: cover;
                }
                .left::after, .center::after, .right::after {
                    content: '';
                    position: absolute;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    background: rgba(255, 255, 255, 0.5);
                    pointer-events: none;
                    transition: background 0.5s;
                }
                .left:hover::after, .center:hover::after, .right:hover::after {
                    background: rgba(255, 255, 255, 0);
                }
                .left {
                    background-color: #2b0a3d;
                }
                .center {
                    background-color: #12abdb;
                }
                .right {
                    background-color: #0171ad;
                }
                .rectangle {
                    width: 65%;
                    height: 50%;
                    background-color: rgba(202, 202, 202, 0.909);
                    border-radius: 25px;
                    position: absolute;
                    z-index: 1;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    opacity: 0;
                    transition: opacity 0.5s;
                }
                .left:hover .rectangle,
                .center:hover .rectangle,
                .right:hover .rectangle {
                    opacity: 1;
                }
                .left:hover {
                    flex: 2;
                }
                .center:hover {
                    flex: 2;
                }
                .right:hover {
                    flex: 2;
                }
                .rectangle-content {
                    display: flex;
                    align-items: center;
                }
                .rectangle-content img {
                    width: 50%;
                    height: 50%;
                    margin-right: 10px;
                }
                .rectangle-content button {
                    padding: 10px 20px;
                    font-size: 1.2em;
                    border-radius: 15px;
                    border: none;
                    background-color: #0171ad;
                    color: white;
                    cursor: pointer;
                    transition: background-color 0.3s, transform 0.3s;
                }
                .rectangle-content button:hover {
                    background-color: #005f8d;
                    transform: scale(1.1);
                }
            </style>
            <script>
                function goToSTSite() {
                    window.location.href = "http://www.st.com/";
                }
            </script>
        </head>
        <body>
            <div class="header">
                <img src="{/page/header/logo/@src}" alt="{/page/header/logo/@alt}"/>
                <div class="header-content">
                    <div class="header-text">
                        <xsl:value-of select="/page/header/title"/>
                    </div>
                    <a class="license">
                        <xsl:value-of select="/page/header/license"/>
                    </a>
                    <div class="copyright-text">
                        <xsl:value-of select="/page/header/copyright"/>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="left">
                    <img src="{/page/container/section[@class='left']/image/@src}" alt="{/page/container/section[@class='left']/image/@alt}"/>
                    <div class="rectangle">
                        <div class="rectangle-content">
                            <img src="{/page/container/section[@class='left']/rectangle/content/smallImage/@src}" alt="{/page/container/section[@class='left']/rectangle/content/smallImage/@alt}"/>
                            <button>
                                <xsl:value-of select="/page/container/section[@class='left']/rectangle/content/button"/>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="center">
                    <img src="{/page/container/section[@class='center']/image/@src}" alt="{/page/container/section[@class='center']/image/@alt}"/>
                    <div class="rectangle">
                        <div class="rectangle-content">
                            <img src="{/page/container/section[@class='center']/rectangle/content/smallImage/@src}" alt="{/page/container/section[@class='center']/rectangle/content/smallImage/@alt}"/>
                            <button onclick="goToSTSite()">
                                <xsl:value-of select="/page/container/section[@class='center']/rectangle/content/button"/>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="right">
                    <img src="{/page/container/section[@class='right']/image/@src}" alt="{/page/container/section[@class='right']/image/@alt}"/>
                    <div class="rectangle">
                        <div class="rectangle-content">
                            <h2>
                                <xsl:value-of select="/page/container/section[@class='right']/rectangle/content/text"/>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </body>
        </html>
    </xsl:template>
</xsl:stylesheet>