/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.image.renderer.imagecontrol;

import com.st.stellar.ObjectCache;
import com.st.stellar.StellarHelper;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.framework.Bundle;

public class ImageControlRenderer
extends TextControlSWTRenderer {
    Logger logger = LogManager.getLogger(ImageControlRenderer.class);
    Label _labelImage = null;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    Hashtable<String, Integer> EXT_IMAGE_ALIGNS = new Hashtable<String, Integer>(){
        private static final long serialVersionUID = 4853102494688101985L;
        {
            this.put("left", 0);
            this.put("center", 1);
            this.put("right", 2);
        }
    };
    private static Map<String, Image> _images = new ObjectCache(200);

    @Inject
    public ImageControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
    }

    private Image getImage(String file) {
        try {
            URL url;
            Bundle bundle = StellarHelper.getBundle((EObject)this.getFeature());
            if (bundle != null && (url = bundle.getResource(file)) != null) {
                Image iconImage = _images.get(url.toString());
                if (iconImage == null) {
                    iconImage = new Image((Device)Display.getCurrent(), url.openStream());
                    _images.put(url.toString(), iconImage);
                }
                return iconImage;
            }
        }
        catch (DatabindingFailedException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        catch (IOException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        return null;
    }

    private int getTextWidth(String text) {
        if (text != null) {
            return 100;
        }
        return 0;
    }

    protected int getDefaultAlignment() {
        return 131072;
    }

    protected Control createSWTControl(Composite parent) {
        Composite innerComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(innerComposite);
        Composite composite = new Composite(innerComposite, 0);
        FormLayout fLayout = new FormLayout();
        fLayout.marginLeft = 0;
        fLayout.marginRight = 0;
        fLayout.marginTop = 0;
        fLayout.marginBottom = 0;
        composite.setLayout((Layout)fLayout);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)composite);
        String text = null;
        try {
            EAnnotation annotation = this.getFeature().getEAnnotation("com.st.stellar.annotation");
            if (annotation != null) {
                text = (String)annotation.getDetails().get((Object)"Description");
                if (text != null) {
                    text = text.replaceAll("\n", "");
                    text = text.replaceAll("\r", "");
                    text = text.replaceAll("\t", " ");
                    text = text.replaceAll("\\s+", " ");
                    text = text.replaceAll("<br>", "\r");
                    text = text.replaceAll("<br/>", "\r");
                    String align = (String)annotation.getDetails().get((Object)"Align");
                    switch (this.EXT_IMAGE_ALIGNS.get(align)) {
                        case 2: {
                            Label labelText = new Label(composite, 655424);
                            labelText.setText(text);
                            this._labelImage = new Label(composite, 524288);
                            FormData labelTextLayoutData = new FormData();
                            labelTextLayoutData.right = new FormAttachment((Control)this._labelImage, -5, 16384);
                            labelTextLayoutData.left = new FormAttachment(0, 0);
                            labelText.setLayoutData((Object)labelTextLayoutData);
                            labelTextLayoutData.width = this.getTextWidth(text);
                            this._labelImage.setImage(this.getImage((String)annotation.getDetails().get((Object)"Image")));
                            FormData labelImageLayoutData = new FormData();
                            labelImageLayoutData.right = new FormAttachment(100, 0);
                            this._labelImage.setLayoutData((Object)labelImageLayoutData);
                            break;
                        }
                        case 1: {
                            Composite child = new Composite(composite, 0);
                            FormData compositeLayoutData = new FormData();
                            compositeLayoutData.left = new FormAttachment(0, 0);
                            compositeLayoutData.right = new FormAttachment(100, 0);
                            child.setLayoutData((Object)compositeLayoutData);
                            TableWrapLayout layout = new TableWrapLayout();
                            layout.topMargin = 10;
                            layout.bottomMargin = 10;
                            layout.verticalSpacing = 5;
                            layout.leftMargin = 0;
                            layout.rightMargin = 0;
                            layout.numColumns = 3;
                            child.setLayout((Layout)layout);
                            Label textLeft = new Label(child, 540672);
                            textLeft.setLayoutData((Object)new TableWrapData(256, 256));
                            textLeft.setText(text);
                            this._labelImage = new Label(child, 0x1080000);
                            this._labelImage.setImage(this.getImage((String)annotation.getDetails().get((Object)"Image")));
                            TableWrapData imageLayout = new TableWrapData(4, 256);
                            this._labelImage.setLayoutData((Object)imageLayout);
                            Label textRight = new Label(child, 655360);
                            textRight.setLayoutData((Object)new TableWrapData(256, 256));
                            textRight.setText(text);
                            break;
                        }
                        default: {
                            this._labelImage = new Label(composite, 540672);
                            this._labelImage.setImage(this.getImage((String)annotation.getDetails().get((Object)"Image")));
                            FormData labelImageLayoutData = new FormData();
                            labelImageLayoutData.left = new FormAttachment(0, 0);
                            this._labelImage.setLayoutData((Object)labelImageLayoutData);
                            Label labelText = new Label(composite, 540736);
                            labelText.setText(text);
                            FormData labelTextLayoutData = new FormData();
                            labelTextLayoutData.right = new FormAttachment(100, 0);
                            labelTextLayoutData.left = new FormAttachment((Control)this._labelImage, 5, 131072);
                            labelTextLayoutData.width = 10;
                            labelText.setLayoutData((Object)labelTextLayoutData);
                            break;
                        }
                    }
                } else {
                    String align = (String)annotation.getDetails().get((Object)"Align");
                    switch (this.EXT_IMAGE_ALIGNS.get(align)) {
                        case 1: {
                            Composite child = new Composite(composite, 0);
                            FormData compositeLayoutData = new FormData();
                            compositeLayoutData.left = new FormAttachment(0, 0);
                            compositeLayoutData.right = new FormAttachment(100, 0);
                            child.setLayoutData((Object)compositeLayoutData);
                            TableWrapLayout layout = new TableWrapLayout();
                            layout.topMargin = 10;
                            layout.bottomMargin = 10;
                            layout.verticalSpacing = 5;
                            layout.leftMargin = 0;
                            layout.rightMargin = 0;
                            layout.numColumns = 3;
                            child.setLayout((Layout)layout);
                            Label textLeft = new Label(child, 540672);
                            textLeft.setLayoutData((Object)new TableWrapData(256, 256));
                            this._labelImage = new Label(child, 0x1080000);
                            this._labelImage.setImage(this.getImage((String)annotation.getDetails().get((Object)"Image")));
                            TableWrapData imageLayout = new TableWrapData(4, 256);
                            this._labelImage.setLayoutData((Object)imageLayout);
                            Label textRight = new Label(child, 655360);
                            textRight.setLayoutData((Object)new TableWrapData(256, 256));
                            break;
                        }
                        case 0: {
                            this._labelImage = new Label(composite, 540672);
                            this._labelImage.setImage(this.getImage((String)annotation.getDetails().get((Object)"Image")));
                            TableWrapData imageLayout = new TableWrapData(256, 256);
                            this._labelImage.setLayoutData((Object)imageLayout);
                            FormData labelImageLayoutData = new FormData();
                            labelImageLayoutData.left = new FormAttachment(0, 0);
                            this._labelImage.setLayoutData((Object)labelImageLayoutData);
                            break;
                        }
                        default: {
                            this._labelImage = new Label(composite, 655360);
                            this._labelImage.setImage(this.getImage((String)annotation.getDetails().get((Object)"Image")));
                            FormData labelImageLayoutData = new FormData();
                            labelImageLayoutData.right = new FormAttachment(100, 0);
                            this._labelImage.setLayoutData((Object)labelImageLayoutData);
                            break;
                        }
                    }
                }
            }
        }
        catch (DatabindingFailedException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        return innerComposite;
    }

    protected int getTextWidgetStyle() {
        int textStyle = 834;
        return 834;
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        return new Binding[0];
    }
}

