/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.model.lib.utils;

import com.st.stellar.model.lib.ModelMigration;
import com.st.stellar.model.lib.extension.ExtensionDescription;
import com.st.stellar.model.lib.extension.ModelInstanceExtensionParser;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.MapExtensions;

public class ModelProvider {
    public static final String ID = "com.st.stellar.model.lib";
    private static final Logger LOG = Logger.getLogger(ModelProvider.class);
    public static List<URI> LIB_LIST = new ArrayList<URI>();
    public static final Map<String, ModelMigration> MIGRATION_MAP = new LinkedHashMap<String, ModelMigration>();
    public static final String INCLUDES = "includes";
    private static ModelProvider INSTANCE = null;
    private final Map<String, Map<String, Set<ExtensionDescription>>> MODELS_MAP = new LinkedHashMap<String, Map<String, Set<ExtensionDescription>>>();
    private final Map<String, Map<String, Set<ExtensionDescription>>> MIGRATIONS_MAP = new LinkedHashMap<String, Map<String, Set<ExtensionDescription>>>();

    public static boolean registerLib(URI uri) {
        boolean _xblockexpression = false;
        String _string = uri.toString();
        String _plus = "add " + _string;
        LOG.info((Object)_plus);
        _xblockexpression = LIB_LIST.add(uri);
        return _xblockexpression;
    }

    public static ModelMigration registerMigration(String uri, String version, ModelMigration toApply) {
        ModelMigration _xifexpression = null;
        if (toApply != null) {
            ModelMigration _xblockexpression = null;
            String _string = toApply.toString();
            String _plus = "add migration: URI " + uri + ", version " + version + " " + _string;
            LOG.info((Object)_plus);
            String key = uri + ":" + version;
            _xifexpression = _xblockexpression = MIGRATION_MAP.put(key, toApply);
        } else {
            LOG.error((Object)("add migration failed: URI " + uri + ", version " + version + " null"));
        }
        return _xifexpression;
    }

    public void applyMigration(String uri, String from, String to, String path) {
        String key = uri + ":" + to;
        ModelMigration migration = MIGRATION_MAP.get(key);
        if (migration != null) {
            String oldFile = path;
            String newFile = this.replaceFileExtension(oldFile, "old");
            migration.apply(oldFile, newFile);
        }
    }

    public String replaceFileExtension(String filePath, String ext) {
        int lastPeriodIndex;
        boolean _not;
        Object newExtension = ext;
        boolean _startsWith = ((String)newExtension).startsWith(".");
        boolean bl = _not = !_startsWith;
        if (_not) {
            newExtension = "." + (String)newExtension;
        }
        if ((lastPeriodIndex = filePath.lastIndexOf(".")) <= 0) {
            return filePath + (String)newExtension;
        }
        String _substring = filePath.substring(0, lastPeriodIndex);
        return _substring + (String)newExtension;
    }

    public static synchronized ModelProvider getInstance() {
        ModelProvider _xblockexpression = null;
        if (INSTANCE == null) {
            ModelProvider _modelProvider;
            INSTANCE = _modelProvider = new ModelProvider();
            INSTANCE.init();
        }
        _xblockexpression = INSTANCE;
        return _xblockexpression;
    }

    public void init() {
        Map<URI, List<ExtensionDescription>> extensionURIS = ModelInstanceExtensionParser.getExtensionModelURIS();
        Set<URI> _keySet = extensionURIS.keySet();
        for (URI uri : _keySet) {
            InputOutput.println((Object)uri);
            List<ExtensionDescription> extensions = extensionURIS.get(uri);
            Pattern pattern = Pattern.compile("^[^\\.]+.([^\\.]+)$");
            for (ExtensionDescription desc : extensions) {
                Matcher matcher = pattern.matcher(uri.lastSegment());
                boolean _find = matcher.find();
                if (!_find) continue;
                String ext = matcher.group(1);
                this.registerModel(ext, desc);
            }
        }
        ModelInstanceExtensionParser.loadExtension();
    }

    public void registerModel(String ext, ExtensionDescription extensionDescription) {
        Map<String, Set<ExtensionDescription>> descriptionMap;
        boolean _containsKey_1;
        boolean _not_1;
        boolean _not;
        boolean _containsKey = this.MODELS_MAP.containsKey(ext);
        boolean bl = _not = !_containsKey;
        if (_not) {
            LinkedHashMap _linkedHashMap = new LinkedHashMap();
            this.MODELS_MAP.put(ext, _linkedHashMap);
        }
        boolean bl2 = _not_1 = !(_containsKey_1 = (descriptionMap = this.MODELS_MAP.get(ext)).containsKey(ext));
        if (_not_1) {
            LinkedHashSet _linkedHashSet = new LinkedHashSet();
            descriptionMap.put(ext, _linkedHashSet);
        }
        descriptionMap.get(ext).add(extensionDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLib(Class<?> clazz, ResourceSet resourceSet, String ext) {
        try {
            List<URI> list = LIB_LIST;
            synchronized (list) {
                for (URI str : LIB_LIST) {
                    boolean _equals = str.fileExtension().equals(ext);
                    if (!_equals) continue;
                    URL url = clazz.getClassLoader().getResource(str.path());
                    InputStream stream = url.openStream();
                    Resource resource = resourceSet.createResource(URI.createFileURI((String)url.getPath()));
                    String urlPath = url.getPath();
                    LOG.info((Object)("loading library " + urlPath));
                    resource.load(stream, resourceSet.getLoadOptions());
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLib(ResourceSet resourceSet) {
        try {
            List<URI> list = LIB_LIST;
            synchronized (list) {
                Iterator<URI> iterator = LIB_LIST.iterator();
                while (iterator.hasNext()) {
                    URI str;
                    URI uri = str = iterator.next();
                    Resource resource = resourceSet.createResource(uri);
                    String urlPath = uri.path();
                    LOG.info((Object)("loading library " + urlPath));
                    resource.load(resourceSet.getLoadOptions());
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public List<ExtensionDescription> getModels(String ext) {
        ArrayList _xblockexpression = null;
        ArrayList models = CollectionLiterals.newArrayList();
        Map<String, Set<ExtensionDescription>> exts = this.MODELS_MAP.get(ext);
        if (exts != null) {
            Functions.Function2 _function = (k, v) -> k.equals(ext);
            Set comps = MapExtensions.filter(exts, (Functions.Function2)_function).entrySet();
            for (Map.Entry c : comps) {
                Set _value = (Set)c.getValue();
                for (ExtensionDescription v2 : _value) {
                    models.add(v2);
                }
            }
        }
        _xblockexpression = models;
        return _xblockexpression;
    }

    public List<ExtensionDescription> getMigrations(String ext) {
        ArrayList _xblockexpression = null;
        ArrayList models = CollectionLiterals.newArrayList();
        Map<String, Set<ExtensionDescription>> exts = this.MODELS_MAP.get(ext);
        if (exts != null) {
            Functions.Function2 _function = (k, v) -> k.equals(ext);
            Set comps = MapExtensions.filter(exts, (Functions.Function2)_function).entrySet();
            for (Map.Entry c : comps) {
                Set _value = (Set)c.getValue();
                for (ExtensionDescription v2 : _value) {
                    models.add(v2);
                }
            }
        }
        _xblockexpression = models;
        return _xblockexpression;
    }

    public static String displayString(URI uri) {
        return uri.toString().replaceAll("platform:/plugin/com.st.stellar.model.lib/lib/", "");
    }

    private IFile getFile(URI uri) {
        IFile _xifexpression = null;
        if (uri.isPlatformResource() && uri.segmentCount() > 2) {
            IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
            String _platformString = uri.toPlatformString(true);
            Path _path = new Path(_platformString);
            _xifexpression = _root.getFile((IPath)_path);
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public List<URI> getLocalModels(Resource resource, List<String> extensions) {
        try {
            ArrayList _xblockexpression = null;
            ArrayList files = CollectionLiterals.newArrayList();
            IFile file = this.getFile(resource.getURI());
            IProject project = file.getProject();
            ComponentVisitor visitor = new ComponentVisitor(files, extensions);
            ArrayList handles = CollectionLiterals.newArrayList();
            try {
                project.accept((IResourceProxyVisitor)visitor, 0);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    LOG.error((Object)e.getMessage());
                    return handles;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            for (IResource _next : files) {
                IFile f = (IFile)_next;
                String decodedUri = URLDecoder.decode(f.getProjectRelativePath().toOSString(), "UTF-8");
                URI uri = URI.createFileURI((String)decodedUri);
                handles.add(uri);
            }
            _xblockexpression = handles;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static class ComponentVisitor
    implements IResourceProxyVisitor {
        private List<IResource> _list;
        private List<String> _extensions;

        public ComponentVisitor(ArrayList<IResource> list, List<String> extensions) {
            this._list = list;
            this._extensions = extensions;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            boolean _equals;
            int _type = proxy.getType();
            boolean bl = _equals = _type == 1;
            if (_equals) {
                String _name = proxy.getName();
                String ext = new Path(_name).getFileExtension();
                boolean _contains = this._extensions.contains(ext);
                if (_contains) {
                    this._list.add(proxy.requestResource());
                }
                return false;
            }
            return true;
        }
    }
}

