/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.model.lib.extension;

import com.st.stellar.model.lib.ModelMigration;
import com.st.stellar.model.lib.extension.ExtensionDescription;
import com.st.stellar.model.lib.utils.ModelProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;

public class ModelInstanceExtensionParser {
    static final Logger LOG = Logger.getLogger(ModelInstanceExtensionParser.class);
    public static final String MODEL_EXTENSION_POINTS = "com.st.stellar.model.lib.model";
    private static final String FILEPATH_ATTRIBUTE = "filePath";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String FILTER_ELEMENT = "filter";
    private static final String FILTER_VALUE_ATTRIBUTE = "value";
    private static final String FILTER_KEY_ATTRIBUTE = "key";
    private static boolean initialized = false;
    public static final String ELEM_MODEL = "model";
    public static final String ATT_INSTANCE = "instance";
    private static final Map<Object, Object> LOAD_OPTIONS = new LinkedHashMap<Object, Object>();
    public static final String ELEM_MIGRATION = "migration";
    public static final String ATT_FROM_VERSION = "from";
    public static final String ATT_TO_VERSION = "to";
    public static final String ATT_MODEL_URI = "model_uri";
    public static final String ATT_CLASS = "class";

    public ModelInstanceExtensionParser() {
        LOAD_OPTIONS.put("TIMEOUT", 1);
        LOAD_OPTIONS.put("DEFER_ATTACHMENT", Boolean.TRUE);
        LOAD_OPTIONS.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        LOAD_OPTIONS.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
    }

    public static void loadExtension() {
        if (!initialized) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(MODEL_EXTENSION_POINTS);
            if (point != null) {
                IExtension[] extensions;
                for (IExtension extension : extensions = point.getExtensions()) {
                    if (!extension.isValid()) continue;
                    ModelInstanceExtensionParser.loadModelInstance(extension);
                    ModelInstanceExtensionParser.loadMigrationInstance(extension);
                }
            }
            initialized = true;
        }
    }

    private static void loadModelInstance(IExtension extension) {
        IConfigurationElement[] models;
        for (IConfigurationElement model : models = ModelInstanceExtensionParser.getConfigElements(extension, ELEM_MODEL)) {
            String filePath = model.getAttribute(FILEPATH_ATTRIBUTE);
            LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>();
            String bundleName = model.getContributor().getName();
            String path = bundleName + "/" + filePath;
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            String key = "extension";
            String value = uri.lastSegment();
            keyValuePairs.put(key, value);
            String defaultAtt = model.getAttribute(DEFAULT_ATTRIBUTE);
            key = DEFAULT_ATTRIBUTE;
            value = defaultAtt != null ? defaultAtt : "false";
            keyValuePairs.put(key, value);
            ModelProvider.registerLib(uri);
        }
    }

    private static void loadMigrationInstance(IExtension extension) {
        IConfigurationElement[] models;
        for (IConfigurationElement model : models = ModelInstanceExtensionParser.getConfigElements(extension, ELEM_MIGRATION)) {
            String modelUri = model.getAttribute(ATT_MODEL_URI);
            LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>();
            String bundleName = model.getContributor().getName();
            String path = bundleName + "/" + modelUri;
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            String version = model.getAttribute(ATT_TO_VERSION);
            String key = "extension";
            String value = uri.lastSegment();
            keyValuePairs.put(key, value);
            String defaultAtt = model.getAttribute(DEFAULT_ATTRIBUTE);
            key = DEFAULT_ATTRIBUTE;
            value = defaultAtt != null ? defaultAtt : "false";
            keyValuePairs.put(key, value);
            ModelMigration migration = null;
            String className = model.getAttribute(ATT_CLASS);
            if (className == null) continue;
            try {
                migration = (ModelMigration)model.createExecutableExtension(ATT_CLASS);
                ModelProvider.registerMigration(modelUri, version, migration);
            }
            catch (CoreException e) {
                LOG.error((Object)NLS.bind((String)"Cannot find migration class '{0}'", (Object)className));
                LOG.error((Object)e.getMessage());
            }
        }
    }

    public static Map<URI, List<ExtensionDescription>> getExtensionModelURIS() {
        LinkedHashMap<URI, List<ExtensionDescription>> ret = new LinkedHashMap<URI, List<ExtensionDescription>>();
        IConfigurationElement[] files = Platform.getExtensionRegistry().getConfigurationElementsFor(MODEL_EXTENSION_POINTS);
        URIConverter converter = new ResourceSetImpl().getURIConverter();
        for (IConfigurationElement file : files) {
            System.out.println(file.getName());
            if (!file.getName().equals(ELEM_MODEL)) continue;
            System.out.println(file.getValue());
            System.out.println(file.getDeclaringExtension());
            for (String a : file.getAttributeNames()) {
                System.out.println("attribute: " + a);
            }
            String filePath = file.getAttribute(FILEPATH_ATTRIBUTE);
            LinkedHashMap<String, Object> keyValuePairs = new LinkedHashMap<String, Object>();
            String bundleName = file.getContributor().getName();
            String path = bundleName + "/" + filePath;
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            String key = "extension";
            String value = uri.lastSegment();
            keyValuePairs.put(key, value);
            IConfigurationElement[] children = file.getChildren(FILTER_ELEMENT);
            String defaultAtt = file.getAttribute(DEFAULT_ATTRIBUTE);
            key = DEFAULT_ATTRIBUTE;
            value = defaultAtt != null ? defaultAtt : "false";
            keyValuePairs.put(key, value);
            for (IConfigurationElement child : children) {
                String childKey = child.getAttribute(FILTER_KEY_ATTRIBUTE);
                String childValue = child.getAttribute(FILTER_VALUE_ATTRIBUTE);
                keyValuePairs.put(childKey, childValue);
            }
            if (!converter.exists(uri, LOAD_OPTIONS)) {
                LOG.error((Object)String.format("The provided uri '%1$s' doesn't point to an existing file.", uri.toString()));
                continue;
            }
            if (!ret.containsKey(uri)) {
                ret.put(uri, new ArrayList());
            }
            ((List)ret.get(uri)).add(new ExtensionDescription(keyValuePairs, uri));
        }
        return ret;
    }

    public static Map<URI, List<ExtensionDescription>> getExtensionMigrationURIS() {
        LinkedHashMap<URI, List<ExtensionDescription>> ret = new LinkedHashMap<URI, List<ExtensionDescription>>();
        IConfigurationElement[] files = Platform.getExtensionRegistry().getConfigurationElementsFor(MODEL_EXTENSION_POINTS);
        URIConverter converter = new ResourceSetImpl().getURIConverter();
        for (IConfigurationElement file : files) {
            String filePath = file.getAttribute(FILEPATH_ATTRIBUTE);
            LinkedHashMap<String, Object> keyValuePairs = new LinkedHashMap<String, Object>();
            String bundleName = file.getContributor().getName();
            String path = bundleName + "/" + filePath;
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            String key = "extension";
            String value = uri.lastSegment();
            keyValuePairs.put(key, value);
            IConfigurationElement[] children = file.getChildren(FILTER_ELEMENT);
            String defaultAtt = file.getAttribute(DEFAULT_ATTRIBUTE);
            key = DEFAULT_ATTRIBUTE;
            value = defaultAtt != null ? defaultAtt : "false";
            keyValuePairs.put(key, value);
            for (IConfigurationElement child : children) {
                String childKey = child.getAttribute(FILTER_KEY_ATTRIBUTE);
                String childValue = child.getAttribute(FILTER_VALUE_ATTRIBUTE);
                keyValuePairs.put(childKey, childValue);
            }
            if (!converter.exists(uri, LOAD_OPTIONS)) {
                LOG.error((Object)String.format("The provided uri '%1$s' doesn't point to an existing file.", uri.toString()));
                continue;
            }
            if (!ret.containsKey(uri)) {
                ret.put(uri, new ArrayList());
            }
            ((List)ret.get(uri)).add(new ExtensionDescription(keyValuePairs, uri));
        }
        return ret;
    }

    public static IConfigurationElement[] getConfigElements(IExtension extension, String element) {
        IConfigurationElement[] configs;
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement c : configs = extension.getConfigurationElements()) {
            if (!c.getName().equals(element)) continue;
            list.add(c);
        }
        return list.toArray(new IConfigurationElement[list.size()]);
    }

    public static IConfigurationElement getConfigElement(IExtension extension, String element) {
        IConfigurationElement[] configs;
        for (IConfigurationElement c : configs = extension.getConfigurationElements()) {
            if (!c.getName().equals(element)) continue;
            return c;
        }
        return null;
    }

    public static String getInstanceAttributes(IExtension extension, IConfigurationElement config) {
        try {
            String attributes = config.getAttribute(ATT_INSTANCE);
            return attributes;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            return null;
        }
    }
}

