package com.st.stellar.model.lib.utils

import com.st.stellar.model.lib.^extension.ExtensionDescription
import com.st.stellar.model.lib.^extension.ModelInstanceExtensionParser
import java.net.URLDecoder
import java.util.ArrayList
import java.util.LinkedHashMap
import java.util.LinkedHashSet
import java.util.List
import java.util.Map
import java.util.Set
import java.util.regex.Pattern
import org.apache.log4j.Logger
import org.eclipse.core.resources.IFile
import org.eclipse.core.resources.IResource
import org.eclipse.core.resources.IResourceProxy
import org.eclipse.core.resources.IResourceProxyVisitor
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.CoreException
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.util.URI
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.resource.ResourceSet
import com.st.stellar.model.lib.ModelMigration

class ModelProvider {
	public static final String ID = "com.st.stellar.model.lib"
	static final Logger LOG = Logger.getLogger(ModelProvider);
	public var static List<URI> LIB_LIST = new ArrayList<URI>();
	public final static Map<String, ModelMigration> MIGRATION_MAP = new LinkedHashMap<String, ModelMigration>();
	public static final String INCLUDES = "includes"

	def static registerLib(URI uri) {
		LOG.info("add " + uri.toString());
		LIB_LIST.add(uri);
	}

	def static registerMigration(String uri, String version, ModelMigration toApply) {
		if( toApply !== null) {
		LOG.info("add migration: URI " + uri + ", version " + version + " " + toApply.toString);
		val key = uri + ":" + version
		MIGRATION_MAP.put(key, toApply)
		} else {
			LOG.error("add migration failed: URI " + uri + ", version " + version + " null");
		}
	}

	def applyMigration(String uri, String from, String to, String path) {
		val key = uri + ":" + to
		val migration = MIGRATION_MAP.get(key)
		if (migration !== null) {
			val oldFile = path
			val newFile = replaceFileExtension(oldFile, "old")
			migration.apply(oldFile, newFile)
		}
	}

	def replaceFileExtension(String filePath, String ext) {
		
		var newExtension = ext
		// Check if the new extension starts with a period, if not, add one.
		if (!newExtension.startsWith(".")) {
			newExtension = "." + newExtension;
		}

		// Find the last period in the file path.
		val lastPeriodIndex = filePath.lastIndexOf(".");

		// If there is no period, or it's the first character (hidden files in Unix-based systems),
		// we assume there's no extension and return the file path with the new extension appended.
		if (lastPeriodIndex <= 0) {
			return filePath + newExtension;
		}

		// Take the substring of the file path up to the last period (exclusive) and append the new extension.
		return filePath.substring(0, lastPeriodIndex) + newExtension;
	}

	static ModelProvider INSTANCE = null

	def static synchronized getInstance() {
		if (INSTANCE === null) {
			INSTANCE = new ModelProvider
			INSTANCE.init()
		}
		INSTANCE
	}

//	static Map<Object, Object> LOAD_OPTIONS = new LinkedHashMap<Object, Object>()
	final Map<String, Map<String, Set<ExtensionDescription>>> MODELS_MAP = new LinkedHashMap<String, Map<String, Set<ExtensionDescription>>>();

	final Map<String, Map<String, Set<ExtensionDescription>>> MIGRATIONS_MAP = new LinkedHashMap<String, Map<String, Set<ExtensionDescription>>>();

	def void init() {
//		LOAD_OPTIONS.put(URIConverter.OPTION_TIMEOUT, 1);
//		LOAD_OPTIONS.put(XMLResource.OPTION_DEFER_ATTACHMENT, Boolean.TRUE);
//		LOAD_OPTIONS.put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION, Boolean.TRUE);
//		LOAD_OPTIONS.put(XMLResource.OPTION_USE_DEPRECATED_METHODS, Boolean.TRUE);
		val extensionURIS = ModelInstanceExtensionParser.getExtensionModelURIS();
		for (uri : extensionURIS.keySet()) {

			println(uri)
			val extensions = extensionURIS.get(uri)
			var pattern = Pattern.compile("^[^\\.]+.([^\\.]+)$")
			for (desc : extensions) {
				var matcher = pattern.matcher(uri.lastSegment)
				if (matcher.find()) {
					var ext = matcher.group(1)
					registerModel(ext, desc as ExtensionDescription);
				}
			}
		}
		ModelInstanceExtensionParser.loadExtension

	}

//
//	def XMIResourceImpl loadResource(URI uri) {
//		val resourceSet = new ResourceSetImpl();
//		val extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//		extensionToFactoryMap.put(Resource.Factory.Registry.DEFAULT_EXTENSION, new XMIResourceFactoryImpl())
//		extensionToFactoryMap.put(Resource.Factory.Registry.DEFAULT_EXTENSION, new XMLResourceFactoryImpl())
//		resourceSet.getLoadOptions().putAll(LOAD_OPTIONS);
//
//		resourceSet.getPackageRegistry().put(ComponentPackage.eNS_URI, ComponentPackage.eINSTANCE)
//
//		var XMIResourceImpl resource = null
//		try {
//			resource = resourceSet.getResource(uri, true) as XMIResourceImpl
//		} catch (WrappedException exception) {
//			LOG.error("Loading component failed.")
//			resource = resourceSet.createResource(uri) as XMIResourceImpl
//		}
//		val urlPath = uri.path
//		LOG.info("loading library " + urlPath)
//		resource.load(resourceSet.getLoadOptions())
//		val obj = resource.contents.get(0)
//		println(obj.toString)
//
//		return resource;
//
//	}
	def void registerModel(String ext, ExtensionDescription extensionDescription) {
		if (!MODELS_MAP.containsKey(ext)) {
			MODELS_MAP.put(ext, new LinkedHashMap<String, Set<ExtensionDescription>>())
		}
		val descriptionMap = MODELS_MAP.get(ext)
		if (!descriptionMap.containsKey(ext)) {
			descriptionMap.put(ext, new LinkedHashSet<ExtensionDescription>());
		}
		descriptionMap.get(ext).add(extensionDescription);
	}

	def loadLib(Class<?> clazz, ResourceSet resourceSet, String ext) {

		synchronized (LIB_LIST) {
			for (str : LIB_LIST) {
				if (str.fileExtension.equals(ext)) {
					val url = clazz.getClassLoader().getResource(str.path)
					val stream = url.openStream
					val resource = resourceSet.createResource(URI.createFileURI(url.path))
					val urlPath = url.path
					LOG.info("loading library " + urlPath)
					resource.load(stream, resourceSet.getLoadOptions())
				}
			}
		}
	}

	def loadLib(ResourceSet resourceSet) {

		synchronized (LIB_LIST) {
			for (str : LIB_LIST) {
				val uri = str
				val resource = resourceSet.createResource(uri)
				val urlPath = uri.path
				LOG.info("loading library " + urlPath)
				resource.load(resourceSet.getLoadOptions())
			}
		}
	}

	def List<ExtensionDescription> getModels(String ext) {
		val models = newArrayList
		val exts = MODELS_MAP.get(ext)
		if (exts !== null) {
			val comps = exts.filter[k, v|k.equals(ext)].entrySet
			for (c : comps) {
//			println("key: "+c.key+", value: "+c.value.toString)
				for (v : c.value) {
					models.add(v)
				}
			}
		}
		models
	}

	def List<ExtensionDescription> getMigrations(String ext) {
		val models = newArrayList
		val exts = MODELS_MAP.get(ext)
		if (exts !== null) {
			val comps = exts.filter[k, v|k.equals(ext)].entrySet
			for (c : comps) {
//			println("key: "+c.key+", value: "+c.value.toString)
				for (v : c.value) {
					models.add(v)
				}
			}
		}
		models
	}

	def static String displayString(URI uri) {
		uri.toString.replaceAll("platform:/plugin/" + ID + "/lib/", "")
	}

	private def IFile getFile(URI uri) {
		return uri.isPlatformResource() && uri.segmentCount() > 2 ? ResourcesPlugin.getWorkspace().getRoot().getFile(
			new Path(uri.toPlatformString(true))) : null;
	}

	def List<URI> getLocalModels(Resource resource, List<String> extensions) {
		val files = newArrayList
		val file = getFile(resource.URI)
		val project = file.project
		val visitor = new ComponentVisitor(files, extensions)
		val handles = newArrayList
		try {
			project.accept(visitor, IResource.NONE)
		} catch (CoreException e) {
			LOG.error(e.message)
			return handles
		}
		val iter = files.iterator()
		while (iter.hasNext()) {
			val f = iter.next() as IFile
			val decodedUri = URLDecoder.decode(f.projectRelativePath.toOSString, "UTF-8");
			val uri = URI.createFileURI(decodedUri)
			handles.add(uri)
		}
		handles
	}

	static class ComponentVisitor implements IResourceProxyVisitor {

		List<IResource> _list
		List<String> _extensions

		new(ArrayList<IResource> list, List<String> extensions) {
			_list = list
			_extensions = extensions
		}

		override visit(IResourceProxy proxy) throws CoreException {

			if (proxy.getType() == IResource.FILE) {
				// println(proxy.name)
				val ext = new Path(proxy.getName()).getFileExtension()
				if (_extensions.contains(ext)) {
					_list.add(proxy.requestResource())
				}
				return false
			}
			return true;
		}

	}

}
