/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ui;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EnvironmentUtils {
    private static Logger logger = Logger.getLogger(EnvironmentUtils.class);
    private static final String PROCESS_ENVIRONMENT = "java.lang.ProcessEnvironment";
    private static final String THE_ENVIRONMENT_FILED = "theEnvironment";
    private static final String THE_CASE_INSENSITIVE_ENVIRONMENT = "theCaseInsensitiveEnvironment";
    private static final String COLLECTIONS_UNMODIFIABLE_MAP = "java.util.Collections$UnmodifiableMap";
    private static final String FIELD_M = "m";

    public static void setEnv(String key, String value) {
        HashMap<String, String> newenv = new HashMap<String, String>();
        newenv.put(key, value);
        EnvironmentUtils.setEnv(newenv);
    }

    public static void setEnv(Map<String, String> newVariables) {
        HashMap<String, String> newenv = new HashMap<String, String>();
        newenv.putAll(System.getenv());
        newenv.putAll(newVariables);
        try {
            Class<?> processEnvironmentClass = Class.forName(PROCESS_ENVIRONMENT);
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField(THE_ENVIRONMENT_FILED);
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newenv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField(THE_CASE_INSENSITIVE_ENVIRONMENT);
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newenv);
        }
        catch (NoSuchFieldException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            Arrays.stream(classes).filter(cl -> COLLECTIONS_UNMODIFIABLE_MAP.equals(cl.getName())).forEach(cl -> {
                try {
                    Field field = cl.getDeclaredField(FIELD_M);
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.putAll(newenv);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    logger.error((Object)"Unable to set environment variable via unmodifiable map", (Throwable)ex);
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            logger.error((Object)"Unable to set environment variable", (Throwable)e);
        }
    }

    public static void removeEnv(String key) {
        try {
            Class<?> processEnvironmentClass = Class.forName(PROCESS_ENVIRONMENT);
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField(THE_ENVIRONMENT_FILED);
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.remove(key);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField(THE_CASE_INSENSITIVE_ENVIRONMENT);
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.remove(key);
        }
        catch (NoSuchFieldException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            Arrays.stream(classes).filter(cl -> COLLECTIONS_UNMODIFIABLE_MAP.equals(cl.getName())).forEach(cl -> {
                try {
                    Field field = cl.getDeclaredField(FIELD_M);
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    logger.error((Object)"Unable to set environment variable via unmodifiable map", (Throwable)ex);
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            logger.error((Object)"Unable to set environment variable", (Throwable)e);
        }
    }
}

