/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ui;

import com.st.stellar.ui.LogUtil;
import com.st.stellar.ws.EclipseProjects;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ImportProjects {
    private List<File> returnedList;

    private List<File> findFilesRecursively(String path, String pattern, List<File> returnedList) {
        File root = new File(path);
        File[] list = root.listFiles();
        if (list == null) {
            return returnedList;
        }
        for (File f : list) {
            if (f.isDirectory()) {
                this.findFilesRecursively(f.getAbsolutePath(), pattern, returnedList);
                continue;
            }
            if (!Pattern.matches(pattern, f.getName())) continue;
            returnedList.add(f);
        }
        return returnedList;
    }

    private List<File> findSdkProjects(String path, String pattern) {
        File root = new File(path);
        File[] list = root.listFiles();
        ArrayList<File> returnedList = new ArrayList<File>();
        if (list == null) {
            return returnedList;
        }
        for (File f : list) {
            if (!f.isDirectory()) continue;
            List<File> sdkProjectLists = this.findSdkNestedProjects(path + File.separator + f.getName(), pattern);
            for (File sdkProjectFile : sdkProjectLists) {
                returnedList.add(sdkProjectFile);
            }
        }
        return returnedList;
    }

    private List<File> findSdkNestedProjects(String path, String pattern) {
        File root = new File(path);
        File[] list = root.listFiles();
        ArrayList<File> sdkProjectList = new ArrayList<File>();
        if (list == null) {
            return sdkProjectList;
        }
        for (File f : list) {
            if (f.isDirectory() || !Pattern.matches(pattern, f.getName())) continue;
            sdkProjectList.add(f);
        }
        return sdkProjectList;
    }

    public void earlyStartup() throws CoreException {
        String eclipseHomeLocation = System.getProperty("eclipse.home.location");
        URI uri = null;
        if (eclipseHomeLocation != null) {
            try {
                uri = URIUtil.fromString((String)eclipseHomeLocation);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String importPath = uri.getPath() + ".." + File.separator + "SDKS";
        LogUtil.info(String.format("Searching for projects in %s", importPath));
        List<File> projectFiles = this.findSdkProjects(importPath, ".project");
        for (File projectFile : projectFiles) {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProjectDescription description = workspace.loadProjectDescription((IPath)new Path(projectFile.toString()));
                IProject project = workspace.getRoot().getProject(description.getName());
                if (!project.exists()) {
                    LogUtil.info(String.format("Create project %s %s", description.getName(), description.getLocationURI()));
                    project.create(description, null);
                    ImportProjects.addProjectToWorkingSet(project, "SDKS");
                }
                if (!project.isOpen()) {
                    LogUtil.info(String.format("Open project %s %s", description.getName(), description.getLocationURI()));
                    project.open(null);
                    continue;
                }
                LogUtil.info(String.format("Refreshing project %s %s", description.getName(), description.getLocationURI()));
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                LogUtil.error(e);
            }
        }
        String importContribPath = uri.getPath() + ".." + File.separator + "contrib";
        LogUtil.info(String.format("Searching for projects in %s", importContribPath));
        List<File> projectContribFiles = this.findFilesRecursively(importContribPath, ".project", new ArrayList<File>());
        for (File projectFile : projectContribFiles) {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProjectDescription description = workspace.loadProjectDescription((IPath)new Path(projectFile.toString()));
                IProject project = workspace.getRoot().getProject(description.getName());
                if (!project.exists()) {
                    LogUtil.info(String.format("Create project %s %s", description.getName(), description.getLocationURI()));
                    project.create(description, null);
                    ImportProjects.addProjectToWorkingSet(project, "CONTRIB");
                }
                if (!project.isOpen()) {
                    LogUtil.info(String.format("Open project %s %s", description.getName(), description.getLocationURI()));
                    project.open(null);
                    continue;
                }
                LogUtil.info(String.format("Refreshing project %s %s", description.getName(), description.getLocationURI()));
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                LogUtil.error(e);
            }
        }
        EclipseProjects.openProjects();
    }

    public static void addProjectToWorkingSet(IProject project, String workingSetName) {
        IAdaptable[] elements;
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.getWorkingSet(workingSetName);
        if (workingSet == null) {
            workingSet = workingSetManager.createWorkingSet(workingSetName, new IAdaptable[0]);
            workingSet.setId("org.eclipse.ui.resourceWorkingSetPage");
            workingSetManager.addWorkingSet(workingSet);
        }
        for (IAdaptable element : elements = workingSet.getElements()) {
            if (!(element instanceof IProject) || !((IProject)element).equals((Object)project)) continue;
            return;
        }
        IAdaptable[] newElements = new IAdaptable[elements.length + 1];
        System.arraycopy(elements, 0, newElements, 0, elements.length);
        newElements[elements.length] = project;
        workingSet.setElements(newElements);
    }
}

