/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ui;

import com.jorisaerts.eclipse.rcp.environment.environment.EnvironmentVariables;
import com.st.stellar.osutils.OsUtils;
import com.st.stellar.ui.LogUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.core.runtime.URIUtil;

public class SetToolsPreferences {
    private static final String PATH_VARIABLE_WINDOWS = "Path";
    private static final String PATH_VARIABLE_LINUX = "PATH";
    private static final String STELLAR_SDK_TOOLCHAIN_PATH = "STELLAR_SDK_TOOLCHAIN_PATH";

    private List<File> findFilesRecursively(String path, String pattern, List<File> returnedList) {
        File root = new File(path);
        File[] list = root.listFiles();
        if (list == null) {
            return returnedList;
        }
        for (File f : list) {
            if (f.isDirectory()) {
                this.findFilesRecursively(f.getAbsolutePath(), pattern, returnedList);
                continue;
            }
            if (!Pattern.matches(pattern, f.getName())) continue;
            returnedList.add(f);
        }
        return returnedList;
    }

    public void earlyStartup() throws ReflectiveOperationException {
        Map<String, String> env = System.getenv();
        String eclipseHomeLocation = System.getProperty("eclipse.home.location");
        URI uri = null;
        if (eclipseHomeLocation != null) {
            try {
                uri = URIUtil.fromString((String)eclipseHomeLocation);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String toolsPath = uri.getPath() + ".." + File.separator + "SDKS";
        String toolchainPath = env.get(STELLAR_SDK_TOOLCHAIN_PATH);
        LogUtil.info(String.format("Searching for tools path in %s", toolsPath));
        if (OsUtils.isWindows()) {
            Object pathTools = env.get(PATH_VARIABLE_WINDOWS);
            List<File> gccFiles = this.findFilesRecursively(toolsPath, "arm-none-eabi-gcc.exe", new ArrayList<File>());
            if (gccFiles.size() > 0) {
                for (File file : gccFiles) {
                    pathTools = file.getParent() + File.pathSeparator + (String)pathTools;
                    LogUtil.info(String.format("Found arm-none-eabi-gcc in %s", file.getParent()));
                }
                if (gccFiles.get(0) != null) {
                    gccFiles.get(0).getParent();
                    if (toolchainPath == null) {
                        toolchainPath = gccFiles.get(0).getParent();
                        EnvironmentVariables.set((String)STELLAR_SDK_TOOLCHAIN_PATH, (String)toolchainPath, (boolean)true);
                        OsUtils.updateEnv((String)STELLAR_SDK_TOOLCHAIN_PATH, (String)toolchainPath);
                        SetToolsPreferences.prependToSystemPath(STELLAR_SDK_TOOLCHAIN_PATH, toolchainPath);
                    }
                }
            }
            List<File> asmMcsFiles = this.findFilesRecursively(toolsPath, "asm-mcs.exe", new ArrayList<File>());
            for (File file : asmMcsFiles) {
                pathTools = file.getParent() + File.pathSeparator + (String)pathTools;
                LogUtil.info(String.format("Found asm-mcs in %s", file.getParent()));
            }
            List<File> list = this.findFilesRecursively(toolsPath, "make.exe", new ArrayList<File>());
            for (File makeFile : list) {
                pathTools = makeFile.getParent() + File.pathSeparator + (String)pathTools;
                LogUtil.info(String.format("Found make in %s", makeFile.getParent()));
            }
            if (pathTools != null) {
                OsUtils.updateEnv((String)PATH_VARIABLE_WINDOWS, (String)pathTools);
                EnvironmentVariables.set((String)PATH_VARIABLE_WINDOWS, (String)pathTools, (boolean)true);
                EnvironmentVariables.set((String)PATH_VARIABLE_LINUX, (String)pathTools, (boolean)true);
                SetToolsPreferences.prependToSystemPath(PATH_VARIABLE_LINUX, (String)pathTools);
            }
        } else {
            Object pathTools = env.get(PATH_VARIABLE_LINUX);
            List<File> gccFiles = this.findFilesRecursively(toolsPath, "arm-none-eabi-gcc", new ArrayList<File>());
            if (gccFiles.size() > 0) {
                for (File file : gccFiles) {
                    pathTools = file.getParent() + File.pathSeparator + (String)pathTools;
                    LogUtil.info(String.format("Found arm-none-eabi-gcc in %s", file.getParent()));
                }
                if (gccFiles.get(0) != null) {
                    gccFiles.get(0).getParent();
                    if (toolchainPath == null) {
                        toolchainPath = gccFiles.get(0).getParent();
                        EnvironmentVariables.set((String)STELLAR_SDK_TOOLCHAIN_PATH, (String)toolchainPath, (boolean)true);
                        OsUtils.updateEnv((String)STELLAR_SDK_TOOLCHAIN_PATH, (String)toolchainPath);
                        SetToolsPreferences.prependToSystemPath(STELLAR_SDK_TOOLCHAIN_PATH, toolchainPath);
                    }
                }
            }
            List<File> asmMcsFiles = this.findFilesRecursively(toolsPath, "asm-mcs", new ArrayList<File>());
            Iterator iterator = asmMcsFiles.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                pathTools = file.getParent() + File.pathSeparator + (String)pathTools;
                LogUtil.info(String.format("Found asm-mcs in %s", file.getParent()));
            }
            List<File> list = this.findFilesRecursively(toolsPath, "make", new ArrayList<File>());
            for (File makeFile : list) {
                pathTools = makeFile.getParent() + File.pathSeparator + (String)pathTools;
                LogUtil.info(String.format("Found make in %s", makeFile.getParent()));
            }
            if (pathTools != null) {
                OsUtils.updateEnv((String)PATH_VARIABLE_LINUX, (String)pathTools);
                EnvironmentVariables.set((String)PATH_VARIABLE_LINUX, (String)pathTools, (boolean)true);
                SetToolsPreferences.prependToSystemPath(PATH_VARIABLE_LINUX, (String)pathTools);
            }
        }
    }

    public static void prependToSystemPath(String name, String value) {
        EnvironmentVariableManager.fUserSupplier.createOverrideVariable(name, value, 3, EnvironmentVariableManager.getDefault().getDefaultDelimiter());
    }
}

