/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.unit.renderer.unitcontrol;

import com.st.stellar.component.renderer.ComponentNumberControlSWTRenderer;
import javax.inject.Inject;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecp.edit.internal.swt.util.PreSetValidationListeners;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationService;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationServiceRunnable;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UnitControlRenderer
extends ComponentNumberControlSWTRenderer {
    private Label unitTxt = null;
    Text text = null;

    @Inject
    public UnitControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport, EMFFormsLocalizationService localizationService, EMFFormsLocaleProvider localeProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport, localizationService, localeProvider);
    }

    protected int getDefaultAlignment() {
        return 131072;
    }

    protected Control createSWTControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)composite);
        this.text = new Text(composite, this.getTextWidgetStyle());
        this.text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        SWTDataElementIdHelper.setElementIdDataForVControl((Widget)this.text, (VControl)((VControl)this.getVElement()), (ViewModelContext)this.getViewModelContext());
        this.text.setMessage(this.getTextMessage());
        this.unitTxt = null;
        try {
            String unit;
            EClassifier type = this.getFeature().getEType();
            EAnnotation annotation = type.getEAnnotation("com.st.stellar.annotation");
            if (annotation != null && (unit = (String)annotation.getDetails().get((Object)"Unit")) != null && !unit.isEmpty()) {
                this.unitTxt = new Label(composite, 16384);
                this.unitTxt.setText(unit + "   ");
            }
        }
        catch (DatabindingFailedException ex) {
            System.err.println(ex.getMessage());
        }
        try {
            PreSetValidationListeners.create((ViewModelContext)this.getViewModelContext()).verify(this.text, this.getFeature(), this.getVElement());
            PreSetValidationListeners.create((ViewModelContext)this.getViewModelContext()).focus(this.text, this.getFeature(), new PreSetValidationServiceRunnable(){

                public void run(PreSetValidationService service) {
                    try {
                        boolean isBoundValueValid;
                        EDataType attributeType = ((EAttribute)UnitControlRenderer.this.getFeature()).getEAttributeType();
                        String textFieldText = UnitControlRenderer.this.getTextFromTextField(UnitControlRenderer.this.text, attributeType);
                        Object convertedValue = UnitControlRenderer.this.convert(UnitControlRenderer.this.text, attributeType, textFieldText);
                        Diagnostic textDiag = service.validate(UnitControlRenderer.this.getFeature(), convertedValue);
                        Diagnostic boundDiag = service.validate(UnitControlRenderer.this.getFeature(), UnitControlRenderer.this.getModelValue().getValue());
                        boolean isEnteredValueValid = textDiag.getSeverity() == 0;
                        boolean bl = isBoundValueValid = boundDiag.getSeverity() == 0;
                        if (UnitControlRenderer.this.getModelValue().getValue() != null && !isEnteredValueValid && isBoundValueValid) {
                            ((VControl)UnitControlRenderer.this.getVElement()).setDiagnostic(null);
                            UnitControlRenderer.this.getDataBindingContext().updateTargets();
                        }
                    }
                    catch (DatabindingFailedException attributeType) {
                    }
                    catch (IllegalArgumentException ex) {
                        ((VControl)UnitControlRenderer.this.getVElement()).setDiagnostic(null);
                        UnitControlRenderer.this.getDataBindingContext().updateTargets();
                        return;
                    }
                }
            }, new Runnable(){

                @Override
                public void run() {
                    UnitControlRenderer.this.text.selectAll();
                }
            });
        }
        catch (DatabindingFailedException ex) {
            // empty catch block
        }
        GridDataFactory gdf = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).span(1, 1);
        EMFFormsEditSupport editSupport = this.getEMFFormsEditSupport();
        if (editSupport.isMultiLine(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel())) {
            gdf.hint(50, 200);
        }
        gdf.applyTo((Control)this.text);
        return composite;
    }

    protected void applyVisible() {
        if (this.unitTxt != null) {
            boolean visible = ((VControl)this.getVElement()).isVisible();
            this.unitTxt.setVisible(visible);
        }
        super.applyVisible();
    }
}

