/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.exceptions;

import com.st.stellar.utils.LogManager;

public class StellarException
extends Exception {
    private int errorId = 0;
    private int severity = 0;
    private static final long serialVersionUID = -7395160504650182821L;

    public StellarException(String string) {
        super(string);
    }

    public StellarException(Exception e) {
        super(e);
    }

    public StellarException(String string, int errorId, int severity) {
        super(string);
        this.errorId = errorId;
        this.severity = severity;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public String getErrorId() {
        return String.format("0x%04X", this.errorId & 0xFFFF);
    }

    public void setErrorId(int errorId) {
        this.errorId = errorId;
    }

    public void log(String message) {
        String messageToLog = message == null ? this.getMessage() : message;
        switch (this.severity) {
            case 4: {
                LogManager.getLogger().logError(messageToLog);
                break;
            }
            case 2: {
                LogManager.getLogger().logWarning(messageToLog);
                break;
            }
            case 1: {
                LogManager.getLogger().logInfo(messageToLog);
                break;
            }
        }
    }
}

