/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.utils;

import com.st.stellar.Activator;
import com.st.stellar.Messages;
import com.st.stellar.preferences.IPreferenceConstants;
import com.st.stellar.utils.Utils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class LogManager {
    private static volatile LogManager logger = null;
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private MessageConsoleStream out;
    private MessageConsoleStream err;
    private MessageConsoleStream warn;
    private boolean hide;

    protected LogManager() {
        final MessageConsole console = Utils.findConsole(Utils.CONSOLE_NAME);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Utils.activateConsole(console);
                LogManager.this.out = console.newMessageStream();
                LogManager.this.out.setColor(Utils.DEFAULT_OUTPUT);
                LogManager.this.err = console.newMessageStream();
                LogManager.this.err.setColor(Utils.DEFAULT_ERROR);
                LogManager.this.warn = console.newMessageStream();
                LogManager.this.warn.setColor(Utils.DEFAULT_WARNING);
            }
        });
    }

    private void log(int severity, int code, String message, Throwable throwable) {
        if (!this.hide) {
            Activator.getDefault().getLog().log(this.createStatus(severity, code, message, throwable));
            switch (severity) {
                case 1: {
                    this.out.println(message);
                    break;
                }
                case 4: {
                    this.err.println(Messages.LogManager_0 + message);
                    if (throwable == null) break;
                    throwable.printStackTrace();
                    break;
                }
                case 2: {
                    this.warn.println(Messages.LogManager_1 + message);
                }
            }
            MessageConsole console = Utils.findConsole(Utils.CONSOLE_NAME);
            Utils.activateConsole(console);
        }
    }

    private IStatus createStatus(int severity, int code, String message, Throwable throwable) {
        return new Status(severity, "com.st.tools.spc5", code, message, throwable);
    }

    public static LogManager getLogger() {
        if (logger == null) {
            logger = new LogManager();
        }
        return logger;
    }

    public void logInfo(String message) {
        String level = this.store.getString("logLevelPref");
        if (level.equals(IPreferenceConstants.LOGLEVEL_INFO)) {
            this.log(1, 0, message, null);
        }
    }

    public void logError(Throwable throwable) {
        String message = throwable.getMessage();
        if (message != null) {
            this.log(4, 0, message, throwable);
        } else {
            this.log(4, 0, Messages.LogManager_2, throwable);
        }
    }

    public void logError(String message, Throwable throwable) {
        this.log(4, 0, message, throwable);
    }

    public void logError(String message) {
        this.log(4, 0, message, null);
    }

    public void logWarning(String message) {
        String level = this.store.getString("logLevelPref");
        if (level.equals(IPreferenceConstants.LOGLEVEL_INFO) || level.equals(IPreferenceConstants.LOGLEVEL_WARNING)) {
            this.log(2, 0, message, null);
        }
    }

    public void hide() {
        this.hide = true;
    }

    public void show() {
        this.hide = false;
    }
}

