/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.osutils;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;

public class OsUtils {
    private static String OS = null;
    private static String arch = null;

    public static String getOsName() {
        if (OS == null) {
            OS = System.getProperty("os.name");
        }
        return OS;
    }

    public static String getArch() {
        if (arch == null) {
            arch = System.getProperty("os.arch");
        }
        return arch;
    }

    public static boolean isWindows() {
        return OsUtils.getOsName().startsWith("Windows");
    }

    public static boolean isLinux() {
        return OsUtils.getOsName().startsWith("Linux");
    }

    public static boolean isMac() {
        return OsUtils.getOsName().startsWith("Mac");
    }

    public static boolean is64() {
        return OsUtils.getArch().startsWith("x86_64") || OsUtils.getArch().startsWith("amd64");
    }

    public static void updateEnv(String name, String val) throws ReflectiveOperationException {
        Map<String, String> env = System.getenv();
        Field field = env.getClass().getDeclaredField("m");
        field.setAccessible(true);
        ((Map)field.get(env)).put(name, val);
    }

    public static void setEnv(Map<String, String> newenv) throws Exception {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newenv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newenv);
        }
        catch (NoSuchFieldException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            for (Class<?> cl : classes) {
                if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                Field field = cl.getDeclaredField("m");
                field.setAccessible(true);
                Object obj = field.get(env);
                Map map = (Map)obj;
                map.clear();
                map.putAll(newenv);
            }
        }
    }
}

