/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.utils;

import com.st.stellar.Messages;
import com.st.stellar.utils.LogManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;

public class Utils {
    public static final String CONSOLE_NAME = Messages.TemplateEngine_0;
    public static final Color DEFAULT_MESSAGE = new Color((Device)Display.getDefault(), new RGB(0, 0, 255));
    public static final Color DEFAULT_OUTPUT = new Color((Device)Display.getDefault(), new RGB(0, 0, 0));
    public static final Color DEFAULT_WARNING = new Color((Device)Display.getDefault(), new RGB(255, 100, 0));
    public static final Color DEFAULT_ERROR = new Color((Device)Display.getDefault(), new RGB(255, 0, 0));
    public static final Color DEFAULT_PATCH = new Color((Device)Display.getDefault(), new RGB(0, 100, 0));
    private static final String TAG_ROOT = "root";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_FACTORY_ID = "factoryID";

    public static void setReadonly(IFolder folder) {
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFolder) {
                        return true;
                    }
                    ResourceAttributes attrs = resource.getResourceAttributes();
                    attrs.setReadOnly(true);
                    resource.setResourceAttributes(attrs);
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copydir(File srcPath, IContainer destFolder) {
        File[] files = srcPath.listFiles();
        LogManager.getLogger().logInfo("copy " + String.valueOf(srcPath) + " to " + destFolder.getName());
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    IFolder newFolder = destFolder.getFolder((IPath)new Path(f.getName()));
                    if (!newFolder.exists()) {
                        try {
                            newFolder.create(true, true, null);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        Utils.setReadonly(newFolder);
                    }
                    Utils.copydir(f, (IContainer)newFolder);
                    continue;
                }
                IFile newFile = destFolder.getFile((IPath)new Path(f.getName()));
                try {
                    if (FileUtils.contentEquals((File)f, (File)newFile.getLocation().toFile())) continue;
                    try (FileInputStream input = new FileInputStream(f);){
                        if (newFile.exists()) {
                            LogManager.getLogger().logInfo(newFile.getLocation().toFile().getName() + " already exists!");
                            newFile.setContents((InputStream)input, true, false, null);
                            continue;
                        }
                        newFile.create((InputStream)input, true, null);
                    }
                }
                catch (IOException | CoreException e) {
                    LogManager.getLogger().logError(e.getMessage());
                }
            }
        }
    }

    public static void findandreplace(IProject project, String filePath, String oldPattern, String newPattern) throws IOException, CoreException {
        IFile file = project.getFile(filePath);
        Charset charset = StandardCharsets.UTF_8;
        InputStream inputStream = file.getContents();
        String content = new String(inputStream.readAllBytes(), charset);
        content = content.replaceAll(oldPattern, newPattern);
        ByteArrayInputStream newInputStream = new ByteArrayInputStream(content.getBytes(charset));
        file.setContents((InputStream)newInputStream, 1, (IProgressMonitor)new NullProgressMonitor());
        inputStream.close();
        ((InputStream)newInputStream).reset();
    }

    public static void moveFile(IProject project, String sourcePath, String destinationPath) throws CoreException {
        IFile sourceFile = project.getFile(sourcePath);
        Path destinationIPath = new Path("/" + project.getName() + "/" + destinationPath);
        sourceFile.move((IPath)destinationIPath, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static String normalizeSlashes(String source) {
        return source != null ? source.replace("\\", "/") : null;
    }

    public static Properties getPropertiesFromBundleFile(String bundle, String bundlefile) throws IOException {
        URL entry = Platform.getBundle((String)bundle).getEntry(bundlefile);
        File file = new File(FileLocator.toFileURL((URL)entry).getPath());
        FileInputStream fileInput = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(fileInput);
        fileInput.close();
        return properties;
    }

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        for (int i = 0; i < existing.length; ++i) {
            if (!name.equals(existing[i].getName())) continue;
            return (MessageConsole)existing[i];
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static void activateConsole(MessageConsole console) {
        IWorkbenchPage page = null;
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        }
        catch (Exception e) {
            LogManager.getLogger().logError(e);
            return;
        }
        try {
            IConsoleView view;
            if (page != null && (view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView", null, 2)) != null) {
                view.display((IConsole)console);
            }
        }
        catch (PartInitException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void showConsole() {
        MessageConsole console = Utils.findConsole(CONSOLE_NAME);
        IWorkbenchPage page = null;
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        }
        catch (Exception e) {
            LogManager.getLogger().logError(e);
            return;
        }
        try {
            IConsoleView view;
            if (page != null && (view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView", null, 1)) != null) {
                view.display((IConsole)console);
            }
        }
        catch (PartInitException e) {
            LogManager.getLogger().logError(e);
        }
    }

    public static XMLMemento saveWorkingSetsState(IWorkingSet[] iWorkingSets) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_ROOT);
        IWorkingSet[] iWorkingSetArray = iWorkingSets;
        int n = iWorkingSetArray.length;
        for (int i = 0; i < n; ++i) {
            IWorkingSet set;
            IWorkingSet persistable = set = iWorkingSetArray[i];
            SafeRunner.run((ISafeRunnable)new WorkingSetRunnable((IPersistableElement)persistable, memento){
                final /* synthetic */ IPersistableElement val$persistable;
                final /* synthetic */ XMLMemento val$memento;
                {
                    this.val$persistable = iPersistableElement;
                    this.val$memento = xMLMemento;
                }

                public void run() throws Exception {
                    XMLMemento dummy = XMLMemento.createWriteRoot((String)Utils.TAG_WORKING_SET);
                    dummy.putString(Utils.TAG_FACTORY_ID, this.val$persistable.getFactoryId());
                    this.val$persistable.saveState((IMemento)dummy);
                    IMemento workingSetMemento = this.val$memento.createChild(Utils.TAG_WORKING_SET);
                    workingSetMemento.putMemento((IMemento)dummy);
                }
            });
        }
        return memento;
    }

    public static int countParentDirs(String str) {
        int count = 0;
        int index = str.indexOf("../");
        while (index != -1) {
            ++count;
            index = str.indexOf("../", index + 3);
        }
        return count;
    }

    public static void closeAllTerminalViews() {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        for (int w = 0; w < windows.length; ++w) {
            IWorkbenchPage[] pages = windows[w].getPages();
            for (int p = 0; p < pages.length; ++p) {
                IViewReference[] viewReferences;
                IWorkbenchPage page = pages[p];
                for (IViewReference ivr : viewReferences = page.getViewReferences()) {
                    if (!ivr.getId().startsWith("org.eclipse.tm.terminal.view.ui")) continue;
                    page.hideView(ivr);
                }
            }
        }
    }

    static abstract class WorkingSetRunnable
    implements ISafeRunnable {
        WorkingSetRunnable() {
        }

        public void handleException(Throwable exception) {
            LogManager.getLogger().logError(exception.getMessage());
        }
    }
}

