/*
 * Decompiled with CFR 0.152.
 */
package com.jorisaerts.eclipse.rcp.environment.eclipse.debug.internal;

import com.jorisaerts.eclipse.rcp.environment.util.SWTUtils;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class AbstractDebugSelectionDialog
extends SelectionDialog {
    protected StructuredViewer fViewer = null;

    public AbstractDebugSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setDialogBoundsSettings(this.getDialogBoundsSettings(), 2);
    }

    protected abstract String getDialogSettingsId();

    protected abstract Object getViewerInput();

    protected abstract StructuredViewer createViewer(Composite var1);

    protected abstract boolean isValid();

    protected IContentProvider getContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new IBaseLabelProvider(this){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    protected abstract String getHelpContextId();

    protected void addViewerListeners(StructuredViewer viewer) {
    }

    protected void addCustomHeaderControls(Composite parent) {
    }

    protected void addCustomFooterControls(Composite parent) {
    }

    protected void initializeControls() {
        this.getButton(0).setEnabled(this.isValid());
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        this.initializeControls();
        return comp;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = (Composite)super.createDialogArea(parent);
        this.addCustomHeaderControls(comp);
        String label = this.getMessage();
        if (label != null && !"".equals(label)) {
            SWTUtils.createWrapLabel(comp, label, 1);
        }
        if ((label = this.getViewerLabel()) != null && !"".equals(label)) {
            SWTUtils.createLabel(comp, label, 1);
        }
        this.fViewer = this.createViewer(comp);
        this.fViewer.setLabelProvider(this.getLabelProvider());
        this.fViewer.setContentProvider(this.getContentProvider());
        this.fViewer.setInput(this.getViewerInput());
        List selectedElements = this.getInitialElementSelections();
        if (selectedElements != null && !selectedElements.isEmpty()) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(selectedElements));
        }
        this.addViewerListeners(this.fViewer);
        this.addCustomFooterControls(comp);
        Dialog.applyDialogFont((Control)comp);
        String help = this.getHelpContextId();
        if (help != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, help);
        }
        return comp;
    }

    protected abstract String getViewerLabel();
}

