/*
 * Decompiled with CFR 0.152.
 */
package com.jorisaerts.eclipse.rcp.environment.environment.internal;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Environment {
    private static POSIX libc = new POSIX();

    public static int remove(String name) {
        Map<String, String> map = Environment.getEnvironmentVariables();
        map.remove(name);
        Map<String, String> env2 = Environment.getwinenv();
        env2.remove(name);
        return libc.unsetenv(name);
    }

    public static int set(String name, String value, boolean overwrite) {
        if (name.lastIndexOf("=") != -1) {
            throw new IllegalArgumentException("Environment variable cannot contain '='");
        }
        Map<String, String> map = Environment.getEnvironmentVariables();
        boolean contains = map.containsKey(name);
        if (!contains || overwrite) {
            map.put(name, value);
            Map<String, String> env2 = Environment.getwinenv();
            env2.put(name, value);
        }
        return libc.setenv(name, value, overwrite ? 1 : 0);
    }

    static Map<String, String> getwinenv() {
        try {
            Class<?> sc = Class.forName("java.lang.ProcessEnvironment");
            Field caseinsensitive = sc.getDeclaredField("theCaseInsensitiveEnvironment");
            caseinsensitive.setAccessible(true);
            return (Map)caseinsensitive.get(null);
        }
        catch (Exception exception) {
            return new HashMap<String, String>();
        }
    }

    static Map<String, String> getEnvironmentVariables() {
        try {
            Map<String, String> theUnmodifiableEnvironment = System.getenv();
            ConcurrentHashMap<String, String> vars = new ConcurrentHashMap<String, String>();
            vars.putAll(theUnmodifiableEnvironment);
            return vars;
        }
        catch (Exception exception) {
            return new HashMap<String, String>();
        }
    }

    private static class POSIX {
        static Object libc;

        private POSIX() {
        }

        public int setenv(String name, String value, int overwrite) {
            if (libc instanceof LinuxLibC) {
                return ((LinuxLibC)libc).setenv(name, value, overwrite);
            }
            return ((WinLibC)libc)._putenv(name + "=" + value);
        }

        public int unsetenv(String name) {
            if (libc instanceof LinuxLibC) {
                return ((LinuxLibC)libc).unsetenv(name);
            }
            return ((WinLibC)libc)._putenv(name + "=");
        }

        static {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("win") >= 0) {
                libc = Native.load((String)"msvcrt", WinLibC.class);
            } else if (os.indexOf("mac") >= 0) {
                libc = Native.load((String)"c", LinuxLibC.class);
            } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0) {
                libc = Native.load((String)"c", LinuxLibC.class);
            } else {
                throw new RuntimeException("Unsupported OS.");
            }
        }
    }

    private static interface LinuxLibC
    extends Library {
        public int setenv(String var1, String var2, int var3);

        public int unsetenv(String var1);
    }

    private static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

