/*
 * Decompiled with CFR 0.152.
 */
package com.jorisaerts.eclipse.rcp.environment.preferences;

import com.jorisaerts.eclipse.rcp.environment.Activator;
import com.jorisaerts.eclipse.rcp.environment.table.EnvironmentVariablesTable;
import com.jorisaerts.eclipse.rcp.environment.util.EnvironmentVariableCollection;
import com.jorisaerts.eclipse.rcp.environment.util.EnvironmentVariablesUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EnvironmentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final EnvironmentVariableCollection vars;
    private EnvironmentVariablesTable table;

    public EnvironmentPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Environment variables to &set:");
        this.vars = EnvironmentVariablesUtil.getEnvironmentVariables(this.getPreferenceStore());
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        SashForm composite = new SashForm(parent, 512);
        composite.setFont(font);
        GridData sashData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)sashData);
        this.table = new EnvironmentVariablesTable((Composite)composite);
        this.table.setVariables(this.vars);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        this.table.clear();
        super.performDefaults();
    }

    public boolean performOk() {
        EnvironmentVariableCollection vars = this.table.getEnvironmentVariables();
        EnvironmentVariablesUtil.setEnvironmentVariables(this.getPreferenceStore(), vars);
        return super.performOk();
    }
}

