/*
 * Decompiled with CFR 0.152.
 */
package com.jorisaerts.eclipse.rcp.environment.preferences;

import com.jorisaerts.eclipse.rcp.environment.eclipse.debug.internal.AbstractDebugCheckboxSelectionDialog;
import com.jorisaerts.eclipse.rcp.environment.util.EnvironmentVariable;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class NativeEnvironmentSelectionDialog
extends AbstractDebugCheckboxSelectionDialog {
    private final Object fInput;

    public NativeEnvironmentSelectionDialog(Shell parentShell, Object input) {
        super(parentShell);
        this.fInput = input;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setShowSelectAllButtons(true);
    }

    @Override
    protected String getDialogSettingsId() {
        return "org.eclipse.debug.ui.ENVIRONMENT_TAB.NATIVE_ENVIROMENT_DIALOG";
    }

    @Override
    protected String getHelpContextId() {
        return null;
    }

    @Override
    protected Object getViewerInput() {
        return this.fInput;
    }

    @Override
    protected String getViewerLabel() {
        return "Select &environment variables to add:";
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new ILabelProvider(this){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                return MessageFormat.format("{0} [ {1} ]", var.getName(), var.getValue());
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(this){

            public Object[] getElements(Object inputElement) {
                EnvironmentVariable[] elements = null;
                if (inputElement instanceof HashMap) {
                    Comparator comparator = (o1, o2) -> {
                        String s1 = (String)o1;
                        String s2 = (String)o2;
                        return s1.compareTo(s2);
                    };
                    TreeMap envVars = new TreeMap(comparator);
                    envVars.putAll((Map)inputElement);
                    elements = new EnvironmentVariable[envVars.size()];
                    int index = 0;
                    for (Object key : envVars.keySet()) {
                        elements[index] = (EnvironmentVariable)envVars.get(key);
                        ++index;
                    }
                }
                return elements;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }
}

