/*
 * Decompiled with CFR 0.152.
 */
package com.jorisaerts.eclipse.rcp.environment.table;

import com.jorisaerts.eclipse.rcp.environment.eclipse.debug.internal.MultipleInputDialog;
import com.jorisaerts.eclipse.rcp.environment.eclipse.debug.internal.TextGetSetEditingSupport;
import com.jorisaerts.eclipse.rcp.environment.preferences.NativeEnvironmentSelectionDialog;
import com.jorisaerts.eclipse.rcp.environment.table.TableButtons;
import com.jorisaerts.eclipse.rcp.environment.table.TableCellModifier;
import com.jorisaerts.eclipse.rcp.environment.table.TableContentProvider;
import com.jorisaerts.eclipse.rcp.environment.table.TableLabelProvider;
import com.jorisaerts.eclipse.rcp.environment.util.EnvironmentVariable;
import com.jorisaerts.eclipse.rcp.environment.util.EnvironmentVariableCollection;
import com.jorisaerts.eclipse.rcp.environment.util.EnvironmentVariablesUtil;
import com.jorisaerts.eclipse.rcp.environment.util.SWTUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class EnvironmentVariablesTable
extends Composite {
    private EnvironmentVariableCollection vars;
    private final Table table;
    private final TableViewer viewer;
    private final TableLabelProvider labelProvider;
    private final TableButtons buttons;
    private final Menu menu;
    protected static final String P_VARIABLE = "variable";
    protected static final String P_VALUE = "value";

    public EnvironmentVariablesTable(Composite parent) {
        super(parent, 0);
        Font font = parent.getFont();
        this.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Composite tableCompo = new Composite((Composite)this, 0);
        GridData data = new GridData(1808);
        tableCompo.setLayoutData((Object)data);
        GridLayout compoLayout = new GridLayout();
        compoLayout.marginHeight = 0;
        compoLayout.marginWidth = 0;
        tableCompo.setLayout((Layout)compoLayout);
        this.labelProvider = new TableLabelProvider();
        this.viewer = new TableViewer(tableCompo, 68354);
        this.viewer.setColumnProperties(new String[]{P_VARIABLE, P_VALUE});
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        try {
            this.viewer.setContentProvider((IContentProvider)new TableContentProvider(this.vars));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.table = this.viewer.getTable();
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(font);
        this.buttons = new TableButtons(this, this.vars);
        this.menu = new Menu((Control)this.table);
        this.table.setMenu(this.menu);
        this.addMenuAndButton("&Add...", true, true, this::handleAdd);
        this.addMenuAndButton("Se&lect...", true, false, this::handleSelect);
        List<Widget> singleWidgets = this.addMenuAndButton("E&dit...", false, false, this::handleEdit);
        List<Widget> removeWidgets = this.addMenuAndButton("Rem&ove", false, true, this::handleRemove);
        List<Widget> copyWidgets = this.addMenuAndButton("&Copy", false, true, this::handleCopy);
        this.addMenuAndButton("&Paste", true, true, this::handlePaste);
        this.viewer.addSelectionChangedListener(event -> {
            int size = event.getStructuredSelection().size();
            singleWidgets.forEach(e -> EnvironmentVariablesTable.setEnabled(e, size == 1));
            removeWidgets.forEach(e -> EnvironmentVariablesTable.setEnabled(e, size > 0));
            copyWidgets.forEach(e -> EnvironmentVariablesTable.setEnabled(e, size > 0));
        });
        this.table.addListener(35, event -> {
            boolean enabled = this.table.getSelectionCount() > 0;
            Stream.of(removeWidgets, copyWidgets).flatMap(Collection::stream).filter(MenuItem.class::isInstance).forEach(m -> EnvironmentVariablesTable.setEnabled(m, enabled));
        });
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy(this, (ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 4;
            }
        };
        int feature = 178;
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)178);
        TableViewerColumn columnViewer1 = new TableViewerColumn(this.viewer, 0, 0);
        columnViewer1.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> ((EnvironmentVariable)element).getName()));
        TableColumn column1 = columnViewer1.getColumn();
        column1.setText("Variable");
        columnViewer1.setEditingSupport(new TextGetSetEditingSupport<EnvironmentVariable>(columnViewer1.getViewer(), EnvironmentVariable::getName, (envVar, value) -> {
            String newName = value.trim();
            if (newName != null && !newName.isEmpty() && !newName.equals(envVar.getName()) && this.canRenameVariable(newName)) {
                envVar.setName(newName);
                this.redrawTable();
            }
        }));
        TableViewerColumn columnViewer2 = new TableViewerColumn(this.viewer, 0, 1);
        columnViewer2.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> ((EnvironmentVariable)element).getValue()));
        TableColumn column2 = columnViewer2.getColumn();
        column2.setText("Value");
        columnViewer2.setEditingSupport(new TextGetSetEditingSupport<EnvironmentVariable>(columnViewer2.getViewer(), EnvironmentVariable::getValue, (envVar, value) -> {
            envVar.setValue((String)value);
            this.redrawTable();
        }));
        TableColumnLayout tableColumnLayout = new TableColumnLayout(true);
        PixelConverter pixelConverter = new PixelConverter(font);
        tableColumnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(1, pixelConverter.convertWidthInCharsToPixels(20)));
        tableColumnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(2, pixelConverter.convertWidthInCharsToPixels(20)));
        tableCompo.setLayout((Layout)tableColumnLayout);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.table), new TextCellEditor((Composite)this.table)};
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier((ICellModifier)new TableCellModifier(this.viewer));
    }

    private static void setEnabled(Widget widget, boolean enabled) {
        if (widget instanceof MenuItem) {
            ((MenuItem)widget).setEnabled(enabled);
        } else if (widget instanceof Control) {
            ((Control)widget).setEnabled(enabled);
        }
    }

    public void redrawTable() {
        this.viewer.getControl().setRedraw(true);
        this.viewer.getControl().redraw();
    }

    private List<Widget> addMenuAndButton(String name, boolean enabled, boolean addToMenu, final Runnable runnable) {
        SelectionAdapter adapter = new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent event) {
                runnable.run();
            }
        };
        ArrayList<Widget> result = new ArrayList<Widget>();
        if (addToMenu) {
            MenuItem item = new MenuItem(this.menu, 0);
            item.setText(name);
            item.addSelectionListener((SelectionListener)adapter);
            item.setEnabled(enabled);
            result.add((Widget)item);
        }
        Button button = SWTUtils.createPushButton(this.buttons, name, null);
        button.addSelectionListener((SelectionListener)adapter);
        button.setEnabled(enabled);
        result.add((Widget)button);
        return result;
    }

    public void setVariables(EnvironmentVariableCollection vars) {
        this.vars = vars;
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider(vars));
        this.refresh();
    }

    private boolean canRenameVariable(String newVariableName) {
        for (TableItem item : this.viewer.getTable().getItems()) {
            EnvironmentVariable existingVariable = (EnvironmentVariable)item.getData();
            if (!existingVariable.getName().equals(newVariableName)) continue;
            boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Overwrite variable?", (String)MessageFormat.format("A variable named {0} already exists. Overwrite?", newVariableName));
            if (!overWrite) {
                return false;
            }
            this.viewer.remove((Object)existingVariable);
            return true;
        }
        return true;
    }

    private void handleAdd() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), "New Environment Variable");
        dialog.addTextField("&Name:", null, false);
        dialog.addVariablesField("&Value:", null, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue("&Name:");
        String value = dialog.getStringValue("&Value:");
        if (name != null && value != null && name.length() > 0) {
            this.addVariable(new EnvironmentVariable(name.trim(), value));
        }
    }

    private void handleSelect() {
        TableItem[] items;
        Map<String, EnvironmentVariable> envVariables = EnvironmentVariablesUtil.getNativeEnvironment();
        for (TableItem item : items = this.viewer.getTable().getItems()) {
            EnvironmentVariable var = (EnvironmentVariable)item.getData();
            envVariables.remove(var.getName());
        }
        NativeEnvironmentSelectionDialog dialog = new NativeEnvironmentSelectionDialog(this.getShell(), envVariables);
        dialog.setTitle("Select Environment Variables");
        int button = dialog.open();
        if (button == 0) {
            Object[] selected;
            for (Object o : selected = dialog.getResult()) {
                this.viewer.add(o);
            }
        }
        this.redrawTable();
    }

    private void handleEdit() {
        IStructuredSelection sel = this.viewer.getStructuredSelection();
        EnvironmentVariable var = (EnvironmentVariable)sel.getFirstElement();
        if (var == null) {
            return;
        }
        String originalName = var.getName();
        String value = var.getValue();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), "Edit Environment Variable");
        dialog.addTextField("&Name:", originalName, false);
        if (value != null && value.contains(System.lineSeparator())) {
            dialog.addMultilinedVariablesField("&Value:", value, true);
        } else {
            dialog.addVariablesField("&Value:", value, true);
        }
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue("&Name:");
        value = dialog.getStringValue("&Value:");
        if (!originalName.equals(name)) {
            if (this.addVariable(new EnvironmentVariable(name.trim(), value))) {
                this.viewer.remove((Object)var);
            }
        } else {
            var.setValue(value);
            this.viewer.update((Object)var, null);
            this.redrawTable();
        }
    }

    private void handleRemove() {
        IStructuredSelection sel = this.viewer.getStructuredSelection();
        try {
            this.viewer.getControl().setRedraw(false);
            Iterator it = sel.iterator();
            it.forEachRemaining(arg_0 -> ((TableViewer)this.viewer).remove(arg_0));
        }
        finally {
            this.redrawTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCopy() {
        Iterable iterable = () -> this.viewer.getStructuredSelection().iterator();
        String data = StreamSupport.stream(iterable.spliterator(), false).filter(o -> o instanceof EnvironmentVariable).map(EnvironmentVariable.class::cast).map(var -> String.format("%s=%s", var.getName(), var.getValue())).collect(Collectors.joining(System.lineSeparator()));
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    private void handlePaste() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            List<EnvironmentVariable> variables = EnvironmentVariablesTable.convertEnvironmentVariablesFromData(clipboard.getContents((Transfer)TextTransfer.getInstance()));
            this.addVariables(variables);
        }
        finally {
            clipboard.dispose();
        }
    }

    private static List<EnvironmentVariable> convertEnvironmentVariablesFromData(Object data) {
        if (!(data instanceof String)) {
            return Collections.emptyList();
        }
        String[] entries = ((String)data).split("\\R");
        ArrayList<EnvironmentVariable> result = new ArrayList<EnvironmentVariable>(entries.length);
        for (String entry : entries) {
            int idx = entry.indexOf(61);
            if (idx < 1) continue;
            String name = entry.substring(0, idx).trim();
            String value = entry.substring(idx + 1);
            result.add(new EnvironmentVariable(name, value));
        }
        return Collections.unmodifiableList(result);
    }

    protected boolean addVariable(EnvironmentVariable variable) {
        TableItem[] items;
        String name = variable.getName();
        for (TableItem item : items = this.table.getItems()) {
            EnvironmentVariable existingVariable = (EnvironmentVariable)item.getData();
            if (!existingVariable.getName().equals(name)) continue;
            boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Overwrite variable?", (String)MessageFormat.format("A variable named {0} already exists. Overwrite?", name));
            if (!overWrite) {
                return false;
            }
            this.viewer.remove((Object)existingVariable);
            break;
        }
        this.viewer.add((Object)variable);
        return true;
    }

    protected int addVariables(List<EnvironmentVariable> variables) {
        if (variables.isEmpty()) {
            return 0;
        }
        LinkedList<EnvironmentVariable> remove = new LinkedList<EnvironmentVariable>();
        LinkedList<EnvironmentVariable> conflicting = new LinkedList<EnvironmentVariable>();
        Map<String, String> requested = variables.stream().collect(Collectors.toMap(EnvironmentVariable::getName, EnvironmentVariable::getValue));
        for (TableItem item : this.viewer.getTable().getItems()) {
            EnvironmentVariable existingVariable = (EnvironmentVariable)item.getData();
            String name = existingVariable.getName();
            String currentValue = requested.get(name);
            if (currentValue == null) continue;
            remove.add(existingVariable);
            if (currentValue.equals(existingVariable.getValue())) continue;
            conflicting.add(existingVariable);
        }
        if (!conflicting.isEmpty()) {
            String names = conflicting.stream().map(EnvironmentVariable::getName).collect(Collectors.joining(", "));
            boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Overwrite variables?", (String)MessageFormat.format("Pasting will overwrite the following variables: {0}", names));
            if (!overWrite) {
                return 0;
            }
        }
        remove.forEach(arg_0 -> ((TableViewer)this.viewer).remove(arg_0));
        variables.forEach(arg_0 -> ((TableViewer)this.viewer).add(arg_0));
        this.redrawTable();
        return variables.size();
    }

    public EnvironmentVariableCollection getEnvironmentVariables() {
        return Stream.of(this.table.getItems()).map(Widget::getData).map(EnvironmentVariable.class::cast).collect(Collectors.toCollection(EnvironmentVariableCollection::new));
    }

    public void clear() {
        this.viewer.getControl().setRedraw(false);
        this.viewer.setItemCount(0);
        this.viewer.getControl().setRedraw(true);
        this.viewer.getControl().redraw();
    }

    public void refresh() {
        this.viewer.setInput(new Object());
    }
}

