/*
 * Decompiled with CFR 0.152.
 */
package com.jorisaerts.eclipse.rcp.environment.table;

import com.jorisaerts.eclipse.rcp.environment.util.EnvironmentVariable;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

class TableCellModifier
implements ICellModifier {
    private final TableViewer tableViewer;
    private final String keyProperty;
    private final String valueProperty;

    public TableCellModifier(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.keyProperty = (String)tableViewer.getColumnProperties()[0];
        this.valueProperty = (String)tableViewer.getColumnProperties()[1];
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        EnvironmentVariable entry = (EnvironmentVariable)element;
        if (property.equals(this.keyProperty)) {
            return entry.getName();
        }
        if (property.equals(this.valueProperty)) {
            return entry.getValue();
        }
        return element.toString();
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        EnvironmentVariable variable = (EnvironmentVariable)item.getData();
        if (property.equals(this.keyProperty)) {
            variable.setName((String)value);
        } else if (property.equals(this.valueProperty)) {
            variable.setValue((String)value);
        }
        this.tableViewer.update(new Object[]{variable}, new String[]{property});
        this.tableViewer.refresh((Object)variable);
    }
}

