/*
 * Decompiled with CFR 0.152.
 */
package com.jorisaerts.eclipse.rcp.environment.util;

import com.jorisaerts.eclipse.rcp.environment.environment.EnvironmentVariables;
import com.jorisaerts.eclipse.rcp.environment.util.EnvironmentVariable;
import com.jorisaerts.eclipse.rcp.environment.util.EnvironmentVariableCollection;
import com.jorisaerts.eclipse.rcp.environment.util.SerializerUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class EnvironmentVariablesUtil {
    public static void applyVariables(IPreferenceStore store, boolean replace) {
        EnvironmentVariableCollection vars = EnvironmentVariablesUtil.getEnvironmentVariables(store);
        for (EnvironmentVariable entry : vars) {
            EnvironmentVariables.set(entry.getName(), entry.getValue(), replace);
        }
    }

    public static void setVariable(IPreferenceStore store, EnvironmentVariable newVariable, boolean replace) {
        EnvironmentVariableCollection vars = EnvironmentVariablesUtil.getEnvironmentVariables(store);
        for (EnvironmentVariable entry : vars) {
            if (!newVariable.getName().equals(entry.getName())) continue;
            EnvironmentVariables.set(entry.getName(), newVariable.getValue(), replace);
        }
    }

    public static void clearOldVariables(IPreferenceStore store) {
        EnvironmentVariableCollection oldVars = EnvironmentVariablesUtil.getEnvironmentVariables(store);
        for (EnvironmentVariable entry : oldVars) {
            EnvironmentVariables.remove(entry.getName());
        }
    }

    public static void reset(IPreferenceStore store) {
        EnvironmentVariablesUtil.clearOldVariables(store);
        EnvironmentVariablesUtil.setEnvironmentVariables(store, new EnvironmentVariableCollection());
    }

    public static EnvironmentVariableCollection getEnvironmentVariables(IPreferenceStore store) {
        EnvironmentVariableCollection vars = (EnvironmentVariableCollection)SerializerUtil.fromStringSafe(store.getString("envVars"));
        return null == vars ? new EnvironmentVariableCollection() : vars;
    }

    public static void setEnvironmentVariables(IPreferenceStore store, EnvironmentVariableCollection vars) {
        EnvironmentVariablesUtil.clearOldVariables(store);
        store.setValue("envVars", SerializerUtil.toStringSafe(vars));
        EnvironmentVariablesUtil.applyVariables(store, true);
    }

    public static Map<String, EnvironmentVariable> getNativeEnvironment() {
        Map stringVars = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        HashMap<String, EnvironmentVariable> vars = new HashMap<String, EnvironmentVariable>();
        for (Map.Entry entry : stringVars.entrySet()) {
            vars.put((String)entry.getKey(), new EnvironmentVariable((String)entry.getKey(), (String)entry.getValue()));
        }
        return vars;
    }
}

